/***************************************************************************
                         subobjectmodifier.cpp  -  description
                            -------------------
   begin                : Sun Apr 22 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "subobjectmodifier.h"
#include <Entities/mesh.h>
#include <Entities/subobject.h>
#include <Entities/vertex.h>

SubObjectModifier::SubObjectModifier( int type ) : Modifier( type )
{
}

SubObjectModifier::~SubObjectModifier()
{}

//must follow an assert selected...

bool SubObjectModifier::assertSameParent()
{

   Entity * parent = getSubObjectParent();
   SelectionIterator it = m_selection -> begin();

   while ( it != m_selection -> end() )
   {

      Entity * e = static_cast<SubObject*>( *it ) -> getParentObject();

      if ( parent != e )
      {
         warnNotSameParent();
         setStatusDone();
         return false;
      }

      ++it;

   }

   return true;
}

vector<int> SubObjectModifier::getSubObjectList()
{
   vector<int> so;
   so.reserve( m_selection -> size() );

   SelectionIterator it = m_selection -> begin();

   while ( it != m_selection -> end() )
   {

      so.push_back( static_cast<SubObject *>( *it ) -> getParentIndex() );
      ++it;

   }

   return so;
}

Mesh * SubObjectModifier::getSubObjectParent()
{

   SelectionIterator it = m_selection -> begin();
   Object * o = static_cast<SubObject *>( *it ) -> getParentObject();
   return static_cast<Mesh *>( o );

}

/** Need to take care of scaling faces/edges here...
  */
void SubObjectModifier::startTransform()
{
   m_cmds.clear();

   SelectionIterator it = m_selection -> begin();

   while ( it != m_selection -> end() )
   {

      SubObject * s = static_cast<SubObject *>( *it );

      /* if this subobject has a list of vertices, then
       * the transform will actually be applied to those,
       * not the containing subobject, so we'll checkpoint
       * those instead.
       */

      if ( s -> getNumVerts() != 0 )
      {

         for ( int i = 0; i < s->getNumVerts(); i++ )
         {

            Vertex *v = s -> getVertPtr( i );
            TransformCmd *tc = new TransformCmd( v );
            tc -> begin();
            m_cmds.insert( CommandPair( v, tc ) );

         }

      }

      else
      {

         TransformCmd *tc = new TransformCmd( s );
         tc -> begin();
         m_cmds.insert( CommandPair( s, tc ) );

      }

      ++it;

   }
}

void SubObjectModifier::endTransform()
{
   TransactionCommand * tc = new TransactionCommand();

   CommandMap::iterator it = m_cmds . begin();

   while ( it != m_cmds . end() )
   {

      TransformCmd * c = static_cast<TransformCmd *>( it -> second );
      c -> end();
      tc -> addCommand( c );
      ++it;

   }

   // we don't need to execute the command...
   tc -> save();

}

void SubObjectModifier::copy()
{

}
void SubObjectModifier::paste()
{

}
void SubObjectModifier::cut()
{

}
