/***************************************************************************
                         primitiveecreator.cpp  -  description
                            -------------------
   begin                : Thu Apr 19 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "primitivecreator.h"
#include <Entities/primitive.h>
#include <i3d.h>
#include <i3dworkspace.h>

#include "vertexmodifier.h"

int PrimitiveCreator::TYPE = IControl::getUID();

PrimitiveCreator::PrimitiveCreator()
{
   setName( "&Primitive..." );
   m_popup -> insertItem( "&Points", this, SLOT( slotCreatePoints() ) );
   m_popup -> insertItem( "&Triangles", this, SLOT( slotCreateTriangles() ) );
   m_popup -> insertItem( "&Quads", this, SLOT( slotCreateQuads() ) );
   m_popup -> insertItem( "T&riangle Strip", this, SLOT( slotCreateTStrip() ) );
   m_popup -> insertItem( "Q&uad Strip", this, SLOT( slotCreateQStrip() ) );

   m_primitive = 0;
}

PrimitiveCreator::~PrimitiveCreator()
{
}


void PrimitiveCreator::mousePress ( Vector4 &plane, Vector4 &pt, int btn )
{
   if ( m_primitive != 0 )
   {
      cerr << "Extending primitive" << endl;

      if ( m_primitive -> numVerts() == 0 )
      {

         TransactionCommand * c = new TransactionCommand();
         Command *dbc = new DBCommand( m_primitive, ADD );
         dbc -> execute();

         Command *pc = new CheckPointCmd( m_primitive );
         m_primitive -> extend( pt );

         c -> addCommand( dbc );
         c -> addCommand( pc );
         c -> save();

      }

      else
      {

         Command *c = new CheckPointCmd( m_primitive );
         c->save();
         m_primitive -> extend( pt );

      }

   }

   else
   {
      cerr << "No primitive to extend." << endl;
   }

}

void PrimitiveCreator::keyEvent ( QKeyEvent *key )
{
   if ( key->key() == Key_Space )
   {
      //m_primitive = 0;
      I3D::getWorkspace() -> revertControl();
   }

   setStatusDone();
}

void PrimitiveCreator::activate()
{
   /* First, activate the vertex modifier, so the
    * verts will get rendered, and we'll be in vertex
    * mode when we are done.
    */ 
   //   --
   I3D::activateControl( VertexModifier::TYPE );
   I3D::setModeMsg( " Create Mode " );
   I3D::getWorkspace() -> setCurrentControl( this );

}

void PrimitiveCreator::deactivate()
{

   if ( m_primitive != 0 && m_primitive -> numVerts() == 0 )
      delete m_primitive;
   else
      m_primitive -> terminate();
}

void PrimitiveCreator::slotCreatePoints()
{

   activate();
   m_primitive = new Primitive( Primitive::POINTS );
   setStatus( "Creating points:  Click to add pts. Space to Quit" );

}

void PrimitiveCreator::slotCreateTriangles()
{

   activate();
   m_primitive = new Primitive( Primitive::TRIANGLES );
   setStatus( "Creating triangles:  Click to add pts. Space to Quit" );
}

void PrimitiveCreator::slotCreateQuads()
{

   activate();
   m_primitive = new Primitive( Primitive::QUADS );
   setStatus( "Creating quads:  Click to add pts. Space to Quit" );
}

void PrimitiveCreator::slotCreateTStrip()
{

   activate();
   m_primitive = new Primitive( Primitive::TRISTRIP );
   setStatus( "Creating triangle strip:  Click to add pts. Space to Quit" );
}

void PrimitiveCreator::slotCreateQStrip()
{

   activate();
   m_primitive = new Primitive( Primitive::QUADSTRIP );
   setStatus( "Creating quad strip:  Click to add pts. Space to Quit" );
}

