#ifndef CONFIGDLG_H
#define CONFIGDLG_H
#include "iconfig.h"
#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>

#include <string>

class ConfigDlg : public IConfig
{ 
    Q_OBJECT

public:
    ConfigDlg( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~ConfigDlg();

    void setTexturePath( string s ) { fldTexturePath -> setText( s.c_str() ); };
    void setScenePath  ( string s )   { fldScenePath -> setText( s.c_str() ); };
    void setPluginPath ( string s )  { fldPluginPath -> setText( s.c_str() ); };

    string getTexturePath( ) { return fldTexturePath -> text().ascii(); };
    string getPluginPath( )  { return fldPluginPath -> text().ascii(); };
    string getScenePath( )   { return fldScenePath -> text().ascii(); };

    int getGridSize() { return spnGridSize -> value(); };
    int getGridSpacing() { return spnGridSpacing -> value(); };

    void load();
    void save();


//    bool
public slots:
    void slotCancel();
    void slotApply();
    void slotChangePluginPath();
    void slotChangeScenePath();
    void slotChangeTexturePath();
    void slotOK();

};

#endif // CONFIGDLG_H
