/***************************************************************************
                         texture.h  -  description
                            -------------------                     
   begin                : Wed Mar 10 1999                         
   copyright            : (C) 1999 by Jon Anderson                         
   email                : ande1514@tc.umn.edu                   
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef TEXTURE_H
#define TEXTURE_H

#include "qgl.h"
#include "qimage.h"
#include "qpixmap.h"
#include <iostream.h>
#include "qcolor.h"
#include <stdlib.h>

/** This class provides the functionality for loading image files from disk.
  * The images are converted to the OpenGL format and made available for 
  * rendering
  * The original image data is also available for use (as in displaying).
  *@author Jon Anderson
  */

class Texture
{
   public:
      Texture( QString s, int index );
      Texture( void );
      ~Texture( void );

      QPixmap *getPixmap() { return pixmap;};

      QString *getFilename() { return file;};

      GLint getID() { return tex_id;};

      QRgb getRGB( int x, int y );
      int getHeight();
      int getWidth();
      int getTextureIndex() { return index;};

      QImage * loadRgb( QString s );

      static QPixmap convertBytesToPixmap( unsigned char *data, int width, int height );
   private:
      /**used for I/O */
      QImage *image;

      /**Used for display */
      QPixmap *pixmap;
      /**OpenGL texture ID */
      GLuint tex_id;
      int index;

      QString *file;
};

#endif






























