
/***************************************************************************
                          sphere.h  -  description                              
                             -------------------                                         
    begin                : Tue Aug 3 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SPHERE_H
#define SPHERE_H

#include "mesh.h"

class Midpoint;

/**A Sphere Object.  This is simply a wrapper subclass for Object that knows how to
construct a sphere object.  Sphere can be constructed with parameters to determine it's
LOD.
  *@author Jon Anderson
  */

class Sphere : public Mesh
{
   public:
      Sphere( float x = 0, float y = 0, float z = 0, int lod = 0, int radius = 1 );
      ~Sphere();
      void vertex_subdivide( Vertex *v1, Vertex *v2, Vertex *v3, int depth );
      Midpoint findMidpoint( Vertex *v1, Vertex *v2 );


   protected:
      list<Midpoint> midpoints;
      float m_radius;
};

class Midpoint
{
   public:
      Vertex *v1;
      Vertex *v2;
      Vertex *m;

      bool operator==( const Midpoint &rhs ) const
      {
         if ( v1 == rhs.v1 && v2 == rhs.v2 )
            return true;

         if ( v2 == rhs.v1 && v1 == rhs.v2 )
            return true;

         return false;
      }

};


#endif








