/***************************************************************************
                         metaball.cpp  -  description                              
                            -------------------                                         
   begin                : Tue Nov 16 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "metaball.h"
#include "GL/glut.h"

int MetaBall::TYPE = Typed::getUID();

MetaBall::MetaBall( float x, float y, float z, Entity *p ) : IsoSurface( x, y, z, p )
{

   addType( TYPE );
   radius = 1;
   strength = 1;
   maxdist = 2;

}

MetaBall::~MetaBall()
{}

int MetaBall::draw( int d_options = 0 )
{

   // if(isDirty()){     //if it's dirty and needs to be redrawn
   // glNewList(glID, GL_COMPILE_AND_EXECUTE);
   glPushMatrix();
   glDisable( GL_TEXTURE_2D );

   Matrix44 m;
   getCompleteMatrix( &m );
   glMultMatrixf( ( GLfloat * ) m.m );


   //if(app_mode->getSelectMode() == SELECT_IMPLICIT){
   glPushName( getID() );
   //}

   if ( selected )
      glColor4f( 1, 0, 0, 1 );
   else
      glColor4f( 1, 1, 1, 1 );


   glutWireSphere( radius, 10, 10 );

   glPopName();

   glPopMatrix();

   // glEndList();
   // setDirty(false);
   // }//if dirty
   // else
   //   glCallList(glID);

   return 0;
}

bool MetaBall::isIn( float x, float y, float z )
{
   return false;
}

float MetaBall::getField( float r )
{

   if ( r > radius )
      return 0;

   //softobject
   float r2 = r * r;

   float r4 = r2 * r2;

   float r6 = r4 * r2;

   float b2 = radius * radius;

   float b4 = b2 * b2;

   float b6 = b4 * b2;

   float field = strength * ( 1 - ( ( 4 * r6 ) / ( 9 * b6 ) ) + ( ( 17 * r4 ) / ( 9 * b4 ) ) - ( ( 22 * r2 ) / ( 9 * b2 ) ) );

   return field;

}
