/***************************************************************************
                         line.h  -  description                              
                            -------------------                                         
   begin                : Sat Aug 14 1999                                           
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef LINE_H
#define LINE_H

//local includes
#include "spline.h"

class Poly;


class Line : public Spline
{
   public:
      Line( vector<Vector4 > &_verts, Entity *parent = 0 );
      Line( Vector4 &p, Entity *parent = 0 );
      Line( Entity *parent = 0 );

      virtual void copyFrom( Entity * );

      virtual ~Line();
      virtual int draw( int d_options = 0 );

      virtual Entity * sweep( Spline &s );
      virtual Entity * revolve( Spline &s, int degrees, int segments );

      void reverse();
      void closeSpline();
      void breakSpline();
      Line & operator=( Line&rhs );
      Line & operator=( Poly&rhs );

      virtual Entity * clone();

      void extend( Vector4 & );

      static int TYPE;

   private:
      Line * getProfile( Vector4 &, Vector4 &, Vector4 & );

};

#endif



















