/***************************************************************************
                         grid.h  -  description
                            -------------------
   begin                : Sun Mar 4 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GRID_H
#define GRID_H

#include <Math/matrix44.h>
#include <Math/vector4.h>

/** Class used for rendering helper grids in the viewports.
  * It has configurable spacing and size.
  *
  * @author Jon Anderson
  */

class Grid
{

   public:
      Grid( Matrix44 &m );
      ~Grid();


      void draw( int d_options = 0 );

      void setLightColor( Vector4 &c ) { m_light = c; };

      void setDarkColor ( Vector4 &c ) { m_dark = c; };

      static void setSize( int m ) { m_size = m; };

      static void setSpacing( int m ) { m_spacing = m;};

   private:

      static int m_size;
      static int m_spacing;

      Vector4 m_light;
      Vector4 m_dark;

      /** The grid is always drawn on the XZ plane.
        * This matrix determines how to transform the grid
        * to appear on other planes.
        */
      Matrix44 m_matrix;

};

#endif
