/***************************************************************************
                          configdialog.cpp  -  description
                             -------------------
    begin                : Fri Feb 11 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "configdialog.h"
#include "qdir.h"
#include "qmessagebox.h"
#include "../i3d.h"
#include "../i3dworkspace.h"
#include "../i3ddoc.h"
#include <qlist.h>
#include <qfiledialog.h>

#include <fstream.h>

ConfigDialog::ConfigDialog(QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	initDialog();
}

void ConfigDialog::init()
{
	load();
	connect(btnOk, SIGNAL(clicked()), SLOT(ok()));
	connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));
	connect(btnApply, SIGNAL(clicked()), SLOT(apply()));
	
	connect(btnBrowseMaterial, SIGNAL(clicked()), SLOT(slotTextureDir()));
	connect(btnBrowsePlugin, SIGNAL(clicked()), SLOT(slotPluginDir()));
	connect(btnBrowseScene, SIGNAL(clicked()), SLOT(slotSceneDir()));		

}

ConfigDialog::~ConfigDialog()
{
	save();
}

void ConfigDialog::show()
{
  fldMaterials->setText(t_dir);
  fldPlugins->setText(p_dir);
  fldScenes->setText(s_dir);
  chk3DWireframe->setChecked(wireframe_3d);
  chkWireMove->setChecked(wireframe_move);
  chkWireframe->setChecked(wireframe);
  chkFilledWireframe->setChecked(wireframe_filled);

  chkSmooth->setChecked(smooth_shaded);
  chkSmoothTextures->setChecked(smooth_textures);

  spnGridSpacing->setValue( (int) grid_spacing);
  spnGridSize->setValue((int)grid_size);

  QDialog::show();

}

void ConfigDialog::apply()
{
 	t_dir = fldMaterials->text();
 	p_dir = fldPlugins->text();
 	s_dir = fldScenes->text();
 	
 	wireframe_3d     = chk3DWireframe->isChecked();
 	wireframe_move   = chkWireMove->isChecked();
 	wireframe        = chkWireframe->isChecked();
 	wireframe_filled = chkFilledWireframe->isChecked();
 	
 	smooth_shaded   = chkSmooth->isChecked();
 	smooth_textures = chkSmoothTextures->isChecked();
 	
 	//convert to 10ths.
 	grid_spacing = (float) spnGridSpacing->value() / 10;
 	grid_size = spnGridSize->value();
 	
 	applySettings();
}

void ConfigDialog::initDefault()
{
 t_dir = QDir::homeDirPath();
 p_dir = "/usr/local/i3d/Plugins";
 s_dir = QDir::homeDirPath();

 wireframe_3d     = false;
 wireframe_move   = false;
 wireframe_filled = true;
 wireframe        = false;

 smooth_shaded    = true;
 smooth_textures  = true;

 grid_spacing = 5;
 grid_size = 10;

 I3D::getInstance()->setGeometry(0, 0, 800, 600);

}

void ConfigDialog::applySettings()
{
/*
  I3DWorkspace *w = I3D::getWorkspace();

	if(w == 0)
		return;

  w->set3DMoveWireframe(wireframe_move);
  w->set2DWireframe(wireframe);
  w->set3DWireframe(wireframe_3d);
//  w->setGridSpacing(grid_spacing);
//  w->setGridSize(grid_size);
  w->setSmoothShaded(smooth_shaded);

  I3D::updateViews();
*/
}
void ConfigDialog::slotTextureDir()
{
  QString ndir = QFileDialog::getExistingDirectory(t_dir);
  if(ndir.isEmpty())
  	return;
  t_dir = ndir;
  fldMaterials->setText(t_dir);

}
void ConfigDialog::slotPluginDir()
{
	QString ndir = QFileDialog::getExistingDirectory(p_dir);
  if(ndir.isEmpty())
  	return;
  p_dir = ndir;
  fldPlugins->setText(p_dir);

}
void ConfigDialog::slotSceneDir()
{
  QString ndir = QFileDialog::getExistingDirectory(s_dir);
  if(ndir.isEmpty())
  	return;
  s_dir = ndir;
  fldScenes->setText(s_dir);
}

void ConfigDialog::ok()
{
	apply();
	accept();
}

void ConfigDialog::load()
{
 QString cfgrc = QDir::homeDirPath();
 cfgrc += "/.i3drc";
 ifstream in;
 in.open(cfgrc, ios::in);
	
 if(!in){
 	QMessageBox::information(this, "I3D", "Welcome to I3D. I3D will now\n"
 																				"setup it's default options.");
	initDefault();
	applySettings();
	return;
 }
 char buffer[256];

 in>>buffer>>ws;      //read in directories tag;
 cerr<< buffer<<endl;

 in>>buffer>>ws;
 t_dir = buffer;

 in>>buffer>>ws;
 p_dir = buffer;

 in>>buffer>>ws;
 s_dir = buffer;

 in>>buffer>>ws;    //read in render options tag;
 in>>wireframe_3d>>wireframe_move>>wireframe_filled>>wireframe;
 in>>smooth_shaded>>smooth_textures>>ws;

 in>>buffer>>ws;  //read in teh grid tag.
 in >> grid_size >> grid_spacing >> ws;

 in>>buffer>>ws;    //read in app options tag;
 int x,y;
 in>>x>>y>>ws;
 I3D::getInstance()->setGeometry(0, 0, x, y);


 in>>buffer>>ws;    //read in recent files tag;
 QList<QString> list;
 in>>buffer>>ws;
 while(buffer !=0 && (strcmp(buffer, "") != 0)){
 	QString *str = new QString();
 	*str = buffer;
 	list.append(str);
 	in>>buffer>>ws;
 }
 I3D::getInstance()->setRecentFiles(list);
 applySettings();
}

void ConfigDialog::save()
{
 QString cfgrc = QDir::homeDirPath();
 cfgrc += "/.i3drc";

 ofstream out;
 out.open(cfgrc, ios::out);
	
 if(!out){
 	cerr<<"Unable to open file:"<<cfgrc<<endl;
		return;
	}
	
	out << "[Directories]" <<endl;
	out << t_dir.ascii() <<endl;
	out << p_dir.ascii() <<endl;
	out << s_dir.ascii() <<endl;
	
	out << "[RenderOptions]" <<endl;
	out << wireframe_3d<<" " <<wireframe_move<<" "<<wireframe_filled<<" "<<wireframe<<" ";
	out << smooth_shaded<<" " <<smooth_textures<<endl;
	out << "[GridOptions]" << endl;
	out << grid_size << " " <<grid_spacing << endl;
	
	out << "[AppOptions]" <<endl;
	QSize s= I3D::getInstance()->size();
	out<< s.width()<<" "<<s.height()<<endl;
	
	out << "[RecentFiles]"<<endl;
	QList<QString> list;
	list = I3D::getInstance()->getRecentFiles();
	for (QString *str = list.first(); str!=0; str= list.next() ) {
		out << str->ascii()<<endl;
	}
}
