/***************************************************************************
                          rotatecommand.h  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ROTATECOMMAND_H
#define ROTATECOMMAND_H

#include "propertycommand.h"
#include <Entities/entity.h>

/** Encapsulates a request to rotate an entity.
  *@author Jon Anderson
  */

class RotateCommand : public PropertyCommand  {
public: 
	RotateCommand(Transformable *_e, Vector4 &s, Vector4 &p);
	~RotateCommand();
  /** Rotate the entity to the old orientation. */
  bool undo();
  /** Rotate the Entity to the new location. */
  bool execute();
protected:
	Vector4 newAmount;
	Vector4 oldAmount;
	Vector4 pt;
	
};

#endif
