/***************************************************************************
                          listcommand.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "listcommand.h"
#include <objectdb.h>
#include <Entities/entity.h>
#include <algorithm>



ListCommand::ListCommand(Selectable * e, vector<Selectable * > *_list, int _command)
   :
   m_oldContents()
{
	m_item = e;

	m_list = _list;
	
   m_oldContents.reserve( _list -> size() );

   std::copy( _list -> begin(), _list -> end(), std::back_inserter( m_oldContents) );

  command = _command;
}
ListCommand::~ListCommand()
{

}
bool ListCommand::execute()
{
  switch(command){
  	case CLEAR:
  		m_list -> clear();
  		return true;
  		break;
  	case ADD:
  	   m_list -> push_back( m_item );
  		return true;
  		break;
  	case REMOVE:
  		m_list -> erase( std::find( m_list->begin(), m_list->end(), m_item ));
  		return true;
  		break;
  	default:
  		return false;
  		break;
  }

}
bool ListCommand::undo()
{
	//cerr<<"Undoing list command"<<endl;
	switch(command){
		case CLEAR:
         m_list -> clear();
         std::copy( m_oldContents.begin(), m_oldContents.end(), std::back_inserter( *m_list ) );
			return true;
			break;
		case ADD:
			m_list -> erase( std::find( m_list->begin(), m_list->end(), m_item));
			return true;
			break;
		case REMOVE:
			m_list -> push_back( m_item );
			return true;
			break;
		default:
			return false;
			break;
	}
}


