/***************************************************************************
                          genericcommand.h  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef GENERICOMMAND_H
#define GENERICCOMMAND_H

#include "entitycommand.h"
#include <Entities/entity.h>
/** A GenericCommand is used for any operation on an Entity that does not
  * have a specific Command.  A GenericCommand  maintains 2 entities, the original
  * and a newly modified one.  The command copies one entity into the other.
  * In order for the GenericCommand to be useful, copy constructors for Entities
  * must be available.
  *@author Jon Anderson
  */

class GenericCommand : public EntityCommand  {
public: 
	GenericCommand(Transformable *eOld, Transformable *eNew);
	~GenericCommand();
public: // Public attributes
  /** A pointer to a new entity that will replace the old one. */
  Transformable * newEntity;
  /** Swap the new entity with the old one. */
  bool undo();
  /** Swap the old entity with the new one. */
  bool execute();

};


#endif
