#include "hex.h"

/********************************************************\
 * Description: deletes an item from the linked list and*
 *	 	returns the head of the linked list.    *
\********************************************************/	
hexList *deleteNode(hexList *head, int loc)
{
    if (head == NULL)					/* if NULL            */
        return head;					/* just return        */
    else if (head->loc > loc)
	return head;
    else if (head->loc < loc) 				/* if loc > current   */
        head->next = deleteNode(head->next, loc);	/* go to next list    */
    else if (head->loc == loc)				/* if correct loc     */
    {
        hexList *tmpHead = head;
        head = head->next;				/* "delete" it        */
        free(tmpHead);					/* free the memory    */
    }

        /*printDebug(head, loc);*/

    return head;
}

/********************************************************\
 * Description: inserts an item into the linked list and*
 *	 	returns the head of the linked list.    *
\********************************************************/	
hexList *insertItem(hexList *head, int loc, int val)
{
    if (head == NULL)					/* if NULL create item*/
    {
	head = llalloc();                   		/* allocate space     */
        head->loc = loc;          			/* store current line */
	head->val = val;				/* store value        */
        head->next = NULL;				/* make next = NULL   */
    }
    else if (head-> loc == loc)
    {
	hexList *tmpHead;				/* create new tmp item*/
	tmpHead  = llalloc();				/* allocate space     */
	tmpHead->loc = loc;				/* store the location */
	tmpHead->val = val;				/* store the value    */
	tmpHead->next = head;				/* point next to head */
	head = tmpHead;					/* point head to tmp  */
    }
    else if (head->loc < loc || head->next == NULL) 	/* recursively call it*/
    	head->next = insertItem(head->next, loc, val);
							/* insert into list  */
    else if (head->next != NULL && head->next->loc >= loc)
    {
	hexList *tmpHead;				/* create new tmp item*/
	tmpHead  = llalloc();				/* allocate space     */
	tmpHead->loc = loc;				/* store the location */
	tmpHead->val = val;				/* store the value    */
	tmpHead->next = head;				/* point next to head */
	head = tmpHead;					/* point head to tmp  */
    }

    return head;                               		/* return the head    */
}   

/********************************************************\
 * Description: Search through the linked list for to   *
 *		check if loc exist in the list. The     *
 *		function returns -1 if not found or a   *
 *		positve int of the modified value       * 
\********************************************************/
int searchList(hexList *head, int loc)
{   
    hexList *tmpHead  = llalloc();			/* allocate temp space*/
    tmpHead = head;					/* temp points to head*/
    while (tmpHead != NULL)				/* while not null     */
    {
        if (tmpHead->loc == loc)			/*if loc == return val*/
            return tmpHead->val;
	else
	    tmpHead = tmpHead->next;			/* move to next item  */
    }
    return -1;
}

/********************************************************\
 * Description: write the changes to either the current *
 *		file or to a specified output file	*
\*******************************************************/
int writeChanges(WINS *win, FILE *fpIN, FILE *fpOUT, hexList *head,
		  char *fpINfilename, char *fpOUTfilename)
{   
    unsigned int buff;					/* declare llist vars */
    hexList *tmpHead;
    tmpHead = llalloc();
    tmpHead = head;

    if ((fpOUT = fopen(fpOUTfilename, "w+")) && fpIN)
    {							/* open the write file*/
        rewind(fpIN);					/* set file loc to 0  */
	rewind(fpOUT);					
	while ((buff = fgetc(fpIN)) != EOF)		/*write to file buffer*/
	    fputc(buff, fpOUT);
    }
    else if (!fpOUT && fpIN)				/* if no output file  */
    {
	if (!(fpOUT = freopen(fpINfilename, "r+", fpIN)) || *fpOUTfilename)
	{
            popupWin("Cannot write to file: bad permissions", -1);

	    return 1;
	}
    }
    else
    {
        popupWin("No data written.", -1);

	return 1;
    }

    rewind(fpIN);
    rewind(fpOUT);
    while (tmpHead != NULL)				/* write to file      */
    {
	fseek(fpOUT, tmpHead->loc, SEEK_SET);
	fputc(tmpHead->val, fpOUT);
	tmpHead = tmpHead->next;
    }
    fpIN = fpOUT;
    rewind(fpIN);					/* reset file pointer */
    rewind(fpOUT);					/* to the beginning   */

    return 0;

} 

/********************************************************\
 * Description: recursivly frees all the memory that was*
 *		allocated via malloc(), this avoids     *
 *		memory leaks that exist far too many    *
 *		programs that you have to pay to use    *
\********************************************************/
hexList *freeList(hexList *head)
{
    if (head) 						/* while head != NULL */
    {
        freeList(head->next);				/* check next item    */
        free(head);					/* free the memory    */
    }
    return NULL;					/* return NULL to head*/
} 
