module Control.Functor.HT where

import Data.Tuple.HT (fst3, snd3, thd3, )


void :: Functor f => f a -> f ()
void = fmap (const ())

map :: Functor f => (a -> b) -> f a -> f b
map = fmap

for :: Functor f => f a -> (a -> b) -> f b
for = flip fmap

unzip :: Functor f => f (a, b) -> (f a, f b)
unzip x = (fmap fst x, fmap snd x)

unzip3 :: Functor f => f (a, b, c) -> (f a, f b, f c)
unzip3 x = (fmap fst3 x, fmap snd3 x, fmap thd3 x)
