module Main where

import Graphics.Rendering.Diagrams

sierpinski :: Int -> Diagram
sierpinski 0 = fc black $ lw 0 $ rotRegPoly 3 1 (-1/4)
sierpinski n = vcatA hcenter [         s
                             ,      s <> s]
  where s = sierpinski (n-1)

main = renderAs PNG "sierpinski.png" (Height 300) (sierpinski 6)

