/* $Id: nsdat.h,v 1.7 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

template<typename N, typename E>
struct NSNode {
	int rank;
	int low,lim;
	int priority;
	E paredge;
	E tree[2];
	bool mark,dmark,onstack;
	bool brandNew;
	NSNode() : brandNew(true) {
		reset();
	}
	void reset() {
		rank = low = lim = priority = 0;
		paredge = tree[INEDGE] = tree[OUTEDGE] = 0;
		mark = dmark = onstack = false;
	}
};
template<typename N, typename E>
struct NSEdge {
	int cutval;
	int weight;
	int minlen;
	E prv[2],nxt[2];
	bool treeflag;
	bool brandNew;
	NSEdge() : weight(1),minlen(1),brandNew(true) {
		reset();
	}
	void reset() {
		cutval = 0;
		treeflag = false;
		prv[INEDGE] = prv[OUTEDGE] = nxt[INEDGE] = nxt[OUTEDGE] = 0;
	}
};
template<typename N, typename E>
struct NSData {
	int n_tree_edges;
	int maxiter;
	N finger;
	bool brandNew;
	NSData() : maxiter(INT_MAX),brandNew(true) {
		reset();
	}
	void reset() {
		n_tree_edges = 0;
		finger = 0;
	}
};
