/* $Id: getCrossoptModelNodes.cpp,v 1.6 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.6 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "dynadag/DynaDAG.h"
namespace DynaDAG {

void getCrossoptModelNodes(Layout &nodes,Layout &edges,NodeV &out) {
	for(Layout::node_iter ni = nodes.nodes().begin(); ni!=nodes.nodes().end(); ++ni) 
		for(DDMultiNode::node_iter mnni = DDp(*ni)->nBegin(); mnni!=DDp(*ni)->nEnd(); ++ mnni)
			out.push_back(*mnni);
	int ec=0;
	for(Layout::graphedge_iter ei = edges.edges().begin(); ei!=edges.edges().end(); ++ei,++ec)
		for(DDPath::node_iter pni = DDp(*ei)->nBegin(); pni!=DDp(*ei)->nEnd(); ++ pni)
			out.push_back(*pni);
	loops.Field(r_crossopt,"layout nodes for crossopt",nodes.nodes().size());
	loops.Field(r_crossopt,"layout edges for crossopt",ec);

}

}
