/* $Id: reorient.h,v 1.5 2005/04/05 12:02:55 ellson Exp $ $Revision: 1.5 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/
struct ReorientBadDir : DGException {
	ReorientBadDir() : DGException("bad direction argument to reorient()") {}
};
Coord reorient(Coord val,bool in,Orientation dir) {
	Coord ret;
	switch(dir) {
	case DG_ORIENT_UP:
		ret.x = -val.x;
		ret.y = -val.y;
		break;
	case DG_ORIENT_DOWN:
		ret.x = val.x;
		ret.y = val.y;
		break;
	case DG_ORIENT_LEFT:
		if(in)
			goto right;
	left:
		ret.x = val.y;
		ret.y = -val.x;
		break;
	case DG_ORIENT_RIGHT:
		if(in)
			goto left;
	right:
		ret.x = -val.y;
		ret.y = val.x;
		break;
	default:
		throw ReorientBadDir();
	}
	return ret;
}
