// -*- c++ -*-
//------------------------------------------------------------------------------
//                              VCard.h
//------------------------------------------------------------------------------
// $Id: VCard.h,v 1.7 2006/09/06 02:07:59 vlg Exp $
//
// Date: Apr 24 2004
//------------------------------------------------------------------------------
#ifndef VCARD_H
#define VCARD_H

#include <string>
using std::string;

#include <glibmm/ustring.h>
using Glib::ustring;

#include <assa/TimeVal.h>

class VCard 
{
public:
	VCard () : m_dirty (false), m_reversed (false) { /* no-op */ }
	virtual ~VCard () { /* no-op */ }

	virtual void set_question     (const ustring& q_) = 0;
	virtual void set_answer       (const ustring& a_) = 0;
	virtual void set_example      (const ustring& e_) = 0;
	virtual void set_alt_spelling (const ustring& a_) = 0;

	virtual ustring get_question     () const = 0;
	virtual ustring get_answer       () const = 0;
	virtual ustring get_example      () const = 0;
	virtual ustring get_alt_spelling () const = 0;
	virtual long    get_id           () const = 0;

	void set_reversed (bool r_) { m_reversed = r_;   }
	bool get_reversed () const  { return m_reversed; }

	virtual void set_expiration (const ASSA::TimeVal&) { /* no-op */ }
	virtual ASSA::TimeVal get_expiration () const;

	void mark_dirty   () { m_dirty = true; }
	void mark_clean   () { m_dirty = false; }
	bool is_dirty     () const { return m_dirty; }
	string get_id_str ();

	virtual void dump () const = 0;

	/** Comparison by the expiration date
	 */
	bool operator<  (const VCard& rhs_);
	bool operator== (const VCard& rhs_);

protected:
	virtual bool less_then_expiration (const VCard& rhs_) = 0;
	virtual bool equal_expiration (const VCard& rhs_) = 0;

protected:
	/// Has the card being modified?
	bool m_dirty;

	/// Is this card backward-oriented?
	bool m_reversed;
};

inline bool
VCard::
operator< (const VCard& rhs_)
{
	return (less_then_expiration (rhs_));
}

inline bool
VCard::
operator== (const VCard& rhs_)
{
	return (equal_expiration (rhs_));
}

inline ASSA::TimeVal VCard::get_expiration () const
{
	return (ASSA::TimeVal (0));
}

#endif /* VCARD_H */
