<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        if ($this->template->security && isset($this->smarty->security_handler)) {
              $this->sec_obj = $this->smarty->security_policy;
        } else {
              $this->sec_obj = $this->smarty;
        }
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       assert($tag !== false && $count === 1);
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       assert($tag_text === '?>');
       return '?<?php ?>>';
    }

    
#line 126 "smarty_internal_templateparser.php"

    const TP_COMMENT                        =  1;
    const TP_PHPSTARTTAG                    =  2;
    const TP_PHPENDTAG                      =  3;
    const TP_OTHER                          =  4;
    const TP_FAKEPHPSTARTTAG                =  5;
    const TP_PHP_CODE                       =  6;
    const TP_PHP_CODE_START_DOUBLEQUOTE     =  7;
    const TP_PHP_CODE_DOUBLEQUOTE           =  8;
    const TP_PHP_HEREDOC_START              =  9;
    const TP_PHP_HEREDOC_END                = 10;
    const TP_PHP_NOWDOC_START               = 11;
    const TP_PHP_NOWDOC_END                 = 12;
    const TP_PHP_DQ_CONTENT                 = 13;
    const TP_PHP_DQ_EMBED_START             = 14;
    const TP_PHP_DQ_EMBED_END               = 15;
    const TP_LITERALSTART                   = 16;
    const TP_LITERALEND                     = 17;
    const TP_LITERAL                        = 18;
    const TP_LDEL                           = 19;
    const TP_RDEL                           = 20;
    const TP_DOLLAR                         = 21;
    const TP_ID                             = 22;
    const TP_EQUAL                          = 23;
    const TP_FOREACH                        = 24;
    const TP_PTR                            = 25;
    const TP_IF                             = 26;
    const TP_SPACE                          = 27;
    const TP_UNIMATH                        = 28;
    const TP_FOR                            = 29;
    const TP_SEMICOLON                      = 30;
    const TP_INCDEC                         = 31;
    const TP_TO                             = 32;
    const TP_AS                             = 33;
    const TP_APTR                           = 34;
    const TP_LDELSLASH                      = 35;
    const TP_INTEGER                        = 36;
    const TP_COMMA                          = 37;
    const TP_COLON                          = 38;
    const TP_MATH                           = 39;
    const TP_ANDSYM                         = 40;
    const TP_OPENP                          = 41;
    const TP_CLOSEP                         = 42;
    const TP_QMARK                          = 43;
    const TP_NOT                            = 44;
    const TP_TYPECAST                       = 45;
    const TP_DOT                            = 46;
    const TP_BOOLEAN                        = 47;
    const TP_NULL                           = 48;
    const TP_SINGLEQUOTESTRING              = 49;
    const TP_QUOTE                          = 50;
    const TP_DOUBLECOLON                    = 51;
    const TP_AT                             = 52;
    const TP_HATCH                          = 53;
    const TP_OPENB                          = 54;
    const TP_CLOSEB                         = 55;
    const TP_VERT                           = 56;
    const TP_ISIN                           = 57;
    const TP_ISDIVBY                        = 58;
    const TP_ISNOTDIVBY                     = 59;
    const TP_ISEVEN                         = 60;
    const TP_ISNOTEVEN                      = 61;
    const TP_ISEVENBY                       = 62;
    const TP_ISNOTEVENBY                    = 63;
    const TP_ISODD                          = 64;
    const TP_ISNOTODD                       = 65;
    const TP_ISODDBY                        = 66;
    const TP_ISNOTODDBY                     = 67;
    const TP_INSTANCEOF                     = 68;
    const TP_EQUALS                         = 69;
    const TP_NOTEQUALS                      = 70;
    const TP_GREATERTHAN                    = 71;
    const TP_LESSTHAN                       = 72;
    const TP_GREATEREQUAL                   = 73;
    const TP_LESSEQUAL                      = 74;
    const TP_IDENTITY                       = 75;
    const TP_NONEIDENTITY                   = 76;
    const TP_MOD                            = 77;
    const TP_LAND                           = 78;
    const TP_LOR                            = 79;
    const TP_LXOR                           = 80;
    const TP_BACKTICK                       = 81;
    const TP_DOLLARID                       = 82;
    const YY_NO_ACTION = 613;
    const YY_ACCEPT_ACTION = 612;
    const YY_ERROR_ACTION = 611;

    const YY_SZ_ACTTAB = 1771;
static public $yy_action = array(
 /*     0 */    19,   25,   98,   62,  192,  106,  376,  210,  202,   48,
 /*    10 */   224,  228,   42,  214,   22,  188,  129,  225,  330,   95,
 /*    20 */   202,   92,   11,   96,  143,   52,   50,   22,  300,  301,
 /*    30 */   312,   61,   97,  282,   65,   14,   19,  143,  100,  194,
 /*    40 */   344,  339,  202,  340,  141,   48,  612,   59,  273,  332,
 /*    50 */   335,  202,  129,  225,   60,  346,  345,   51,   26,  304,
 /*    60 */    28,   52,   50,  226,  300,  301,  312,   61,   47,   49,
 /*    70 */    65,   14,  264,   19,    9,   89,  209,  253,  344,  339,
 /*    80 */   328,  340,   48,  229,  267,   27,  362,  100,  157,  129,
 /*    90 */   225,    2,   60,   30,  345,   26,  317,   33,   52,   50,
 /*   100 */   202,  300,  301,  312,   61,  285,  240,   65,   14,   19,
 /*   110 */    22,   89,  209,   30,  310,  254,  317,   32,   48,   65,
 /*   120 */   143,   51,  269,  326,  266,  129,  225,  217,  258,  476,
 /*   130 */    51,    5,   47,   49,    8,   50,  476,  300,  301,  312,
 /*   140 */    61,   47,   49,   65,   14,   19,  216,   89,  199,   64,
 /*   150 */    22,  274,  324,  277,   48,  236,  275,  239,  475,  214,
 /*   160 */   143,  129,  225,   30,  368,  214,  317,   26,  187,  303,
 /*   170 */    52,   50,  351,  300,  301,  312,   61,    1,  218,   65,
 /*   180 */    14,   19,  303,  100,  203,  150,   30,  369,  202,  317,
 /*   190 */    48,  186,  100,  241,  127,   22,   30,  129,  225,  317,
 /*   200 */   304,  248,  256,   26,  202,  143,   52,   50,  391,  300,
 /*   210 */   301,  312,   61,  289,   39,   65,   14,   19,  191,  100,
 /*   220 */   213,   40,  109,    4,   65,   56,   48,   30,   22,  216,
 /*   230 */   317,   32,  287,  129,  225,  138,  270,  479,  143,   26,
 /*   240 */   386,  186,   52,   50,  479,  300,  301,  312,   61,  202,
 /*   250 */   304,   65,   14,   19,   29,  100,  200,   56,   30,  367,
 /*   260 */    30,  317,   48,  317,   39,  406,  313,    3,   10,  129,
 /*   270 */   207,   30,  370,  214,  317,   26,   23,  303,   52,   50,
 /*   280 */   156,  300,  301,  312,   61,   53,  186,   65,   14,   19,
 /*   290 */   293,   89,  193,  221,  352,  304,  388,  177,   48,  246,
 /*   300 */   320,  214,  319,  109,  350,  129,  225,  144,   56,  242,
 /*   310 */    63,   16,  303,  186,    8,   50,  147,  300,  301,  312,
 /*   320 */    61,  386,  304,   65,   14,   19,  186,  103,  209,  192,
 /*   330 */   202,  304,  281,  153,   48,  327,   83,   42,  293,  190,
 /*   340 */    41,  129,  225,  306,   53,  238,   90,    5,  304,   39,
 /*   350 */     8,   50,  164,  300,  301,  312,   61,  214,  202,   65,
 /*   360 */    14,   19,  186,   89,  209,   78,  271,  304,   43,  152,
 /*   370 */    48,  333,  332,  335,  220,  185,  350,  129,  225,  306,
 /*   380 */   262,  349,   63,   16,  304,   39,    8,   50,  146,  300,
 /*   390 */   301,  312,   61,   35,  348,   65,   14,   19,    9,  100,
 /*   400 */   213,  140,  404,  304,  261,  374,   48,  189,  360,  214,
 /*   410 */   373,  202,  214,  129,  225,  214,  304,  214,    9,   26,
 /*   420 */   202,   45,   52,   50,  245,  300,  301,  312,   61,  260,
 /*   430 */    90,   65,   31,  400,  396,  395,  397,  398,  399,  380,
 /*   440 */   379,  361,    6,    7,  296,  359,   13,   12,  358,  354,
 /*   450 */    18,   17,  342,  169,   68,   44,  202,  101,  290,  214,
 /*   460 */   168,  135,  353,  355,  356,   19,   30,  100,  208,  317,
 /*   470 */   375,  372,  268,  378,   48,   85,  304,  214,  214,  366,
 /*   480 */   214,  129,  225,  279,  278,  223,  214,   26,  306,  391,
 /*   490 */    52,   50,   66,  300,  301,  312,   61,   21,  173,   65,
 /*   500 */   133,    6,    7,  296,  359,   13,   12,  358,  354,   18,
 /*   510 */    17,  365,  389,  214,  391,  384,  186,  305,  214,  214,
 /*   520 */   181,  353,  355,  356,  214,  319,    6,    7,  296,  359,
 /*   530 */    13,   12,  358,  354,   18,   17,  364,  155,  323,   24,
 /*   540 */   322,  178,  202,  377,  357,  214,  353,  355,  356,  130,
 /*   550 */   214,  214,    6,    7,  296,  359,   13,   12,  358,  354,
 /*   560 */    18,   17,   30,  391,  252,  211,  159,  371,  314,  311,
 /*   570 */   142,  283,  353,  355,  356,  214,  214,  154,  214,  136,
 /*   580 */     6,    7,  296,  359,   13,   12,  358,  354,   18,   17,
 /*   590 */   215,   82,  304,   30,  304,  390,  247,  341,  331,   82,
 /*   600 */   353,  355,  356,  255,  214,    6,    7,  296,  359,   13,
 /*   610 */    12,  358,  354,   18,   17,  214,   70,  202,   45,  235,
 /*   620 */    90,  325,   90,  250,   82,  353,  355,  356,  128,  362,
 /*   630 */   400,  396,  395,  397,  398,  399,  380,  379,  361,  251,
 /*   640 */   205,  107,  391,  202,   45,  145,    6,    7,  296,  359,
 /*   650 */    13,   12,  358,  354,   18,   17,  400,  396,  395,  397,
 /*   660 */   398,  399,  380,  379,  361,  131,  353,  355,  356,    6,
 /*   670 */     7,  296,  359,   13,   12,  358,  354,   18,   17,  391,
 /*   680 */   334,   80,  299,  338,  347,   73,  132,  477,  257,  353,
 /*   690 */   355,  356,  175,  165,  477,   60,  475,  319,   19,  387,
 /*   700 */   391,  322,  387,  214,  151,  163,  180,  234,  304,  233,
 /*   710 */   302,  319,  233,  109,  129,  158,  109,   38,   88,  304,
 /*   720 */   304,  237,  315,  202,   45,  309,  321,  336,  309,  394,
 /*   730 */   304,  386,  202,   45,  386,  276,  400,  396,  395,  397,
 /*   740 */   398,  399,  380,  379,  361,  400,  396,  395,  397,  398,
 /*   750 */   399,  380,  379,  361,  403,  387,   34,   81,  337,   79,
 /*   760 */   318,  214,  387,  197,  183,  233,   74,  272,  124,  109,
 /*   770 */   401,  391,  233,  391,  227,   36,  109,  392,   93,  295,
 /*   780 */   201,  309,  294,  240,  405,   53,  294,  386,  309,   28,
 /*   790 */   202,   45,  363,  102,  386,  329,   71,   20,  111,  381,
 /*   800 */   229,   20,  263,  400,  396,  395,  397,  398,  399,  380,
 /*   810 */   379,  361,  387,  129,    1,   99,   23,  129,  265,  343,
 /*   820 */   204,  320,  233,   55,  105,   57,  109,   43,  280,  214,
 /*   830 */   160,  108,  292,   46,  392,  322,  219,  201,  309,  286,
 /*   840 */   387,  230,  306,  382,  386,   91,   15,  336,  249,  363,
 /*   850 */   233,   77,  284,  117,  109,  336,  336,  243,  336,   37,
 /*   860 */   288,  336,  392,   37,  288,  201,  309,  336,  387,  336,
 /*   870 */   336,  336,  386,  336,  336,  336,  249,  363,  233,   54,
 /*   880 */   110,   58,  109,  336,  336,  336,  336,  336,  336,  336,
 /*   890 */   392,  336,  336,  201,  309,  336,  387,  336,  336,  336,
 /*   900 */   386,  336,  336,  336,  249,  363,  233,   77,  336,  125,
 /*   910 */   109,  336,  336,  336,  336,  336,  336,  336,  392,  336,
 /*   920 */   336,  201,  309,  336,  336,  336,  387,  336,  386,  336,
 /*   930 */   336,  336,  336,  363,  249,  336,  233,   77,  336,  113,
 /*   940 */   109,  336,  336,  336,  336,  387,  336,  336,  392,  336,
 /*   950 */   336,  201,  309,  291,  387,  233,  336,  336,  386,  109,
 /*   960 */   336,  336,  259,  363,  233,   77,  336,  126,  109,  336,
 /*   970 */   336,  309,  336,  336,  336,  336,  392,  386,  336,  201,
 /*   980 */   309,  336,  387,  336,  336,  336,  386,  336,  336,  336,
 /*   990 */   249,  363,  233,   77,  336,  122,  109,  336,  336,  336,
 /*  1000 */   336,  336,  336,  336,  392,  336,  336,  201,  309,  336,
 /*  1010 */   387,  336,  336,  336,  386,  336,  336,  336,  249,  363,
 /*  1020 */   233,   77,  336,  115,  109,  336,  336,  336,  336,  336,
 /*  1030 */   336,  336,  392,  336,  336,  201,  309,  336,  336,  336,
 /*  1040 */   387,  336,  386,  336,  336,  336,  336,  363,  249,  336,
 /*  1050 */   233,   76,  336,  116,  109,  336,  336,  336,  336,  387,
 /*  1060 */   336,  336,  392,  336,  336,  201,  309,  297,  387,  233,
 /*  1070 */   336,  336,  386,  109,  336,  336,  249,  363,  233,   77,
 /*  1080 */   336,  120,  109,  336,  336,  309,  336,  336,  336,  336,
 /*  1090 */   392,  386,  336,  201,  309,  336,  387,  336,  336,  336,
 /*  1100 */   386,  336,  336,  336,  249,  363,  233,   77,  336,  123,
 /*  1110 */   109,  336,  336,  336,  336,  336,  336,  336,  392,  336,
 /*  1120 */   336,  201,  309,  336,  387,  336,  336,  336,  386,  336,
 /*  1130 */   336,  336,  244,  363,  233,  179,  336,  336,  109,  336,
 /*  1140 */   336,  336,  336,  336,  336,  336,  392,  336,  336,  201,
 /*  1150 */   309,  336,  336,  336,  336,  336,  386,  336,  336,  336,
 /*  1160 */   387,  336,  336,  336,  206,  393,  336,  336,  249,  336,
 /*  1170 */   233,   77,  336,  118,  109,  336,  336,  336,  336,  387,
 /*  1180 */   336,  336,  392,  336,  336,  201,  309,  316,  387,  233,
 /*  1190 */   336,  336,  386,  109,  336,  336,  249,  363,  233,   77,
 /*  1200 */   336,  121,  109,  336,  336,  309,  336,  336,  336,  336,
 /*  1210 */   392,  386,  336,  201,  309,  336,  387,  336,  336,  336,
 /*  1220 */   386,  336,  336,  336,  249,  363,  233,   76,  336,  114,
 /*  1230 */   109,  336,  336,  336,  336,  336,  336,  336,  392,  336,
 /*  1240 */   336,  201,  309,  336,  387,  336,  336,  336,  386,  336,
 /*  1250 */   336,  336,  249,  363,  233,   77,  336,  119,  109,  336,
 /*  1260 */   336,  336,  336,  336,  336,  336,  392,  336,  336,  201,
 /*  1270 */   309,  336,  336,  336,  387,  336,  386,  336,  336,  336,
 /*  1280 */   336,  363,  249,  336,  233,   75,  336,  112,  109,  336,
 /*  1290 */   336,  336,  336,  336,  336,  336,  392,  336,  336,  201,
 /*  1300 */   309,  336,  387,  336,  336,  336,  386,  336,  336,  336,
 /*  1310 */   244,  363,  233,  179,  336,  387,  109,  336,  336,  336,
 /*  1320 */   336,  336,  336,  307,  392,  233,  161,  201,  309,  109,
 /*  1330 */   336,  336,  336,  336,  386,  336,  336,  392,  336,  336,
 /*  1340 */   201,  309,  387,  385,  222,  336,  336,  386,  336,  336,
 /*  1350 */   307,  336,  233,  161,  336,  336,  109,  336,  336,  336,
 /*  1360 */   336,  336,  387,  336,  392,  336,  336,  201,  309,  336,
 /*  1370 */   307,  231,  233,  161,  386,  387,  109,  336,  336,  336,
 /*  1380 */   336,  336,  336,  307,  392,  233,  161,  201,  309,  109,
 /*  1390 */   336,  383,  336,  336,  386,  336,  336,  392,  387,  336,
 /*  1400 */   201,  309,  336,  387,  232,  336,   87,  386,   86,   67,
 /*  1410 */   104,   87,   94,   84,   72,  104,  336,   94,  336,  336,
 /*  1420 */   392,  336,  336,  201,  309,  392,  336,  336,  201,  309,
 /*  1430 */   386,  387,  336,  336,  336,  386,  336,  336,  336,  307,
 /*  1440 */   387,  212,  137,  336,  336,  109,  336,  336,  307,  336,
 /*  1450 */   233,  184,  336,  392,  109,  336,  201,  309,  336,  387,
 /*  1460 */   336,  336,  392,  386,  336,  201,  309,  307,  336,  233,
 /*  1470 */   176,  336,  386,  109,  336,  336,  336,  336,  336,  387,
 /*  1480 */   336,  392,  336,  336,  201,  309,  336,  307,  387,  233,
 /*  1490 */   134,  386,  336,  109,  336,  336,  307,  336,  233,  172,
 /*  1500 */   336,  392,  109,  336,  201,  309,  336,  336,  387,  336,
 /*  1510 */   392,  386,  336,  201,  309,  336,  307,  387,  233,  170,
 /*  1520 */   386,  336,  109,  336,  336,  307,  336,  233,  149,  336,
 /*  1530 */   392,  109,  336,  201,  309,  336,  387,  336,  336,  392,
 /*  1540 */   386,  336,  201,  309,  307,  387,  233,  174,  336,  386,
 /*  1550 */   109,  336,  336,  307,  336,  233,  166,  336,  392,  109,
 /*  1560 */   336,  201,  309,  336,  336,  336,  336,  392,  386,  336,
 /*  1570 */   201,  309,  387,  336,  336,  336,  336,  386,  336,  336,
 /*  1580 */   307,  387,  233,  167,  336,  336,  109,  336,  336,  307,
 /*  1590 */   336,  233,  171,  336,  392,  109,  336,  201,  309,  336,
 /*  1600 */   336,  387,  336,  392,  386,  336,  201,  309,  336,  307,
 /*  1610 */   387,  233,  162,  386,  336,  109,  336,  336,  307,  336,
 /*  1620 */   233,  148,  336,  392,  109,  336,  201,  309,  336,  336,
 /*  1630 */   387,  336,  392,  386,  336,  201,  309,  336,  307,  336,
 /*  1640 */   233,   69,  386,  387,  109,  336,  336,  336,  336,  336,
 /*  1650 */   387,  307,  392,  233,  182,  201,  309,  109,  298,  336,
 /*  1660 */   233,  336,  386,  336,  109,  392,  336,  336,  201,  309,
 /*  1670 */   387,  336,  336,  336,  336,  386,  309,  336,  307,  387,
 /*  1680 */   233,  139,  386,  336,  109,  336,  336,  307,  336,  233,
 /*  1690 */   336,  336,  392,  109,  336,  201,  309,  336,  387,  387,
 /*  1700 */   336,  392,  386,  336,  198,  309,  307,  308,  233,  233,
 /*  1710 */   336,  386,  109,  109,  336,  336,  336,  336,  387,  336,
 /*  1720 */   392,  336,  336,  196,  309,  309,  307,  336,  233,  336,
 /*  1730 */   386,  386,  109,  336,  336,  336,  336,  336,  387,  336,
 /*  1740 */   392,  336,  336,  195,  309,  336,  402,  336,  233,  336,
 /*  1750 */   386,  336,  109,  336,  336,  336,  336,  336,  336,  336,
 /*  1760 */   336,  336,  336,  336,  309,  336,  336,  336,  336,  336,
 /*  1770 */   386,
    );
    static public $yy_lookahead = array(
 /*     0 */    19,   37,   21,   22,   46,   24,   20,   26,   56,   28,
 /*    10 */    29,   25,   54,   27,   41,   20,   35,   36,    6,    7,
 /*    20 */    56,    9,   41,   11,   51,   44,   45,   41,   47,   48,
 /*    30 */    49,   50,   21,   81,   53,   54,   19,   51,   21,   22,
 /*    40 */     2,    3,   56,    5,   96,   28,   84,   85,   86,   87,
 /*    50 */    88,   56,   35,   36,   16,   17,   18,   28,   41,  111,
 /*    60 */    23,   44,   45,   22,   47,   48,   49,   50,   39,   40,
 /*    70 */    53,   54,   55,   19,  126,   21,   22,   36,    2,    3,
 /*    80 */    10,    5,   28,   46,   55,   19,   42,   21,   22,   35,
 /*    90 */    36,   23,   16,   19,   18,   41,   22,   23,   44,   45,
 /*   100 */    56,   47,   48,   49,   50,   31,   38,   53,   54,   19,
 /*   110 */    41,   21,   22,   19,  122,   46,   22,   23,   28,   53,
 /*   120 */    51,   28,   20,    8,   55,   35,   36,   21,   22,   20,
 /*   130 */    28,   41,   39,   40,   44,   45,   27,   47,   48,   49,
 /*   140 */    50,   39,   40,   53,   54,   19,   52,   21,   22,   22,
 /*   150 */    41,   24,   20,   26,   28,   33,   29,   25,   20,   27,
 /*   160 */    51,   35,   36,   19,   20,   27,   22,   41,   20,   31,
 /*   170 */    44,   45,   22,   47,   48,   49,   50,   23,   34,   53,
 /*   180 */    54,   19,   31,   21,   22,   96,   19,   20,   56,   22,
 /*   190 */    28,  102,   21,   22,  107,   41,   19,   35,   36,   22,
 /*   200 */   111,   34,   52,   41,   56,   51,   44,   45,  121,   47,
 /*   210 */    48,   49,   50,   20,  125,   53,   54,   19,   97,   21,
 /*   220 */    22,   34,  101,   23,   53,   25,   28,   19,   41,   52,
 /*   230 */    22,   23,   81,   35,   36,   96,  115,   20,   51,   41,
 /*   240 */   119,  102,   44,   45,   27,   47,   48,   49,   50,   56,
 /*   250 */   111,   53,   54,   19,   19,   21,   22,   25,   19,   20,
 /*   260 */    19,   22,   28,   22,  125,   20,   20,   27,   28,   35,
 /*   270 */    36,   19,   20,   27,   22,   41,   41,   31,   44,   45,
 /*   280 */    96,   47,   48,   49,   50,   68,  102,   53,   54,   19,
 /*   290 */    87,   21,   22,   52,   20,  111,   20,  117,   28,   97,
 /*   300 */   120,   27,  122,  101,   88,   35,   36,   96,   25,   93,
 /*   310 */    94,   41,   31,  102,   44,   45,   96,   47,   48,   49,
 /*   320 */    50,  119,  111,   53,   54,   19,  102,   21,   22,   46,
 /*   330 */    56,  111,  129,   96,   28,   13,   14,   54,   87,  102,
 /*   340 */    38,   35,   36,  123,   68,   91,   92,   41,  111,  125,
 /*   350 */    44,   45,   96,   47,   48,   49,   50,   27,   56,   53,
 /*   360 */    54,   19,  102,   21,   22,  114,   20,  111,   38,   96,
 /*   370 */    28,   86,   87,   88,   33,  102,   88,   35,   36,  123,
 /*   380 */   129,   93,   94,   41,  111,  125,   44,   45,   96,   47,
 /*   390 */    48,   49,   50,   38,   17,   53,   54,   19,  126,   21,
 /*   400 */    22,   96,   20,  111,   20,   20,   28,  102,   20,   27,
 /*   410 */    20,   56,   27,   35,   36,   27,  111,   27,  126,   41,
 /*   420 */    56,   57,   44,   45,   22,   47,   48,   49,   50,   91,
 /*   430 */    92,   53,   34,   69,   70,   71,   72,   73,   74,   75,
 /*   440 */    76,   77,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   450 */    66,   67,   20,   30,  103,   19,   56,   21,   22,   27,
 /*   460 */    37,   96,   78,   79,   80,   19,   19,   21,   22,   22,
 /*   470 */    20,   20,   36,   20,   28,  107,  111,   27,   27,   20,
 /*   480 */    27,   35,   36,   47,   48,   42,   27,   41,  123,  121,
 /*   490 */    44,   45,  118,   47,   48,   49,   50,   37,   30,   53,
 /*   500 */   107,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   510 */    67,   20,   20,   27,  121,   55,  102,   20,   27,   27,
 /*   520 */   117,   78,   79,   80,   27,  122,   58,   59,   60,   61,
 /*   530 */    62,   63,   64,   65,   66,   67,   42,  118,   20,   41,
 /*   540 */   121,  103,   56,   20,   20,   27,   78,   79,   80,  107,
 /*   550 */    27,   27,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   560 */    66,   67,   19,  121,   42,   22,  118,   20,   20,   20,
 /*   570 */   118,   20,   78,   79,   80,   27,   27,   96,   27,   96,
 /*   580 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   590 */    89,   90,  111,   19,  111,   22,   22,   20,   89,   90,
 /*   600 */    78,   79,   80,   42,   27,   58,   59,   60,   61,   62,
 /*   610 */    63,   64,   65,   66,   67,   27,  103,   56,   57,   91,
 /*   620 */    92,   91,   92,   89,   90,   78,   79,   80,  107,   42,
 /*   630 */    69,   70,   71,   72,   73,   74,   75,   76,   77,  104,
 /*   640 */   105,   42,  121,   56,   57,  118,   58,   59,   60,   61,
 /*   650 */    62,   63,   64,   65,   66,   67,   69,   70,   71,   72,
 /*   660 */    73,   74,   75,   76,   77,  107,   78,   79,   80,   58,
 /*   670 */    59,   60,   61,   62,   63,   64,   65,   66,   67,  121,
 /*   680 */     1,    2,   36,    4,    5,  103,  107,   20,  108,   78,
 /*   690 */    79,   80,  117,   96,   27,   16,   20,  122,   19,   87,
 /*   700 */   121,  121,   87,   27,   96,   96,  117,   95,  111,   97,
 /*   710 */    95,  122,   97,  101,   35,   96,  101,   32,   21,  111,
 /*   720 */   111,  109,   22,   56,   57,  113,   22,    3,  113,   42,
 /*   730 */   111,  119,   56,   57,  119,   20,   69,   70,   71,   72,
 /*   740 */    73,   74,   75,   76,   77,   69,   70,   71,   72,   73,
 /*   750 */    74,   75,   76,   77,   20,   87,   43,  107,   15,  107,
 /*   760 */    22,   27,   87,   95,   22,   97,   98,   99,  100,  101,
 /*   770 */    95,  121,   97,  121,   22,   43,  101,  109,   21,   20,
 /*   780 */   112,  113,    4,   38,  109,   68,    4,  119,  113,   23,
 /*   790 */    56,   57,  124,   21,  119,   12,   22,   19,   27,   53,
 /*   800 */    46,   19,   55,   69,   70,   71,   72,   73,   74,   75,
 /*   810 */    76,   77,   87,   35,   23,   21,   41,   35,   42,  111,
 /*   820 */    95,  120,   97,   98,   99,  100,  101,   38,   50,   27,
 /*   830 */   118,  115,   50,   27,  109,  121,  110,  112,  113,   27,
 /*   840 */    87,  106,  123,   53,  119,   21,  106,  130,   95,  124,
 /*   850 */    97,   98,  104,  100,  101,  130,  130,  104,  130,   81,
 /*   860 */    82,  130,  109,   81,   82,  112,  113,  130,   87,  130,
 /*   870 */   130,  130,  119,  130,  130,  130,   95,  124,   97,   98,
 /*   880 */    99,  100,  101,  130,  130,  130,  130,  130,  130,  130,
 /*   890 */   109,  130,  130,  112,  113,  130,   87,  130,  130,  130,
 /*   900 */   119,  130,  130,  130,   95,  124,   97,   98,  130,  100,
 /*   910 */   101,  130,  130,  130,  130,  130,  130,  130,  109,  130,
 /*   920 */   130,  112,  113,  130,  130,  130,   87,  130,  119,  130,
 /*   930 */   130,  130,  130,  124,   95,  130,   97,   98,  130,  100,
 /*   940 */   101,  130,  130,  130,  130,   87,  130,  130,  109,  130,
 /*   950 */   130,  112,  113,   95,   87,   97,  130,  130,  119,  101,
 /*   960 */   130,  130,   95,  124,   97,   98,  130,  100,  101,  130,
 /*   970 */   130,  113,  130,  130,  130,  130,  109,  119,  130,  112,
 /*   980 */   113,  130,   87,  130,  130,  130,  119,  130,  130,  130,
 /*   990 */    95,  124,   97,   98,  130,  100,  101,  130,  130,  130,
 /*  1000 */   130,  130,  130,  130,  109,  130,  130,  112,  113,  130,
 /*  1010 */    87,  130,  130,  130,  119,  130,  130,  130,   95,  124,
 /*  1020 */    97,   98,  130,  100,  101,  130,  130,  130,  130,  130,
 /*  1030 */   130,  130,  109,  130,  130,  112,  113,  130,  130,  130,
 /*  1040 */    87,  130,  119,  130,  130,  130,  130,  124,   95,  130,
 /*  1050 */    97,   98,  130,  100,  101,  130,  130,  130,  130,   87,
 /*  1060 */   130,  130,  109,  130,  130,  112,  113,   95,   87,   97,
 /*  1070 */   130,  130,  119,  101,  130,  130,   95,  124,   97,   98,
 /*  1080 */   130,  100,  101,  130,  130,  113,  130,  130,  130,  130,
 /*  1090 */   109,  119,  130,  112,  113,  130,   87,  130,  130,  130,
 /*  1100 */   119,  130,  130,  130,   95,  124,   97,   98,  130,  100,
 /*  1110 */   101,  130,  130,  130,  130,  130,  130,  130,  109,  130,
 /*  1120 */   130,  112,  113,  130,   87,  130,  130,  130,  119,  130,
 /*  1130 */   130,  130,   95,  124,   97,   98,  130,  130,  101,  130,
 /*  1140 */   130,  130,  130,  130,  130,  130,  109,  130,  130,  112,
 /*  1150 */   113,  130,  130,  130,  130,  130,  119,  130,  130,  130,
 /*  1160 */    87,  130,  130,  130,  127,  128,  130,  130,   95,  130,
 /*  1170 */    97,   98,  130,  100,  101,  130,  130,  130,  130,   87,
 /*  1180 */   130,  130,  109,  130,  130,  112,  113,   95,   87,   97,
 /*  1190 */   130,  130,  119,  101,  130,  130,   95,  124,   97,   98,
 /*  1200 */   130,  100,  101,  130,  130,  113,  130,  130,  130,  130,
 /*  1210 */   109,  119,  130,  112,  113,  130,   87,  130,  130,  130,
 /*  1220 */   119,  130,  130,  130,   95,  124,   97,   98,  130,  100,
 /*  1230 */   101,  130,  130,  130,  130,  130,  130,  130,  109,  130,
 /*  1240 */   130,  112,  113,  130,   87,  130,  130,  130,  119,  130,
 /*  1250 */   130,  130,   95,  124,   97,   98,  130,  100,  101,  130,
 /*  1260 */   130,  130,  130,  130,  130,  130,  109,  130,  130,  112,
 /*  1270 */   113,  130,  130,  130,   87,  130,  119,  130,  130,  130,
 /*  1280 */   130,  124,   95,  130,   97,   98,  130,  100,  101,  130,
 /*  1290 */   130,  130,  130,  130,  130,  130,  109,  130,  130,  112,
 /*  1300 */   113,  130,   87,  130,  130,  130,  119,  130,  130,  130,
 /*  1310 */    95,  124,   97,   98,  130,   87,  101,  130,  130,  130,
 /*  1320 */   130,  130,  130,   95,  109,   97,   98,  112,  113,  101,
 /*  1330 */   130,  130,  130,  130,  119,  130,  130,  109,  130,  130,
 /*  1340 */   112,  113,   87,  128,  116,  130,  130,  119,  130,  130,
 /*  1350 */    95,  130,   97,   98,  130,  130,  101,  130,  130,  130,
 /*  1360 */   130,  130,   87,  130,  109,  130,  130,  112,  113,  130,
 /*  1370 */    95,  116,   97,   98,  119,   87,  101,  130,  130,  130,
 /*  1380 */   130,  130,  130,   95,  109,   97,   98,  112,  113,  101,
 /*  1390 */   130,  116,  130,  130,  119,  130,  130,  109,   87,  130,
 /*  1400 */   112,  113,  130,   87,  116,  130,   95,  119,   97,   98,
 /*  1410 */    99,   95,  101,   97,   98,   99,  130,  101,  130,  130,
 /*  1420 */   109,  130,  130,  112,  113,  109,  130,  130,  112,  113,
 /*  1430 */   119,   87,  130,  130,  130,  119,  130,  130,  130,   95,
 /*  1440 */    87,   97,   98,  130,  130,  101,  130,  130,   95,  130,
 /*  1450 */    97,   98,  130,  109,  101,  130,  112,  113,  130,   87,
 /*  1460 */   130,  130,  109,  119,  130,  112,  113,   95,  130,   97,
 /*  1470 */    98,  130,  119,  101,  130,  130,  130,  130,  130,   87,
 /*  1480 */   130,  109,  130,  130,  112,  113,  130,   95,   87,   97,
 /*  1490 */    98,  119,  130,  101,  130,  130,   95,  130,   97,   98,
 /*  1500 */   130,  109,  101,  130,  112,  113,  130,  130,   87,  130,
 /*  1510 */   109,  119,  130,  112,  113,  130,   95,   87,   97,   98,
 /*  1520 */   119,  130,  101,  130,  130,   95,  130,   97,   98,  130,
 /*  1530 */   109,  101,  130,  112,  113,  130,   87,  130,  130,  109,
 /*  1540 */   119,  130,  112,  113,   95,   87,   97,   98,  130,  119,
 /*  1550 */   101,  130,  130,   95,  130,   97,   98,  130,  109,  101,
 /*  1560 */   130,  112,  113,  130,  130,  130,  130,  109,  119,  130,
 /*  1570 */   112,  113,   87,  130,  130,  130,  130,  119,  130,  130,
 /*  1580 */    95,   87,   97,   98,  130,  130,  101,  130,  130,   95,
 /*  1590 */   130,   97,   98,  130,  109,  101,  130,  112,  113,  130,
 /*  1600 */   130,   87,  130,  109,  119,  130,  112,  113,  130,   95,
 /*  1610 */    87,   97,   98,  119,  130,  101,  130,  130,   95,  130,
 /*  1620 */    97,   98,  130,  109,  101,  130,  112,  113,  130,  130,
 /*  1630 */    87,  130,  109,  119,  130,  112,  113,  130,   95,  130,
 /*  1640 */    97,   98,  119,   87,  101,  130,  130,  130,  130,  130,
 /*  1650 */    87,   95,  109,   97,   98,  112,  113,  101,   95,  130,
 /*  1660 */    97,  130,  119,  130,  101,  109,  130,  130,  112,  113,
 /*  1670 */    87,  130,  130,  130,  130,  119,  113,  130,   95,   87,
 /*  1680 */    97,   98,  119,  130,  101,  130,  130,   95,  130,   97,
 /*  1690 */   130,  130,  109,  101,  130,  112,  113,  130,   87,   87,
 /*  1700 */   130,  109,  119,  130,  112,  113,   95,   95,   97,   97,
 /*  1710 */   130,  119,  101,  101,  130,  130,  130,  130,   87,  130,
 /*  1720 */   109,  130,  130,  112,  113,  113,   95,  130,   97,  130,
 /*  1730 */   119,  119,  101,  130,  130,  130,  130,  130,   87,  130,
 /*  1740 */   109,  130,  130,  112,  113,  130,   95,  130,   97,  130,
 /*  1750 */   119,  130,  101,  130,  130,  130,  130,  130,  130,  130,
 /*  1760 */   130,  130,  130,  130,  113,  130,  130,  130,  130,  130,
 /*  1770 */   119,
);
    const YY_SHIFT_USE_DFLT = -49;
    const YY_SHIFT_MAX = 260;
    static public $yy_shift_ofst = array(
 /*     0 */   679,  270,  342,  306,  342,   90,   90,   90,   90,   90,
 /*    10 */    90,   90,   90,   90,  126,   90,   90,   90,   90,  -19,
 /*    20 */   -19,  126,   54,   54,   54,   54,   54,   54,   54,   54,
 /*    30 */    54,   54,   54,   54,   54,   54,   54,   54,   54,   54,
 /*    40 */    54,   54,   17,  162,  198,  198,  234,  378,  378,  378,
 /*    50 */   378,  378,  378,  446,  676,  734,   66,  588,  588,  679,
 /*    60 */    38,  782,  -14,   76,  132,  171,  283,  274,  330,  486,
 /*    70 */   330,  486,  486,  330,  667,  587,  561,  364,  778,   74,
 /*    80 */    12,   94,   12,   12,  138,  177,  246,  577,  447,  574,
 /*    90 */   322,  447,  322,  447,  200,  322,  322,  447,  543,  447,
 /*   100 */   447,  447,  447,  574,  802,  802,  806,  232,  232,  232,
 /*   110 */   802,  824,  494,  384,  522,  468,  443,  547,  611,  611,
 /*   120 */   611,  611,  611,  611,  611,  611,  611,  167,  144,  127,
 /*   130 */   239,  208,  241,  252,  302,  390,  432,  -48,  382,   -5,
 /*   140 */   385,  388,  -42,  106,  551,  -42,  450,  497,  193,   44,
 /*   150 */   491,  492,  518,  523,  549,  -42,  548,  235,  524,  -42,
 /*   160 */   -42,  -36,  355,  459,  453,  451,  148,  400,  824,  812,
 /*   170 */   400,  400,  400,  812,  400,  232,  400,  232,  789,  400,
 /*   180 */   232,  232,  400,  498,  400,  -49,  -49,  -49,  -49,  -49,
 /*   190 */   -49,  -49,  436,  109,   69,   29,  102,  217,   93,  187,
 /*   200 */   154,   93,  150,  -27,  276,  423,  460,   37,  -27,  -27,
 /*   210 */   240,   68,  151,  -27,   41,  743,  738,  742,  757,  715,
 /*   220 */   697,  704,  687,  732,  771,  754,  791,  747,  774,  646,
 /*   230 */   772,  776,  599,  281,  341,   70,   11,  122,  115,  402,
 /*   240 */   573,  790,  377,  245,  398,  346,  746,  745,  794,  717,
 /*   250 */   724,  685,  732,  766,  752,  713,  700,  759,  775,  717,
 /*   260 */   783,
);
    const YY_REDUCE_USE_DFLT = -53;
    const YY_REDUCE_MAX = 191;
    static public $yy_reduce_ofst = array(
 /*     0 */   -38,  668,  725,  753,  781, 1187,  895, 1157,  867,  809,
 /*    10 */   839,  953,  981, 1101, 1037,  923, 1129, 1009, 1073, 1316,
 /*    20 */  1311, 1215, 1228, 1255, 1288, 1275, 1430, 1458, 1556, 1583,
 /*    30 */  1523, 1449, 1485, 1494, 1514, 1421, 1392, 1344, 1543, 1353,
 /*    40 */  1372, 1401, 1631, 1592, 1611,  675,  612, 1612,  615,  858,
 /*    50 */   972, 1092, 1563, 1651,   89,  139,  121,  -52,  292,  285,
 /*    60 */   216,  251,  305,  288,  273,  202,  180,  184,  220,  211,
 /*    70 */   256,  237,  184,  365,  260,  224,  260,  224,  203,  580,
 /*    80 */   534,  419,  509,  501,  481,  419,  481,  483,  521,  368,
 /*    90 */   530,  558,  528,  442,  403,  254,  338,   87,  368,  393,
 /*   100 */   368,  579,  652,  650,  608,  619,  597,  575,  589,  403,
 /*   110 */   609,  535,  272,  272,  272,  272,  272,  272,  272,  272,
 /*   120 */   272,  272,  272,  272,  272,  272,  272,  714,  714,  726,
 /*   130 */   714,  714,  714,  714,  414,  708,  708,  414,  708,  414,
 /*   140 */   708,  708,  701,  716,  708,  701,  708,  708,  414,  414,
 /*   150 */   708,  708,  708,  708,  708,  701,  708,  712,  708,  701,
 /*   160 */   701,  414,  414,  708,  708,  708,  414,  414,  748,  740,
 /*   170 */   414,  414,  414,  735,  414,   -8,  414,   -8,  719,  414,
 /*   180 */    -8,   -8,  414,  374,  414,  351,  438,  448,  527,  582,
 /*   190 */   513,  452,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(1, 2, 4, 5, 16, 19, 35, ),
        /* 1 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 2 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 3 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 4 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 5 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 6 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 7 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 8 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 9 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 10 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 11 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 12 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 13 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 14 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 15 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 16 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 17 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 18 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 19 */ array(19, 21, 22, 24, 26, 28, 29, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 20 */ array(19, 21, 22, 24, 26, 28, 29, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 21 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 22 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 23 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 24 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 25 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 26 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 27 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 28 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 29 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 30 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 31 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 32 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 33 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 34 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 35 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 36 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 37 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 38 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 39 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 40 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 41 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 42 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, 55, ),
        /* 43 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 44 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 45 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 46 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, 54, ),
        /* 47 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, ),
        /* 48 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, ),
        /* 49 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, ),
        /* 50 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, ),
        /* 51 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, ),
        /* 52 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, ),
        /* 53 */ array(19, 21, 22, 28, 35, 36, 41, 44, 45, 47, 48, 49, 50, 53, ),
        /* 54 */ array(20, 27, 56, 57, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 55 */ array(20, 27, 56, 57, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 56 */ array(19, 21, 22, 53, ),
        /* 57 */ array(27, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 58 */ array(27, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 59 */ array(1, 2, 4, 5, 16, 19, 35, ),
        /* 60 */ array(2, 3, 5, 16, 17, 18, ),
        /* 61 */ array(4, 19, 35, 50, 81, 82, ),
        /* 62 */ array(20, 25, 27, 41, 51, 56, ),
        /* 63 */ array(2, 3, 5, 16, 18, ),
        /* 64 */ array(20, 25, 27, 56, ),
        /* 65 */ array(21, 22, 53, ),
        /* 66 */ array(25, 46, 54, ),
        /* 67 */ array(20, 27, 56, ),
        /* 68 */ array(27, 38, ),
        /* 69 */ array(27, 56, ),
        /* 70 */ array(27, 38, ),
        /* 71 */ array(27, 56, ),
        /* 72 */ array(27, 56, ),
        /* 73 */ array(27, 38, ),
        /* 74 */ array(20, 27, 56, 57, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 75 */ array(42, 56, 57, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 76 */ array(42, 56, 57, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 77 */ array(56, 57, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 78 */ array(4, 19, 35, 50, 81, 82, ),
        /* 79 */ array(19, 22, 23, 31, ),
        /* 80 */ array(6, 7, 9, 11, ),
        /* 81 */ array(19, 22, 23, 52, ),
        /* 82 */ array(6, 7, 9, 11, ),
        /* 83 */ array(6, 7, 9, 11, ),
        /* 84 */ array(20, 27, 31, ),
        /* 85 */ array(19, 22, 52, ),
        /* 86 */ array(20, 27, 31, ),
        /* 87 */ array(20, 27, ),
        /* 88 */ array(19, 22, ),
        /* 89 */ array(19, 22, ),
        /* 90 */ array(13, 14, ),
        /* 91 */ array(19, 22, ),
        /* 92 */ array(13, 14, ),
        /* 93 */ array(19, 22, ),
        /* 94 */ array(23, 25, ),
        /* 95 */ array(13, 14, ),
        /* 96 */ array(13, 14, ),
        /* 97 */ array(19, 22, ),
        /* 98 */ array(19, 22, ),
        /* 99 */ array(19, 22, ),
        /* 100 */ array(19, 22, ),
        /* 101 */ array(19, 22, ),
        /* 102 */ array(19, 22, ),
        /* 103 */ array(19, 22, ),
        /* 104 */ array(27, ),
        /* 105 */ array(27, ),
        /* 106 */ array(27, ),
        /* 107 */ array(25, ),
        /* 108 */ array(25, ),
        /* 109 */ array(25, ),
        /* 110 */ array(27, ),
        /* 111 */ array(21, ),
        /* 112 */ array(42, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 113 */ array(20, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 114 */ array(42, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 115 */ array(30, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 116 */ array(42, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 117 */ array(20, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 118 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 119 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 120 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 121 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 122 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 123 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 124 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 125 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 126 */ array(58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 78, 79, 80, ),
        /* 127 */ array(19, 20, 22, 34, ),
        /* 128 */ array(19, 20, 22, 34, ),
        /* 129 */ array(22, 24, 26, 29, ),
        /* 130 */ array(19, 20, 22, ),
        /* 131 */ array(19, 22, 23, ),
        /* 132 */ array(19, 22, 52, ),
        /* 133 */ array(19, 20, 22, ),
        /* 134 */ array(38, 56, ),
        /* 135 */ array(20, 27, ),
        /* 136 */ array(20, 27, ),
        /* 137 */ array(56, 81, ),
        /* 138 */ array(20, 27, ),
        /* 139 */ array(20, 56, ),
        /* 140 */ array(20, 27, ),
        /* 141 */ array(20, 27, ),
        /* 142 */ array(46, 54, ),
        /* 143 */ array(21, 22, ),
        /* 144 */ array(20, 27, ),
        /* 145 */ array(46, 54, ),
        /* 146 */ array(20, 27, ),
        /* 147 */ array(20, 27, ),
        /* 148 */ array(20, 56, ),
        /* 149 */ array(42, 56, ),
        /* 150 */ array(20, 27, ),
        /* 151 */ array(20, 27, ),
        /* 152 */ array(20, 27, ),
        /* 153 */ array(20, 27, ),
        /* 154 */ array(20, 27, ),
        /* 155 */ array(46, 54, ),
        /* 156 */ array(20, 27, ),
        /* 157 */ array(19, 41, ),
        /* 158 */ array(20, 27, ),
        /* 159 */ array(46, 54, ),
        /* 160 */ array(46, 54, ),
        /* 161 */ array(37, 56, ),
        /* 162 */ array(38, 56, ),
        /* 163 */ array(20, 27, ),
        /* 164 */ array(20, 27, ),
        /* 165 */ array(20, 27, ),
        /* 166 */ array(20, 56, ),
        /* 167 */ array(56, ),
        /* 168 */ array(21, ),
        /* 169 */ array(27, ),
        /* 170 */ array(56, ),
        /* 171 */ array(56, ),
        /* 172 */ array(56, ),
        /* 173 */ array(27, ),
        /* 174 */ array(56, ),
        /* 175 */ array(25, ),
        /* 176 */ array(56, ),
        /* 177 */ array(25, ),
        /* 178 */ array(38, ),
        /* 179 */ array(56, ),
        /* 180 */ array(25, ),
        /* 181 */ array(25, ),
        /* 182 */ array(56, ),
        /* 183 */ array(41, ),
        /* 184 */ array(56, ),
        /* 185 */ array(),
        /* 186 */ array(),
        /* 187 */ array(),
        /* 188 */ array(),
        /* 189 */ array(),
        /* 190 */ array(),
        /* 191 */ array(),
        /* 192 */ array(19, 21, 22, 36, 47, 48, ),
        /* 193 */ array(20, 27, 41, 51, ),
        /* 194 */ array(41, 46, 51, 55, ),
        /* 195 */ array(28, 39, 40, 55, ),
        /* 196 */ array(20, 28, 39, 40, ),
        /* 197 */ array(20, 27, 68, ),
        /* 198 */ array(28, 39, 40, ),
        /* 199 */ array(34, 41, 51, ),
        /* 200 */ array(23, 41, 51, ),
        /* 201 */ array(28, 39, 40, ),
        /* 202 */ array(22, 52, ),
        /* 203 */ array(41, 51, ),
        /* 204 */ array(20, 68, ),
        /* 205 */ array(30, 37, ),
        /* 206 */ array(37, 55, ),
        /* 207 */ array(23, 46, ),
        /* 208 */ array(41, 51, ),
        /* 209 */ array(41, 51, ),
        /* 210 */ array(27, 28, ),
        /* 211 */ array(23, 38, ),
        /* 212 */ array(31, 81, ),
        /* 213 */ array(41, 51, ),
        /* 214 */ array(22, 36, ),
        /* 215 */ array(15, ),
        /* 216 */ array(22, ),
        /* 217 */ array(22, ),
        /* 218 */ array(21, ),
        /* 219 */ array(20, ),
        /* 220 */ array(21, ),
        /* 221 */ array(22, ),
        /* 222 */ array(42, ),
        /* 223 */ array(43, ),
        /* 224 */ array(27, ),
        /* 225 */ array(46, ),
        /* 226 */ array(23, ),
        /* 227 */ array(55, ),
        /* 228 */ array(22, ),
        /* 229 */ array(36, ),
        /* 230 */ array(21, ),
        /* 231 */ array(42, ),
        /* 232 */ array(42, ),
        /* 233 */ array(31, ),
        /* 234 */ array(33, ),
        /* 235 */ array(10, ),
        /* 236 */ array(21, ),
        /* 237 */ array(33, ),
        /* 238 */ array(8, ),
        /* 239 */ array(22, ),
        /* 240 */ array(22, ),
        /* 241 */ array(53, ),
        /* 242 */ array(17, ),
        /* 243 */ array(20, ),
        /* 244 */ array(34, ),
        /* 245 */ array(20, ),
        /* 246 */ array(53, ),
        /* 247 */ array(38, ),
        /* 248 */ array(21, ),
        /* 249 */ array(68, ),
        /* 250 */ array(3, ),
        /* 251 */ array(32, ),
        /* 252 */ array(43, ),
        /* 253 */ array(23, ),
        /* 254 */ array(22, ),
        /* 255 */ array(43, ),
        /* 256 */ array(22, ),
        /* 257 */ array(20, ),
        /* 258 */ array(41, ),
        /* 259 */ array(68, ),
        /* 260 */ array(12, ),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
        /* 383 */ array(),
        /* 384 */ array(),
        /* 385 */ array(),
        /* 386 */ array(),
        /* 387 */ array(),
        /* 388 */ array(),
        /* 389 */ array(),
        /* 390 */ array(),
        /* 391 */ array(),
        /* 392 */ array(),
        /* 393 */ array(),
        /* 394 */ array(),
        /* 395 */ array(),
        /* 396 */ array(),
        /* 397 */ array(),
        /* 398 */ array(),
        /* 399 */ array(),
        /* 400 */ array(),
        /* 401 */ array(),
        /* 402 */ array(),
        /* 403 */ array(),
        /* 404 */ array(),
        /* 405 */ array(),
        /* 406 */ array(),
);
    static public $yy_default = array(
 /*     0 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*    10 */   611,  611,  611,  611,  596,  611,  611,  611,  611,  611,
 /*    20 */   611,  611,  554,  554,  554,  554,  611,  611,  611,  611,
 /*    30 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*    40 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*    50 */   611,  611,  611,  611,  564,  564,  611,  475,  475,  407,
 /*    60 */   611,  611,  611,  429,  611,  611,  516,  611,  475,  475,
 /*    70 */   475,  475,  475,  475,  564,  564,  564,  564,  611,  611,
 /*    80 */   417,  526,  417,  417,  497,  526,  497,  490,  611,  611,
 /*    90 */   423,  611,  423,  611,  519,  423,  423,  611,  611,  611,
 /*   100 */   611,  611,  611,  611,  475,  475,  475,  512,  511,  519,
 /*   110 */   475,  611,  611,  611,  611,  611,  611,  611,  577,  570,
 /*   120 */   574,  573,  569,  578,  478,  568,  562,  611,  611,  611,
 /*   130 */   611,  611,  527,  611,  611,  611,  611,  611,  611,  611,
 /*   140 */   611,  611,  546,  611,  611,  548,  611,  611,  611,  611,
 /*   150 */   611,  611,  611,  611,  611,  524,  611,  526,  611,  547,
 /*   160 */   545,  553,  611,  611,  611,  611,  611,  485,  611,  610,
 /*   170 */   496,  458,  495,  610,  597,  514,  598,  517,  489,  599,
 /*   180 */   513,  542,  482,  526,  565,  558,  558,  526,  526,  558,
 /*   190 */   558,  526,  611,  486,  611,  611,  611,  490,  559,  486,
 /*   200 */   481,  487,  611,  560,  490,  611,  611,  502,  579,  486,
 /*   210 */   611,  540,  497,  611,  611,  611,  611,  611,  611,  611,
 /*   220 */   611,  611,  611,  611,  611,  502,  481,  611,  611,  611,
 /*   230 */   611,  611,  611,  497,  611,  611,  611,  611,  611,  611,
 /*   240 */   611,  611,  611,  611,  490,  611,  611,  540,  611,  490,
 /*   250 */   611,  483,  563,  611,  611,  507,  611,  611,  515,  490,
 /*   260 */   611,  455,  601,  535,  537,  551,  534,  536,  532,  533,
 /*   270 */   549,  472,  480,  408,  469,  468,  466,  467,  531,  530,
 /*   280 */   509,  600,  603,  460,  484,  459,  609,  602,  604,  541,
 /*   290 */   529,  493,  510,  607,  608,  457,  571,  500,  499,  503,
 /*   300 */   504,  505,  498,  501,  474,  471,  557,  490,  491,  506,
 /*   310 */   544,  437,  508,  605,  438,  555,  492,  540,  520,  543,
 /*   320 */   525,  528,  539,  470,  465,  422,  419,  424,  420,  421,
 /*   330 */   418,  416,  410,  409,  411,  412,  413,  425,  414,  434,
 /*   340 */   433,  435,  436,  473,  432,  431,  426,  415,  427,  428,
 /*   350 */   430,  556,  606,  590,  576,  591,  592,  444,  575,  572,
 /*   360 */   443,  589,  507,  561,  563,  445,  446,  462,  461,  463,
 /*   370 */   464,  454,  449,  452,  448,  447,  450,  451,  453,  588,
 /*   380 */   587,  523,  522,  552,  593,  595,  521,  518,  440,  439,
 /*   390 */   488,  538,  494,  594,  550,  583,  582,  584,  585,  586,
 /*   400 */   581,  567,  580,  441,  442,  566,  456,
);
    const YYNOCODE = 131;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 407;
    const YYNRULE = 204;
    const YYERRORSYMBOL = 83;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'COMMENT',       'PHPSTARTTAG',   'PHPENDTAG',   
  'OTHER',         'FAKEPHPSTARTTAG',  'PHP_CODE',      'PHP_CODE_START_DOUBLEQUOTE',
  'PHP_CODE_DOUBLEQUOTE',  'PHP_HEREDOC_START',  'PHP_HEREDOC_END',  'PHP_NOWDOC_START',
  'PHP_NOWDOC_END',  'PHP_DQ_CONTENT',  'PHP_DQ_EMBED_START',  'PHP_DQ_EMBED_END',
  'LITERALSTART',  'LITERALEND',    'LITERAL',       'LDEL',        
  'RDEL',          'DOLLAR',        'ID',            'EQUAL',       
  'FOREACH',       'PTR',           'IF',            'SPACE',       
  'UNIMATH',       'FOR',           'SEMICOLON',     'INCDEC',      
  'TO',            'AS',            'APTR',          'LDELSLASH',   
  'INTEGER',       'COMMA',         'COLON',         'MATH',        
  'ANDSYM',        'OPENP',         'CLOSEP',        'QMARK',       
  'NOT',           'TYPECAST',      'DOT',           'BOOLEAN',     
  'NULL',          'SINGLEQUOTESTRING',  'QUOTE',         'DOUBLECOLON', 
  'AT',            'HATCH',         'OPENB',         'CLOSEB',      
  'VERT',          'ISIN',          'ISDIVBY',       'ISNOTDIVBY',  
  'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',      'ISNOTEVENBY', 
  'ISODD',         'ISNOTODD',      'ISODDBY',       'ISNOTODDBY',  
  'INSTANCEOF',    'EQUALS',        'NOTEQUALS',     'GREATERTHAN', 
  'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',     'IDENTITY',    
  'NONEIDENTITY',  'MOD',           'LAND',          'LOR',         
  'LXOR',          'BACKTICK',      'DOLLARID',      'error',       
  'start',         'template',      'template_element',  'smartytag',   
  'literal',       'php_code',      'php_code_element',  'php_dq_contents',
  'php_dq_content',  'literal_elements',  'literal_element',  'value',       
  'attributes',    'variable',      'expr',          'ternary',     
  'ifexprs',       'varindexed',    'modifier',      'modparameters',
  'statement',     'statements',    'optspace',      'varvar',      
  'foraction',     'array',         'specialclose',  'attribute',   
  'exprs',         'function',      'doublequoted',  'method',      
  'params',        'objectchain',   'arrayindex',    'object',      
  'indexdef',      'varvarele',     'objectelement',  'modparameter',
  'ifexpr',        'ifcond',        'lop',           'arrayelements',
  'arrayelement',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template_element ::= smartytag",
 /*   4 */ "template_element ::= COMMENT",
 /*   5 */ "template_element ::= literal",
 /*   6 */ "template_element ::= PHPSTARTTAG php_code PHPENDTAG",
 /*   7 */ "template_element ::= OTHER",
 /*   8 */ "template_element ::= FAKEPHPSTARTTAG",
 /*   9 */ "php_code ::= php_code_element php_code",
 /*  10 */ "php_code ::=",
 /*  11 */ "php_code_element ::= PHP_CODE",
 /*  12 */ "php_code_element ::= PHP_CODE_START_DOUBLEQUOTE php_dq_contents PHP_CODE_DOUBLEQUOTE",
 /*  13 */ "php_code_element ::= PHP_HEREDOC_START php_dq_contents PHP_HEREDOC_END",
 /*  14 */ "php_code_element ::= PHP_NOWDOC_START php_dq_contents PHP_NOWDOC_END",
 /*  15 */ "php_dq_contents ::= php_dq_content php_dq_contents",
 /*  16 */ "php_dq_contents ::=",
 /*  17 */ "php_dq_content ::= PHP_DQ_CONTENT",
 /*  18 */ "php_dq_content ::= PHP_DQ_EMBED_START php_code PHP_DQ_EMBED_END",
 /*  19 */ "literal ::= LITERALSTART LITERALEND",
 /*  20 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  21 */ "literal_elements ::= literal_element literal_elements",
 /*  22 */ "literal_elements ::=",
 /*  23 */ "literal_element ::= literal",
 /*  24 */ "literal_element ::= LITERAL",
 /*  25 */ "literal_element ::= PHPSTARTTAG",
 /*  26 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  27 */ "literal_element ::= PHPENDTAG",
 /*  28 */ "smartytag ::= LDEL value RDEL",
 /*  29 */ "smartytag ::= LDEL value attributes RDEL",
 /*  30 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  31 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  32 */ "smartytag ::= LDEL ternary attributes RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  35 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  36 */ "smartytag ::= LDEL DOLLAR ID EQUAL ifexprs attributes RDEL",
 /*  37 */ "smartytag ::= LDEL DOLLAR ID EQUAL ternary attributes RDEL",
 /*  38 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  39 */ "smartytag ::= LDEL varindexed EQUAL ternary attributes RDEL",
 /*  40 */ "smartytag ::= LDEL varindexed EQUAL ifexprs attributes RDEL",
 /*  41 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  42 */ "smartytag ::= LDEL FOREACH attributes RDEL",
 /*  43 */ "smartytag ::= LDEL ID RDEL",
 /*  44 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  45 */ "smartytag ::= LDEL ID modifier modparameters attributes RDEL",
 /*  46 */ "smartytag ::= LDEL ID PTR ID modifier modparameters attributes RDEL",
 /*  47 */ "smartytag ::= LDEL IF SPACE ifexprs RDEL",
 /*  48 */ "smartytag ::= LDEL IF UNIMATH ifexprs RDEL",
 /*  49 */ "smartytag ::= LDEL IF SPACE statement RDEL",
 /*  50 */ "smartytag ::= LDEL FOR SPACE statements SEMICOLON optspace ifexprs SEMICOLON optspace DOLLAR varvar foraction RDEL",
 /*  51 */ "foraction ::= EQUAL expr",
 /*  52 */ "foraction ::= INCDEC",
 /*  53 */ "smartytag ::= LDEL FOR SPACE statement TO expr attributes RDEL",
 /*  54 */ "smartytag ::= LDEL FOREACH SPACE value AS DOLLAR varvar RDEL",
 /*  55 */ "smartytag ::= LDEL FOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  56 */ "smartytag ::= LDEL FOREACH SPACE array AS DOLLAR varvar RDEL",
 /*  57 */ "smartytag ::= LDEL FOREACH SPACE array AS DOLLAR varvar APTR DOLLAR varvar RDEL",
 /*  58 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  59 */ "smartytag ::= LDELSLASH specialclose RDEL",
 /*  60 */ "specialclose ::= IF",
 /*  61 */ "specialclose ::= FOR",
 /*  62 */ "specialclose ::= FOREACH",
 /*  63 */ "smartytag ::= LDELSLASH ID attributes RDEL",
 /*  64 */ "smartytag ::= LDELSLASH ID modifier modparameters attributes RDEL",
 /*  65 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  66 */ "attributes ::= attributes attribute",
 /*  67 */ "attributes ::= attribute",
 /*  68 */ "attributes ::=",
 /*  69 */ "attribute ::= SPACE ID EQUAL ID",
 /*  70 */ "attribute ::= SPACE ID EQUAL expr",
 /*  71 */ "attribute ::= SPACE ID EQUAL ifexprs",
 /*  72 */ "attribute ::= SPACE ID EQUAL value",
 /*  73 */ "attribute ::= SPACE ID EQUAL ternary",
 /*  74 */ "attribute ::= SPACE ID",
 /*  75 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  76 */ "statements ::= statement",
 /*  77 */ "statements ::= statements COMMA statement",
 /*  78 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  79 */ "expr ::= ID",
 /*  80 */ "expr ::= exprs",
 /*  81 */ "expr ::= DOLLAR ID COLON ID",
 /*  82 */ "expr ::= expr modifier modparameters",
 /*  83 */ "exprs ::= value",
 /*  84 */ "exprs ::= exprs MATH value",
 /*  85 */ "exprs ::= exprs UNIMATH value",
 /*  86 */ "exprs ::= exprs ANDSYM value",
 /*  87 */ "exprs ::= array",
 /*  88 */ "ternary ::= OPENP ifexprs CLOSEP QMARK expr COLON expr",
 /*  89 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  90 */ "value ::= variable",
 /*  91 */ "value ::= UNIMATH value",
 /*  92 */ "value ::= NOT value",
 /*  93 */ "value ::= TYPECAST value",
 /*  94 */ "value ::= variable INCDEC",
 /*  95 */ "value ::= INTEGER",
 /*  96 */ "value ::= INTEGER DOT INTEGER",
 /*  97 */ "value ::= BOOLEAN",
 /*  98 */ "value ::= NULL",
 /*  99 */ "value ::= function",
 /* 100 */ "value ::= OPENP expr CLOSEP",
 /* 101 */ "value ::= SINGLEQUOTESTRING",
 /* 102 */ "value ::= QUOTE doublequoted QUOTE",
 /* 103 */ "value ::= QUOTE QUOTE",
 /* 104 */ "value ::= ID DOUBLECOLON method",
 /* 105 */ "value ::= ID DOUBLECOLON DOLLAR ID OPENP params CLOSEP",
 /* 106 */ "value ::= ID DOUBLECOLON method objectchain",
 /* 107 */ "value ::= ID DOUBLECOLON DOLLAR ID OPENP params CLOSEP objectchain",
 /* 108 */ "value ::= ID DOUBLECOLON ID",
 /* 109 */ "value ::= ID DOUBLECOLON DOLLAR ID arrayindex",
 /* 110 */ "value ::= ID DOUBLECOLON DOLLAR ID arrayindex objectchain",
 /* 111 */ "value ::= smartytag",
 /* 112 */ "variable ::= varindexed",
 /* 113 */ "variable ::= DOLLAR varvar AT ID",
 /* 114 */ "variable ::= object",
 /* 115 */ "variable ::= HATCH ID HATCH",
 /* 116 */ "variable ::= HATCH variable HATCH",
 /* 117 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 118 */ "arrayindex ::= arrayindex indexdef",
 /* 119 */ "arrayindex ::=",
 /* 120 */ "indexdef ::= DOT DOLLAR varvar",
 /* 121 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 122 */ "indexdef ::= DOT ID",
 /* 123 */ "indexdef ::= DOT BOOLEAN",
 /* 124 */ "indexdef ::= DOT NULL",
 /* 125 */ "indexdef ::= DOT INTEGER",
 /* 126 */ "indexdef ::= DOT LDEL exprs RDEL",
 /* 127 */ "indexdef ::= OPENB ID CLOSEB",
 /* 128 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 129 */ "indexdef ::= OPENB exprs CLOSEB",
 /* 130 */ "indexdef ::= OPENB CLOSEB",
 /* 131 */ "varvar ::= varvarele",
 /* 132 */ "varvar ::= varvar varvarele",
 /* 133 */ "varvarele ::= ID",
 /* 134 */ "varvarele ::= LDEL expr RDEL",
 /* 135 */ "object ::= varindexed objectchain",
 /* 136 */ "objectchain ::= objectelement",
 /* 137 */ "objectchain ::= objectchain objectelement",
 /* 138 */ "objectelement ::= PTR ID arrayindex",
 /* 139 */ "objectelement ::= PTR variable arrayindex",
 /* 140 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 141 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 142 */ "objectelement ::= PTR method",
 /* 143 */ "function ::= ID OPENP params CLOSEP",
 /* 144 */ "method ::= ID OPENP params CLOSEP",
 /* 145 */ "params ::= expr COMMA params",
 /* 146 */ "params ::= expr",
 /* 147 */ "params ::=",
 /* 148 */ "modifier ::= VERT AT ID",
 /* 149 */ "modifier ::= VERT ID",
 /* 150 */ "modparameters ::= modparameters modparameter",
 /* 151 */ "modparameters ::=",
 /* 152 */ "modparameter ::= COLON exprs",
 /* 153 */ "modparameter ::= COLON ID",
 /* 154 */ "ifexprs ::= ifexpr",
 /* 155 */ "ifexprs ::= NOT ifexprs",
 /* 156 */ "ifexprs ::= OPENP ifexprs CLOSEP",
 /* 157 */ "ifexpr ::= expr",
 /* 158 */ "ifexpr ::= expr ifcond expr",
 /* 159 */ "ifexpr ::= expr ISIN array",
 /* 160 */ "ifexpr ::= expr ISIN value",
 /* 161 */ "ifexpr ::= ifexprs lop ifexprs",
 /* 162 */ "ifexpr ::= ifexprs ISDIVBY ifexprs",
 /* 163 */ "ifexpr ::= ifexprs ISNOTDIVBY ifexprs",
 /* 164 */ "ifexpr ::= ifexprs ISEVEN",
 /* 165 */ "ifexpr ::= ifexprs ISNOTEVEN",
 /* 166 */ "ifexpr ::= ifexprs ISEVENBY ifexprs",
 /* 167 */ "ifexpr ::= ifexprs ISNOTEVENBY ifexprs",
 /* 168 */ "ifexpr ::= ifexprs ISODD",
 /* 169 */ "ifexpr ::= ifexprs ISNOTODD",
 /* 170 */ "ifexpr ::= ifexprs ISODDBY ifexprs",
 /* 171 */ "ifexpr ::= ifexprs ISNOTODDBY ifexprs",
 /* 172 */ "ifexpr ::= value INSTANCEOF ID",
 /* 173 */ "ifexpr ::= value INSTANCEOF value",
 /* 174 */ "ifcond ::= EQUALS",
 /* 175 */ "ifcond ::= NOTEQUALS",
 /* 176 */ "ifcond ::= GREATERTHAN",
 /* 177 */ "ifcond ::= LESSTHAN",
 /* 178 */ "ifcond ::= GREATEREQUAL",
 /* 179 */ "ifcond ::= LESSEQUAL",
 /* 180 */ "ifcond ::= IDENTITY",
 /* 181 */ "ifcond ::= NONEIDENTITY",
 /* 182 */ "ifcond ::= MOD",
 /* 183 */ "lop ::= LAND",
 /* 184 */ "lop ::= LOR",
 /* 185 */ "lop ::= LXOR",
 /* 186 */ "array ::= OPENB arrayelements CLOSEB",
 /* 187 */ "arrayelements ::= arrayelement",
 /* 188 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 189 */ "arrayelements ::=",
 /* 190 */ "arrayelement ::= value APTR expr",
 /* 191 */ "arrayelement ::= ID APTR expr",
 /* 192 */ "arrayelement ::= expr",
 /* 193 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 194 */ "doublequoted ::= doublequotedcontent",
 /* 195 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 196 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 197 */ "doublequotedcontent ::= DOLLARID",
 /* 198 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 199 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 200 */ "doublequotedcontent ::= smartytag",
 /* 201 */ "doublequotedcontent ::= OTHER",
 /* 202 */ "optspace ::= SPACE",
 /* 203 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 0 ),
  array( 'lhs' => 90, 'rhs' => 1 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 0 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 93, 'rhs' => 0 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 7 ),
  array( 'lhs' => 87, 'rhs' => 7 ),
  array( 'lhs' => 87, 'rhs' => 7 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 8 ),
  array( 'lhs' => 87, 'rhs' => 5 ),
  array( 'lhs' => 87, 'rhs' => 5 ),
  array( 'lhs' => 87, 'rhs' => 5 ),
  array( 'lhs' => 87, 'rhs' => 13 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 8 ),
  array( 'lhs' => 87, 'rhs' => 8 ),
  array( 'lhs' => 87, 'rhs' => 11 ),
  array( 'lhs' => 87, 'rhs' => 8 ),
  array( 'lhs' => 87, 'rhs' => 11 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 4 ),
  array( 'lhs' => 87, 'rhs' => 6 ),
  array( 'lhs' => 87, 'rhs' => 5 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 0 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 4 ),
  array( 'lhs' => 98, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 7 ),
  array( 'lhs' => 99, 'rhs' => 7 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 7 ),
  array( 'lhs' => 95, 'rhs' => 4 ),
  array( 'lhs' => 95, 'rhs' => 8 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 95, 'rhs' => 5 ),
  array( 'lhs' => 95, 'rhs' => 6 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 97, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 0 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 5 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 120, 'rhs' => 4 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 5 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 121, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 5 ),
  array( 'lhs' => 122, 'rhs' => 6 ),
  array( 'lhs' => 122, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 4 ),
  array( 'lhs' => 115, 'rhs' => 4 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 0 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 102, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 0 ),
  array( 'lhs' => 123, 'rhs' => 2 ),
  array( 'lhs' => 123, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 1 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 2 ),
  array( 'lhs' => 124, 'rhs' => 2 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 2 ),
  array( 'lhs' => 124, 'rhs' => 2 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 125, 'rhs' => 1 ),
  array( 'lhs' => 126, 'rhs' => 1 ),
  array( 'lhs' => 126, 'rhs' => 1 ),
  array( 'lhs' => 126, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 3 ),
  array( 'lhs' => 127, 'rhs' => 1 ),
  array( 'lhs' => 127, 'rhs' => 3 ),
  array( 'lhs' => 127, 'rhs' => 0 ),
  array( 'lhs' => 128, 'rhs' => 3 ),
  array( 'lhs' => 128, 'rhs' => 3 ),
  array( 'lhs' => 128, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 1 ),
  array( 'lhs' => 129, 'rhs' => 3 ),
  array( 'lhs' => 129, 'rhs' => 3 ),
  array( 'lhs' => 129, 'rhs' => 1 ),
  array( 'lhs' => 129, 'rhs' => 3 ),
  array( 'lhs' => 129, 'rhs' => 3 ),
  array( 'lhs' => 129, 'rhs' => 1 ),
  array( 'lhs' => 129, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 1 ),
  array( 'lhs' => 106, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        5 => 0,
        11 => 0,
        17 => 0,
        23 => 0,
        24 => 0,
        60 => 0,
        61 => 0,
        62 => 0,
        83 => 0,
        90 => 0,
        95 => 0,
        97 => 0,
        98 => 0,
        99 => 0,
        101 => 0,
        114 => 0,
        187 => 0,
        1 => 1,
        2 => 2,
        3 => 3,
        4 => 4,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        15 => 9,
        21 => 9,
        91 => 9,
        93 => 9,
        94 => 9,
        10 => 10,
        16 => 10,
        19 => 10,
        22 => 10,
        12 => 12,
        13 => 12,
        14 => 12,
        18 => 12,
        20 => 20,
        25 => 25,
        26 => 25,
        27 => 27,
        28 => 28,
        29 => 29,
        30 => 29,
        31 => 29,
        32 => 29,
        33 => 33,
        34 => 33,
        35 => 35,
        36 => 35,
        37 => 35,
        38 => 38,
        39 => 38,
        40 => 38,
        41 => 41,
        42 => 41,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        49 => 47,
        48 => 48,
        50 => 50,
        51 => 51,
        52 => 52,
        67 => 52,
        146 => 52,
        192 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 58,
        63 => 63,
        64 => 64,
        65 => 65,
        66 => 66,
        68 => 68,
        69 => 69,
        70 => 70,
        71 => 70,
        72 => 70,
        73 => 70,
        75 => 70,
        74 => 74,
        76 => 76,
        77 => 77,
        78 => 78,
        79 => 79,
        80 => 80,
        87 => 80,
        131 => 80,
        154 => 80,
        194 => 80,
        201 => 80,
        202 => 80,
        81 => 81,
        82 => 82,
        84 => 84,
        85 => 84,
        86 => 84,
        88 => 88,
        89 => 88,
        92 => 92,
        96 => 96,
        100 => 100,
        102 => 102,
        103 => 103,
        104 => 104,
        105 => 105,
        106 => 106,
        107 => 107,
        108 => 108,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        115 => 115,
        116 => 116,
        117 => 117,
        118 => 118,
        193 => 118,
        119 => 119,
        151 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 122,
        124 => 122,
        125 => 125,
        126 => 126,
        129 => 126,
        127 => 127,
        128 => 128,
        130 => 130,
        203 => 130,
        132 => 132,
        133 => 133,
        134 => 134,
        156 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        147 => 147,
        148 => 148,
        149 => 148,
        150 => 150,
        152 => 152,
        153 => 153,
        155 => 155,
        157 => 157,
        158 => 158,
        161 => 158,
        172 => 158,
        159 => 159,
        160 => 160,
        162 => 162,
        163 => 163,
        164 => 164,
        169 => 164,
        165 => 165,
        168 => 165,
        166 => 166,
        171 => 166,
        167 => 167,
        170 => 167,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        182 => 182,
        183 => 183,
        184 => 184,
        185 => 185,
        186 => 186,
        188 => 188,
        189 => 189,
        190 => 190,
        191 => 191,
        195 => 195,
        198 => 195,
        196 => 196,
        197 => 197,
        199 => 199,
        200 => 200,
    );
#line 81 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2044 "smarty_internal_templateparser.php"
#line 87 "smarty_internal_templateparser.y"
    function yy_r1(){if ($this->template->extract_code == false) {
                                                  $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
                                               } else {
                                                 // store code in extract buffer
                                                  $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                               } 
                                                 }
#line 2053 "smarty_internal_templateparser.php"
#line 95 "smarty_internal_templateparser.y"
    function yy_r2(){if ($this->template->extract_code == false) {
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                           } else {
                                                             // store code in extract buffer
                                                             $this->template->extracted_compiled_code .= $this->yystack[$this->yyidx + 0]->minor;
                                                             $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
                                                           } 
                                                              }
#line 2063 "smarty_internal_templateparser.php"
#line 108 "smarty_internal_templateparser.y"
    function yy_r3(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true);
                                         } else { $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;}  $this->compiler->has_variable_string = false;    }
#line 2070 "smarty_internal_templateparser.php"
#line 115 "smarty_internal_templateparser.y"
    function yy_r4(){ $this->_retvalue = '';    }
#line 2073 "smarty_internal_templateparser.php"
#line 121 "smarty_internal_templateparser.y"
    function yy_r6(){
                                      if ($this->sec_obj->php_handling == SMARTY_PHP_PASSTHRU) {
					                             $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + -2]->minor) . str_replace('<?','&lt;?',$this->yystack[$this->yyidx + -1]->minor) . '?<??>>';
                                      } elseif ($this->sec_obj->php_handling == SMARTY_PHP_QUOTE) {
                                       $this->_retvalue = $this->compiler->processNocacheCode(htmlspecialchars($this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'?>', ENT_QUOTES), false);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_ALLOW) {
                                       $this->_retvalue = $this->compiler->processNocacheCode('<?php'.$this->yystack[$this->yyidx + -1]->minor.'?>', true);
                                      }elseif ($this->sec_obj->php_handling == SMARTY_PHP_REMOVE) {
                                       $this->_retvalue = '';
                                      }
                                         }
#line 2086 "smarty_internal_templateparser.php"
#line 135 "smarty_internal_templateparser.y"
    function yy_r7(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor);	
                                     } else {
                                       $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;	
                                     }
                                        }
#line 2094 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->lex->strip) {
                                       $this->_retvalue = preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 2102 "smarty_internal_templateparser.php"
#line 150 "smarty_internal_templateparser.y"
    function yy_r9(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2105 "smarty_internal_templateparser.php"
#line 151 "smarty_internal_templateparser.y"
    function yy_r10(){ $this->_retvalue = '';     }
#line 2108 "smarty_internal_templateparser.php"
#line 154 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2111 "smarty_internal_templateparser.php"
#line 167 "smarty_internal_templateparser.y"
    function yy_r20(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2114 "smarty_internal_templateparser.php"
#line 174 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2117 "smarty_internal_templateparser.php"
#line 176 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2120 "smarty_internal_templateparser.php"
#line 184 "smarty_internal_templateparser.y"
    function yy_r28(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2123 "smarty_internal_templateparser.php"
#line 185 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2126 "smarty_internal_templateparser.php"
#line 196 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = $this->compiler->compileTag('assign',array('value'=>$this->yystack[$this->yyidx + -1]->minor,'var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'"));    }
#line 2129 "smarty_internal_templateparser.php"
#line 198 "smarty_internal_templateparser.y"
    function yy_r35(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor,'var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'"),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2132 "smarty_internal_templateparser.php"
#line 201 "smarty_internal_templateparser.y"
    function yy_r38(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array('value'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor));    }
#line 2135 "smarty_internal_templateparser.php"
#line 205 "smarty_internal_templateparser.y"
    function yy_r41(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2138 "smarty_internal_templateparser.php"
#line 207 "smarty_internal_templateparser.y"
    function yy_r43(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2141 "smarty_internal_templateparser.php"
#line 209 "smarty_internal_templateparser.y"
    function yy_r44(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2144 "smarty_internal_templateparser.php"
#line 211 "smarty_internal_templateparser.y"
    function yy_r45(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                     }
#line 2149 "smarty_internal_templateparser.php"
#line 215 "smarty_internal_templateparser.y"
    function yy_r46(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('object_methode'=>$this->yystack[$this->yyidx + -4]->minor),$this->yystack[$this->yyidx + -1]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                                }
#line 2154 "smarty_internal_templateparser.php"
#line 219 "smarty_internal_templateparser.y"
    function yy_r47(){ $this->_retvalue = $this->compiler->compileTag(($this->yystack[$this->yyidx + -3]->minor == 'else if')? 'elseif' : $this->yystack[$this->yyidx + -3]->minor,array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2157 "smarty_internal_templateparser.php"
#line 220 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->compiler->compileTag(($this->yystack[$this->yyidx + -3]->minor == 'else if')? 'elseif' : $this->yystack[$this->yyidx + -3]->minor,array('if condition'=>trim($this->yystack[$this->yyidx + -2]->minor).$this->yystack[$this->yyidx + -1]->minor));    }
#line 2160 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r50(){
                                                             $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -11]->minor,array('start'=>$this->yystack[$this->yyidx + -9]->minor,'ifexp'=>$this->yystack[$this->yyidx + -6]->minor,'varloop'=>$this->yystack[$this->yyidx + -2]->minor,'loop'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2164 "smarty_internal_templateparser.php"
#line 225 "smarty_internal_templateparser.y"
    function yy_r51(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2167 "smarty_internal_templateparser.php"
#line 226 "smarty_internal_templateparser.y"
    function yy_r52(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2170 "smarty_internal_templateparser.php"
#line 227 "smarty_internal_templateparser.y"
    function yy_r53(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array_merge(array('start'=>$this->yystack[$this->yyidx + -4]->minor,'to'=>$this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2173 "smarty_internal_templateparser.php"
#line 230 "smarty_internal_templateparser.y"
    function yy_r54(){
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2177 "smarty_internal_templateparser.php"
#line 232 "smarty_internal_templateparser.y"
    function yy_r55(){
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2181 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r56(){ 
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -6]->minor,array('from'=>$this->yystack[$this->yyidx + -4]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2185 "smarty_internal_templateparser.php"
#line 236 "smarty_internal_templateparser.y"
    function yy_r57(){ 
                                                            $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -9]->minor,array('from'=>$this->yystack[$this->yyidx + -7]->minor,'item'=>$this->yystack[$this->yyidx + -1]->minor,'key'=>$this->yystack[$this->yyidx + -4]->minor));    }
#line 2189 "smarty_internal_templateparser.php"
#line 240 "smarty_internal_templateparser.y"
    function yy_r58(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2192 "smarty_internal_templateparser.php"
#line 245 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2195 "smarty_internal_templateparser.php"
#line 246 "smarty_internal_templateparser.y"
    function yy_r64(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                         $this->_retvalue .= $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -3]->minor,'params'=>'ob_get_clean()'.$this->yystack[$this->yyidx + -2]->minor)).'?>';
                                                                                          }
#line 2200 "smarty_internal_templateparser.php"
#line 250 "smarty_internal_templateparser.y"
    function yy_r65(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2203 "smarty_internal_templateparser.php"
#line 257 "smarty_internal_templateparser.y"
    function yy_r66(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2206 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r68(){ $this->_retvalue = array();    }
#line 2209 "smarty_internal_templateparser.php"
#line 264 "smarty_internal_templateparser.y"
    function yy_r69(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2212 "smarty_internal_templateparser.php"
#line 265 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2215 "smarty_internal_templateparser.php"
#line 269 "smarty_internal_templateparser.y"
    function yy_r74(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor=>'true');    }
#line 2218 "smarty_internal_templateparser.php"
#line 276 "smarty_internal_templateparser.y"
    function yy_r76(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2221 "smarty_internal_templateparser.php"
#line 277 "smarty_internal_templateparser.y"
    function yy_r77(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2224 "smarty_internal_templateparser.php"
#line 279 "smarty_internal_templateparser.y"
    function yy_r78(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2227 "smarty_internal_templateparser.php"
#line 285 "smarty_internal_templateparser.y"
    function yy_r79(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';     }
#line 2230 "smarty_internal_templateparser.php"
#line 286 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2233 "smarty_internal_templateparser.php"
#line 288 "smarty_internal_templateparser.y"
    function yy_r81(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2236 "smarty_internal_templateparser.php"
#line 289 "smarty_internal_templateparser.y"
    function yy_r82(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array('modifier'=>$this->yystack[$this->yyidx + -1]->minor,'params'=>$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor));     }
#line 2239 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r84(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2242 "smarty_internal_templateparser.php"
#line 307 "smarty_internal_templateparser.y"
    function yy_r88(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2245 "smarty_internal_templateparser.php"
#line 316 "smarty_internal_templateparser.y"
    function yy_r92(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2248 "smarty_internal_templateparser.php"
#line 321 "smarty_internal_templateparser.y"
    function yy_r96(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2251 "smarty_internal_templateparser.php"
#line 331 "smarty_internal_templateparser.y"
    function yy_r100(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2254 "smarty_internal_templateparser.php"
#line 335 "smarty_internal_templateparser.y"
    function yy_r102(){ $_s = str_replace(array('."".','.""'),array('.',''),'"'.$this->yystack[$this->yyidx + -1]->minor.'"'); 
                                                    if (substr($_s,0,3) == '"".') {
                                                      $this->_retvalue = substr($_s,3);
                                                    } else {
                                                      $this->_retvalue = $_s;
                                                    }
                                                      }
#line 2263 "smarty_internal_templateparser.php"
#line 342 "smarty_internal_templateparser.y"
    function yy_r103(){ $this->_retvalue = "''";     }
#line 2266 "smarty_internal_templateparser.php"
#line 344 "smarty_internal_templateparser.y"
    function yy_r104(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2269 "smarty_internal_templateparser.php"
#line 345 "smarty_internal_templateparser.y"
    function yy_r105(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.'::$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';     }
#line 2272 "smarty_internal_templateparser.php"
#line 347 "smarty_internal_templateparser.y"
    function yy_r106(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor.'::'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2275 "smarty_internal_templateparser.php"
#line 348 "smarty_internal_templateparser.y"
    function yy_r107(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -4]->minor .'\')->value;?>'; $this->_retvalue = $this->yystack[$this->yyidx + -7]->minor.'::$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -2]->minor .')'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2278 "smarty_internal_templateparser.php"
#line 350 "smarty_internal_templateparser.y"
    function yy_r108(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2281 "smarty_internal_templateparser.php"
#line 352 "smarty_internal_templateparser.y"
    function yy_r109(){ $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor.'::$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2284 "smarty_internal_templateparser.php"
#line 354 "smarty_internal_templateparser.y"
    function yy_r110(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.'::$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2287 "smarty_internal_templateparser.php"
#line 356 "smarty_internal_templateparser.y"
    function yy_r111(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2290 "smarty_internal_templateparser.php"
#line 365 "smarty_internal_templateparser.y"
    function yy_r112(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2294 "smarty_internal_templateparser.php"
#line 368 "smarty_internal_templateparser.y"
    function yy_r113(){ $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2297 "smarty_internal_templateparser.php"
#line 372 "smarty_internal_templateparser.y"
    function yy_r115(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2300 "smarty_internal_templateparser.php"
#line 373 "smarty_internal_templateparser.y"
    function yy_r116(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2303 "smarty_internal_templateparser.php"
#line 376 "smarty_internal_templateparser.y"
    function yy_r117(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2306 "smarty_internal_templateparser.php"
#line 382 "smarty_internal_templateparser.y"
    function yy_r118(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2309 "smarty_internal_templateparser.php"
#line 384 "smarty_internal_templateparser.y"
    function yy_r119(){return;    }
#line 2312 "smarty_internal_templateparser.php"
#line 388 "smarty_internal_templateparser.y"
    function yy_r120(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2315 "smarty_internal_templateparser.php"
#line 389 "smarty_internal_templateparser.y"
    function yy_r121(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2318 "smarty_internal_templateparser.php"
#line 392 "smarty_internal_templateparser.y"
    function yy_r122(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2321 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r125(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2324 "smarty_internal_templateparser.php"
#line 397 "smarty_internal_templateparser.y"
    function yy_r126(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2327 "smarty_internal_templateparser.php"
#line 399 "smarty_internal_templateparser.y"
    function yy_r127(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2330 "smarty_internal_templateparser.php"
#line 400 "smarty_internal_templateparser.y"
    function yy_r128(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable','[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2333 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r130(){$this->_retvalue = '';    }
#line 2336 "smarty_internal_templateparser.php"
#line 412 "smarty_internal_templateparser.y"
    function yy_r132(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2339 "smarty_internal_templateparser.php"
#line 414 "smarty_internal_templateparser.y"
    function yy_r133(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2342 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r134(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2345 "smarty_internal_templateparser.php"
#line 422 "smarty_internal_templateparser.y"
    function yy_r135(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2349 "smarty_internal_templateparser.php"
#line 425 "smarty_internal_templateparser.y"
    function yy_r136(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2352 "smarty_internal_templateparser.php"
#line 427 "smarty_internal_templateparser.y"
    function yy_r137(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2355 "smarty_internal_templateparser.php"
#line 429 "smarty_internal_templateparser.y"
    function yy_r138(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2358 "smarty_internal_templateparser.php"
#line 430 "smarty_internal_templateparser.y"
    function yy_r139(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2361 "smarty_internal_templateparser.php"
#line 431 "smarty_internal_templateparser.y"
    function yy_r140(){ $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2364 "smarty_internal_templateparser.php"
#line 432 "smarty_internal_templateparser.y"
    function yy_r141(){ $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';    }
#line 2367 "smarty_internal_templateparser.php"
#line 434 "smarty_internal_templateparser.y"
    function yy_r142(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2370 "smarty_internal_templateparser.php"
#line 440 "smarty_internal_templateparser.y"
    function yy_r143(){if (!$this->template->security || $this->smarty->security_handler->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if ($this->yystack[$this->yyidx + -3]->minor == 'isset' || $this->yystack[$this->yyidx + -3]->minor == 'empty' || $this->yystack[$this->yyidx + -3]->minor == 'array' || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2379 "smarty_internal_templateparser.php"
#line 451 "smarty_internal_templateparser.y"
    function yy_r144(){ $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";    }
#line 2382 "smarty_internal_templateparser.php"
#line 455 "smarty_internal_templateparser.y"
    function yy_r145(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2385 "smarty_internal_templateparser.php"
#line 459 "smarty_internal_templateparser.y"
    function yy_r147(){ return;    }
#line 2388 "smarty_internal_templateparser.php"
#line 464 "smarty_internal_templateparser.y"
    function yy_r148(){ $this->_retvalue =  $this->yystack[$this->yyidx + 0]->minor;    }
#line 2391 "smarty_internal_templateparser.php"
#line 477 "smarty_internal_templateparser.y"
    function yy_r150(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2394 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r152(){$this->_retvalue = ','.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2397 "smarty_internal_templateparser.php"
#line 482 "smarty_internal_templateparser.y"
    function yy_r153(){$this->_retvalue = ',\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2400 "smarty_internal_templateparser.php"
#line 489 "smarty_internal_templateparser.y"
    function yy_r155(){$this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2403 "smarty_internal_templateparser.php"
#line 494 "smarty_internal_templateparser.y"
    function yy_r157(){$this->_retvalue =$this->yystack[$this->yyidx + 0]->minor;    }
#line 2406 "smarty_internal_templateparser.php"
#line 495 "smarty_internal_templateparser.y"
    function yy_r158(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2409 "smarty_internal_templateparser.php"
#line 496 "smarty_internal_templateparser.y"
    function yy_r159(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2412 "smarty_internal_templateparser.php"
#line 497 "smarty_internal_templateparser.y"
    function yy_r160(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2415 "smarty_internal_templateparser.php"
#line 499 "smarty_internal_templateparser.y"
    function yy_r162(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2418 "smarty_internal_templateparser.php"
#line 500 "smarty_internal_templateparser.y"
    function yy_r163(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2421 "smarty_internal_templateparser.php"
#line 501 "smarty_internal_templateparser.y"
    function yy_r164(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2424 "smarty_internal_templateparser.php"
#line 502 "smarty_internal_templateparser.y"
    function yy_r165(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2427 "smarty_internal_templateparser.php"
#line 503 "smarty_internal_templateparser.y"
    function yy_r166(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2430 "smarty_internal_templateparser.php"
#line 504 "smarty_internal_templateparser.y"
    function yy_r167(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2433 "smarty_internal_templateparser.php"
#line 510 "smarty_internal_templateparser.y"
    function yy_r173(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2436 "smarty_internal_templateparser.php"
#line 512 "smarty_internal_templateparser.y"
    function yy_r174(){$this->_retvalue = '==';    }
#line 2439 "smarty_internal_templateparser.php"
#line 513 "smarty_internal_templateparser.y"
    function yy_r175(){$this->_retvalue = '!=';    }
#line 2442 "smarty_internal_templateparser.php"
#line 514 "smarty_internal_templateparser.y"
    function yy_r176(){$this->_retvalue = '>';    }
#line 2445 "smarty_internal_templateparser.php"
#line 515 "smarty_internal_templateparser.y"
    function yy_r177(){$this->_retvalue = '<';    }
#line 2448 "smarty_internal_templateparser.php"
#line 516 "smarty_internal_templateparser.y"
    function yy_r178(){$this->_retvalue = '>=';    }
#line 2451 "smarty_internal_templateparser.php"
#line 517 "smarty_internal_templateparser.y"
    function yy_r179(){$this->_retvalue = '<=';    }
#line 2454 "smarty_internal_templateparser.php"
#line 518 "smarty_internal_templateparser.y"
    function yy_r180(){$this->_retvalue = '===';    }
#line 2457 "smarty_internal_templateparser.php"
#line 519 "smarty_internal_templateparser.y"
    function yy_r181(){$this->_retvalue = '!==';    }
#line 2460 "smarty_internal_templateparser.php"
#line 520 "smarty_internal_templateparser.y"
    function yy_r182(){$this->_retvalue = '%';    }
#line 2463 "smarty_internal_templateparser.php"
#line 522 "smarty_internal_templateparser.y"
    function yy_r183(){$this->_retvalue = '&&';    }
#line 2466 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r184(){$this->_retvalue = '||';    }
#line 2469 "smarty_internal_templateparser.php"
#line 524 "smarty_internal_templateparser.y"
    function yy_r185(){$this->_retvalue = ' XOR ';    }
#line 2472 "smarty_internal_templateparser.php"
#line 529 "smarty_internal_templateparser.y"
    function yy_r186(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2475 "smarty_internal_templateparser.php"
#line 531 "smarty_internal_templateparser.y"
    function yy_r188(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2478 "smarty_internal_templateparser.php"
#line 532 "smarty_internal_templateparser.y"
    function yy_r189(){ return;     }
#line 2481 "smarty_internal_templateparser.php"
#line 533 "smarty_internal_templateparser.y"
    function yy_r190(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2484 "smarty_internal_templateparser.php"
#line 534 "smarty_internal_templateparser.y"
    function yy_r191(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2487 "smarty_internal_templateparser.php"
#line 543 "smarty_internal_templateparser.y"
    function yy_r195(){if (substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '\'' || substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '@') {
                                                                 $this->_retvalue = '".'.$this->yystack[$this->yyidx + -1]->minor.'."'; $this->compiler->has_variable_string = true;
                                                                } else {
                                                                 $this->_retvalue = '{'.$this->yystack[$this->yyidx + -1]->minor.'}'; $this->compiler->has_variable_string = true;
                                                                }
                                                                   }
#line 2495 "smarty_internal_templateparser.php"
#line 549 "smarty_internal_templateparser.y"
    function yy_r196(){$this->_retvalue = '{'.$this->yystack[$this->yyidx + -1]->minor.'}'; $this->compiler->has_variable_string = true;    }
#line 2498 "smarty_internal_templateparser.php"
#line 550 "smarty_internal_templateparser.y"
    function yy_r197(){$this->_retvalue = '{$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value}'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache; $this->compiler->has_variable_string = true;    }
#line 2501 "smarty_internal_templateparser.php"
#line 557 "smarty_internal_templateparser.y"
    function yy_r199(){ $this->_retvalue = '".('.$this->yystack[$this->yyidx + -1]->minor.')."'; $this->compiler->has_variable_string = true;    }
#line 2504 "smarty_internal_templateparser.php"
#line 558 "smarty_internal_templateparser.y"
    function yy_r200(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '{$_tmp'.$this->prefix_number.'}'; $this->compiler->has_variable_string = true;    }
#line 2507 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 71 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2570 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 63 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2588 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>
