/* goat_callbacks.h */

/* Callbacks for UI actions on the note */

gint goat_menu_button_cb(GtkWidget *w, 
			 GdkEventButton *event, 
		         Goat *goat);
void goat_menu_popup_cb(GtkWidget *w, 
			Goat *goat);
gint goat_text_focus_out_cb(GtkWidget *w, 
			    GdkEventFocus *event, 
			    Goat *goat);
gint goat_resize_pressed_cb(GtkWidget *w, 
			    GdkEventButton *event, 
			    Goat *goat);
gint goat_topbar_pressed_cb(GtkWidget *w, 
			    GdkEventButton *event, 
			    Goat *goat);
gint goat_cross_pressed_cb(GtkWidget *w, 
			   GdkEventButton *event, 
			   Goat *goat);
void goat_drag_received_cb(GtkWidget *w, 
			   GdkDragContext *context,
			   gint x, gint y, 
			   GtkSelectionData *data,
			   guint info, guint time, 
			   Goat *goat);
gint goat_configure_cb(GtkWidget *w, 
		       GdkEventConfigure *event,
		       Goat *goat);

/* Callbacks for when widgets are created */

void goat_window_mapped_cb(GtkWidget *w, Goat *goat);
void goat_text_mapped_cb(GtkWidget *w, Goat *goat);
void goat_e0_mapped_cb(GtkWidget *w, Goat *goat);
void goat_e1_mapped_cb(GtkWidget *w, Goat *goat);
void goat_e2_mapped_cb(GtkWidget *w, Goat *goat);
void goat_window_realized_cb(GtkWidget *w, Goat *goat);

/* Menu callbacks */

void goat_text_save_cb(GtkWidget *w, Goat *goat);
void goat_text_cut_cb(GtkWidget *w, Goat *goat);
void goat_text_copy_cb(GtkWidget *w, Goat *goat);
void goat_text_paste_cb(GtkWidget *w, Goat *goat);
void goat_text_print_cb(GtkWidget *w, Goat *goat);
void goat_text_mail_cb(GtkWidget *w, Goat *goat);
void goat_text_ipmessage_cb(GtkWidget *w, Goat *goat);
void goat_text_clear_cb(GtkWidget *w, Goat *goat);

void goat_set_title_cb(GtkWidget *w, Goat *goat);
void goat_set_alarm_cb(GtkWidget *w, Goat *goat);

void goat_insert_file_cb(GtkWidget *w, Goat *goat);
void goat_insert_time_cb(GtkWidget *w, Goat *goat);
void goat_insert_date_cb(GtkWidget *w, Goat *goat);
void goat_insert_calendar_cb(GtkWidget *w, Goat *goat);
void goat_insert_fortune_cb(GtkWidget *w, Goat *goat);

void goat_properties_autosize_cb(GtkWidget *w, Goat *goat);
void goat_properties_font_cb(GtkWidget *w, Goat *goat);
void goat_properties_bg_cb(GtkWidget *w, Goat *goat);
void goat_properties_fg_cb(GtkWidget *widget, Goat *goat);

void goat_sticky_cb(GtkWidget *w, Goat *goat);
void goat_shade_cb(GtkWidget *w, Goat *goat);
void goat_create_new_cb(GtkWidget *w, Goat *goat);
void goat_raise_cb(GtkWidget *w, Goat *goat);
void goat_lower_cb(GtkWidget *w, Goat *goat);
void goat_hide_cb(GtkWidget *w, Goat *goat);
void goat_delete_cb(GtkWidget *w, Goat *goat);

/* Alarm callbacks */

void goat_alarm_triggered_cb(Goat *goat);
gint goat_alarm_dialog_delete_cb(GtkWidget *widget, 
				 GdkEvent *event,
				 Goat *goat);
void goat_alarm_dialog_ok_cb(GtkWidget *widget, Goat *goat);
void goat_alarm_dialog_help_cb(GtkWidget *widget, Goat *goat);
void goat_alarm_dialog_apply_cb(GtkWidget *widget, Goat *goat);
void goat_alarm_dialog_cancel_cb(GtkWidget *button, Goat *goat);
void goat_alarm_active_toggled_cb(GtkWidget *toggle, Goat *goat);
void goat_alarm_sound_toggled_cb(GtkWidget *toggle, Goat *goat);
void goat_alarm_menu_changed_cb(GtkWidget *menu, Goat *goat);

/* GConf callbacks */

void goat_settings_changed_cb(GConfClient *client, 
			      guint id,
			      GConfEntry *entry, 
			      Goat *goat);
void goat_properties_changed_cb(GConfClient *client, 
				guint id,
				GConfEntry *entry, 
				Goat *goat);
