/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* engine.c
 *
 * Copyright (C) 2001  Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Robert Wilhelm
 *          JP Rosevear
 */

#include <gnome.h>
#include "engine.h"

struct _EnginePrivate {
	gint dummy;
};

enum signals {
	GAME_SIGNAL,
	MOVE_SIGNAL,
	UNMOVE_SIGNAL,
	INFO_SIGNAL,
	ERROR_SIGNAL,
	LAST_SIGNAL
};
static gint signals[LAST_SIGNAL] = { 0 };

/* Prototypes */
static void class_init (EngineClass *klass);
static void init (Engine *engine);
static void destroy (GtkObject *obj);

static GtkObjectClass *parent_class = NULL;


GtkType
engine_get_type (void)
{
  static GtkType type = 0;

  if (type == 0)
    {
      static const GtkTypeInfo info =
      {
        "Engine",
        sizeof (Engine),
        sizeof (EngineClass),
        (GtkClassInitFunc) class_init,
        (GtkObjectInitFunc) init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      type = gtk_type_unique (gtk_object_get_type (), &info);
    }

  return type;
}

static void
class_init (EngineClass *klass)
{
	GtkObjectClass *object_class;

	object_class = GTK_OBJECT_CLASS (klass);

	parent_class = gtk_type_class (gtk_object_get_type ());

	signals[GAME_SIGNAL] =
		gtk_signal_new ("game",
				GTK_RUN_FIRST,
				object_class->type,
				GTK_SIGNAL_OFFSET (EngineClass, game),
				gtk_marshal_NONE__INT_POINTER, GTK_TYPE_NONE,
				2, GTK_TYPE_INT, GTK_TYPE_POINTER);
		
	signals[MOVE_SIGNAL] =
		gtk_signal_new ("move",
				GTK_RUN_FIRST,
				object_class->type,
				GTK_SIGNAL_OFFSET (EngineClass, move),
				gtk_marshal_NONE__INT_INT, GTK_TYPE_NONE,
				2, GTK_TYPE_INT, GTK_TYPE_INT);

	signals[UNMOVE_SIGNAL] =
		gtk_signal_new ("unmove",
				GTK_RUN_FIRST,
				object_class->type,
				GTK_SIGNAL_OFFSET (EngineClass, unmove),
				gtk_marshal_NONE__INT, GTK_TYPE_NONE,
				1, GTK_TYPE_INT);
	
	signals[INFO_SIGNAL] =
		gtk_signal_new ("info",
				GTK_RUN_FIRST,
				object_class->type,
				GTK_SIGNAL_OFFSET (EngineClass, info),
				gtk_marshal_NONE__POINTER, GTK_TYPE_NONE,
				1, GTK_TYPE_POINTER);

	signals[ERROR_SIGNAL] =
		gtk_signal_new ("error",
				GTK_RUN_FIRST,
				object_class->type,
				GTK_SIGNAL_OFFSET (EngineClass, error),
				gtk_marshal_NONE__INT, GTK_TYPE_NONE,
				1, GTK_TYPE_INT);
	
	gtk_object_class_add_signals (object_class,
				      signals,
				      LAST_SIGNAL);
	
	object_class->destroy = destroy;
}


static void
init (Engine *engine)
{
	EnginePrivate *priv;

	priv = g_new0 (EnginePrivate, 1);

	engine->priv = priv;
}

static void
destroy (GtkObject *obj)
{
	Engine *engine;
	EnginePrivate *priv;

	engine = ENGINE (obj);
	priv = engine->priv;

	g_free (priv);

	GTK_OBJECT_CLASS (parent_class)->destroy (obj);
}


GtkObject *
engine_new (void)
{
	return GTK_OBJECT (gtk_type_new (TYPE_ENGINE));
}

void 
engine_fill_menu (Engine *engine, GtkMenuShell *shell, gint pos)
{
	EngineClass *klass;

	g_return_if_fail (engine != NULL);
	g_return_if_fail (IS_ENGINE (engine));
	g_return_if_fail (shell != NULL);
	g_return_if_fail (GTK_IS_MENU_SHELL (shell));

	klass = ENGINE_CLASS (GTK_OBJECT (engine)->klass);
	
	if (klass->engine_fill_menu)
		klass->engine_fill_menu (engine, shell, pos);
}

void
engine_move (Engine *engine, Square from, Square to)
{
	EngineClass *klass;
	
	g_return_if_fail (engine != NULL);
	g_return_if_fail (IS_ENGINE (engine));

	klass = ENGINE_CLASS (GTK_OBJECT (engine)->klass);

	if (klass->engine_move)
		klass->engine_move (engine, from, to);
}

void
engine_expire (Engine *engine, gshort color)
{
	EngineClass *klass;
	
	g_return_if_fail (engine != NULL);
	g_return_if_fail (IS_ENGINE (engine));

	klass = ENGINE_CLASS (GTK_OBJECT (engine)->klass);
	
	if (klass->engine_expire)
		klass->engine_expire (engine, color);
}
