/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* board_info.h
 *
 * Copyright (C) 2001  JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _BOARD_INFO_H_
#define _BOARD_INFO_H_

#include <gtk/gtk.h>
#include "engine.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define BOARD_TYPE_INFO			(board_info_get_type ())
#define BOARD_INFO(obj)			(GTK_CHECK_CAST ((obj), BOARD_TYPE_INFO, BoardInfo))
#define BOARD_INFO_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), BOARD_TYPE_INFO, BoardInfoClass))
#define IS_BOARD_INFO(obj)		(GTK_CHECK_TYPE ((obj), BOARD_TYPE_INFO))
#define IS_BOARD_INFO_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), BOARD_TYPE_INFO))


typedef struct _BoardInfo        BoardInfo;
typedef struct _BoardInfoPrivate BoardInfoPrivate;
typedef struct _BoardInfoClass   BoardInfoClass;

struct _BoardInfo {
	GtkVBox parent;

	BoardInfoPrivate *priv;
};

struct _BoardInfoClass {
	GtkVBoxClass parent_class;

	void (*white_expired) (BoardInfo *info);
	void (*black_expired) (BoardInfo *info);
};



GtkType    board_info_get_type       (void);
GtkWidget *board_info_new            (void);
void       board_info_set_flip       (BoardInfo   *info,
				      gboolean     flip);
void       board_info_set_game_info  (BoardInfo   *info,
				      EngineInfo  *gameinfo);
gchar*     board_info_get_white_name (BoardInfo   *info);
void       board_info_set_white_name (BoardInfo   *info,
				      const gchar *name);
gchar*     board_info_get_black_name (BoardInfo   *info);
void       board_info_set_black_name (BoardInfo   *info,
				      const gchar *name);
gint       board_info_get_white_time (BoardInfo   *info);
void       board_info_set_white_time (BoardInfo   *info,
				      gint         secs);
gint       board_info_get_black_time (BoardInfo   *info);
void       board_info_set_black_time (BoardInfo   *info,
				      gint         secs);
gint       board_info_get_result     (BoardInfo   *info);
void       board_info_set_result     (BoardInfo   *info,
				      gint         result);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _BOARD_INFO_H_ */
