/* gnobog_save_file_dialog.c
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <config.h>
#include <gnome.h>
#include <glade/glade.h>

#include "gnobog_app.h"
#include "gnobog_bookmarks.h"
#include "gnobog_save_file_dialog.h"

#define NETSCAPE_CHOICE 1
#define MOZILLA_CHOICE  2
#define OTHER_CHOICE    3

GladeXML        *xml;
static gint     gnobog_save_file_dialog_radio_button_state;
static gchar*   gnobog_save_file_dialog_filename;
static gboolean gnobog_save_file_dialog_unblock_flag;

/* Callbacks for "Save File" dialog box*/
void gnobog_save_file_dialog_radio_button_cb (GtkWidget* widget, gpointer data);
void gnobog_save_file_dialog_ok_cb (GtkWidget* widget, gpointer user_data);
void gnobog_save_file_dialog_cancel_cb (GtkWidget* widget, gpointer user_data);
void gnobog_save_file_dialog_browse_cb (GtkWidget* widget);

/* This callback is called when one of the radio button is pressed.
   This callback just store the user choice */
void
gnobog_save_file_dialog_radio_button_cb (GtkWidget* widget, gpointer data)
{
  /* Store user choice */
  gnobog_save_file_dialog_radio_button_state = GPOINTER_TO_INT(data);   
  g_message ("Radio button : %d", gnobog_save_file_dialog_radio_button_state);

  return;
}

/* This callback is called when "Ok" button is pressed.
   This callback build the filename in function  */
void
gnobog_save_file_dialog_ok_cb (GtkWidget* widget, gpointer data)
{
  GtkWidget*            glade_widget;
  GnomeDialog*  dialog;
  gchar*                        filename;

  /* Initialize filename*/
  filename = NULL;

  /* Build the filename according to user's choice*/
  switch (gnobog_save_file_dialog_radio_button_state) {
  case NETSCAPE_CHOICE:
    filename = g_strconcat(home_dir, "/.netscape/bookmarks.html", NULL);
    break;
  case MOZILLA_CHOICE:
    filename = g_strconcat(home_dir, "/.mozilla/default/bookmarks.html", NULL);
    break;
  case OTHER_CHOICE:
    /* Ask the filename to the file selector */
    glade_widget = glade_xml_get_widget (xml, "fileentry");
    filename = gnome_file_entry_get_full_path (GNOME_FILE_ENTRY (glade_widget), FALSE);
    break;
  default:
    g_warning ("We cannot be here");
  }

  /* If no filename, then popup a dialog and let the user in front of the dialog box */
  if (filename == NULL || *filename == '\0') {
    dialog = GNOME_DIALOG (gnome_error_dialog (_("If you want to save a file, give me a name !")));
    gnome_dialog_run_and_close (dialog);
    /* Set flag so that main function gnobog_ui_save_file
       keeps on blocking */
    gnobog_save_file_dialog_unblock_flag = FALSE;
    return;
  }

  /* Blah blah..*/
  g_message ("Selected filename to save : %s", filename);

  /* Destroy "Save File" dialog Box */
  gtk_widget_destroy (GTK_WIDGET (widget));

  /* Store filename so main function (gnobog_ui_save_file)
     can retrieve it */
  gnobog_save_file_dialog_filename = filename;

  /* Set flag so that main function gnobog_ui_save_file
     no longer blocks */
  gnobog_save_file_dialog_unblock_flag = TRUE;

  return;
}

/* This callback is called when "Cancel" Button is pressed.
   This one just destroy the "Save File" dialog box. */
void
gnobog_save_file_dialog_cancel_cb (GtkWidget* widget, gpointer data)
{
  /* User finally don't want to save... */
  gnobog_save_file_dialog_filename = NULL;

  /* Destroy "Open File" dialog Box */
  gtk_widget_destroy (GTK_WIDGET (widget));

  /* Set flag so that main function gnobog_ui_save_file
           no longer blocks */
  gnobog_save_file_dialog_unblock_flag = TRUE;

  return;
}

/* This callback is called when "Browse" Button is pressed.
   It activates radiobutton_other and sets OTHER_CHOICE */
void
gnobog_save_file_dialog_browse_cb (GtkWidget* widget)
{
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(widget), TRUE);
  gnobog_save_file_dialog_radio_button_state = OTHER_CHOICE; 
}
  
/* This function initializes values in "Save File" dialog box.
   Then it displays and run the dialog box. */
gchar*
gnobog_ui_save_file (gchar* current_filename)
{
  GnomeDialog*  gnobog_save_file_dialog;
  GnomeDialog*  dialog;
  GtkWidget*    glade_widget;
  GtkWidget*    other_choice_widget;    
  gchar*        filename;
  gint          reply;
  gboolean      netscape_flag;
  gboolean      other_flag;
        
  /* Load "Bookmark Properties" dialog box from Glade file and process it */
  xml = glade_xml_new (GNOBOG_GLADEDIR "/gnobog.glade", "gnobog_save_file_dialog");
  /* Used for tests */
  //    xml = glade_xml_new ("glade/gnobog.glade", "gnobog_save_file_dialog");
  if (!xml) {
    g_warning ("Cannot load interface from Glade file");
    dialog = GNOME_DIALOG (gnome_error_dialog (_("Cannot load interface from Glade file\n\
                                       Your bookmarks will be saved under ~/gnobog_recup.html")));
    gnome_dialog_run_and_close (dialog);
    /* Return a default filename to avoid crash */
    filename = g_strconcat(home_dir, "/gnobog_recup.html", NULL);
    /* g_free (home_dir); */
    return filename;
  }

  /* Get dialog widget */
  gnobog_save_file_dialog = GNOME_DIALOG (glade_xml_get_widget (xml, "gnobog_save_file_dialog"));

  /* Initialize global variables of dialog */
  if ( current_filename == NULL || *current_filename == '\0') {
    gnobog_save_file_dialog_radio_button_state = NETSCAPE_CHOICE;
    gnobog_save_file_dialog_filename = NULL;
    netscape_flag = TRUE;
    other_flag = FALSE;
  } else {
    gnobog_save_file_dialog_radio_button_state = OTHER_CHOICE;
    gnobog_save_file_dialog_filename = current_filename;
    netscape_flag = FALSE;
    other_flag = TRUE;
  }
  gnobog_save_file_dialog_unblock_flag = TRUE;

  /* Initialize dialog box content and signals */
  /** radio buttons **/
  glade_widget = glade_xml_get_widget (xml, "radiobutton_netscape");
  gtk_signal_connect(GTK_OBJECT(glade_widget),
                     "clicked",
                     GTK_SIGNAL_FUNC(gnobog_save_file_dialog_radio_button_cb),
                     GINT_TO_POINTER(NETSCAPE_CHOICE));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(glade_widget), netscape_flag);

  glade_widget = glade_xml_get_widget (xml, "radiobutton_mozilla");
  gtk_signal_connect(GTK_OBJECT(glade_widget),
                     "clicked",
                     GTK_SIGNAL_FUNC(gnobog_save_file_dialog_radio_button_cb),
                     GINT_TO_POINTER(MOZILLA_CHOICE));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(glade_widget), FALSE);

  glade_widget = glade_xml_get_widget (xml, "radiobutton_other");
  other_choice_widget = glade_widget;
  gtk_signal_connect(GTK_OBJECT(glade_widget),
                     "clicked",
                     GTK_SIGNAL_FUNC(gnobog_save_file_dialog_radio_button_cb),
                     GINT_TO_POINTER(OTHER_CHOICE));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(glade_widget), other_flag);

  glade_widget = glade_xml_get_widget(xml,"fileentry");
  gtk_signal_connect_object(GTK_OBJECT(glade_widget),
                        "browse_clicked",
                        GTK_SIGNAL_FUNC(gnobog_save_file_dialog_browse_cb),
                        GTK_OBJECT (other_choice_widget));
  
  /** file entry **/
  glade_widget = glade_xml_get_widget (xml, "fileentry");
  if ( other_flag ) {
    gtk_entry_set_text (GTK_ENTRY (gnome_file_entry_gtk_entry (GNOME_FILE_ENTRY (glade_widget))),
                        current_filename);

  }

  /* Connect all signal with functions name given in glade file */
  glade_xml_signal_autoconnect (xml);

  /* Block until user's choose a filename or cancel operation */
  //  while (gnobog_save_file_dialog_unblock_flag == FALSE) {
  do {
    /* Block until user's press a button in dialog box */
    reply = gnome_dialog_run (gnobog_save_file_dialog);
  } while (gnobog_save_file_dialog_unblock_flag == FALSE);

  return gnobog_save_file_dialog_filename;
}
