/* gnobog_dnd.h
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOBOG_DND_H
#define GNOBOG_DND_H


/* Target types for drag and drop */
enum _DndTargetType { 
  GNOBOG_BOOKMARK_ENTRY, 
  TEXT_URI_LIST, 
  MOZILLA_URL, 
  STRING, 
  NUM_TARGETS
};
typedef enum _DndTargetType DndTargetType;

#define GNOBOG_BOOKMARK_ENTRY_ATOM_NAME	  "gnobog_bookmark"
#define MOZILLA_URL_ATOM_NAME		  "_NETSCAPE_URL"
#define STRING_ATOM_NAME		  "STRING"
#define TEXT_URI_LIST_ATOM_NAME		  "text/uri-list"

/* Array containing Target Types for drag&drop.
 * Define the types of data our program can accept as a target
 * Order is important, the source and target will exchange data with the
 * 1st format they both know in this list
 */
extern const GtkTargetEntry dnd_target_types_array [];
/* Number of known targets for drag&drop */
extern const gint dnd_n_target_types;


#endif
