------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-number_functions.ads,v 1.5 2003/11/27 12:34:00 vagul Exp $

with
   OCI.Thick.Gen_OCINumber,
   OCI.Lib;

package OCI.Thick.Number_Functions is

   use Thick.Gen_OCINumber;
   use Lib;

   function "Abs"  is new Unary_Function (OCINumberAbs);
   function ArcCos is new Unary_Function (OCINumberArcCos);
   function ArcSin is new Unary_Function (OCINumberArcSin);
   function ArcTan is new Unary_Function (OCINumberArcTan);
   function Assign is new Unary_Function (OCINumberAssign);
   function Ceil   is new Unary_Function (OCINumberCeil);
   function Cos    is new Unary_Function (OCINumberCos);
   function Exp    is new Unary_Function (OCINumberExp);
   function Floor  is new Unary_Function (OCINumberFloor);
   function HypCos is new Unary_Function (OCINumberHypCos);
   function HypSin is new Unary_Function (OCINumberHypSin);
   function HypTan is new Unary_Function (OCINumberHypTan);
   function Ln     is new Unary_Function (OCINumberLn);
   function "-"    is new Unary_Function (OCINumberNeg);
   function Sin    is new Unary_Function (OCINumberSin);
   function Sqrt   is new Unary_Function (OCINumberSqrt);
   function Tan    is new Unary_Function (OCINumberTan);

   function ArcTan2 is new Binary_Function (OCINumberArcTan2);
   function "+"     is new Binary_Function (OCINumberAdd);
   function "/"     is new Binary_Function (OCINumberDiv);
   function Log     is new Binary_Function (OCINumberLog);
   function "mod"   is new Binary_Function (OCINumberMod);
   function "*"     is new Binary_Function (OCINumberMul);
   function "**"    is new Binary_Function (OCINumberPower);
   function "-"     is new Binary_Function (OCINumberSub);

   function To_String (From : OCINumber; Format : String) return String;

   function To_Number (From : String; Format : String) return OCINumber;

   function To_Long_Float (Numb : OCINumber) return Long_Float;

   function To_Number (From : Long_Float) return OCINumber;

end OCI.Thick.Number_Functions;
