------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-binds.adb,v 1.6 2003/11/24 11:43:48 vagul Exp $

with OCI.Thread;

package body OCI.Thick.Binds is

   ----------
   -- Bind --
   ----------

   procedure Bind
     (Stmt    : in     Statement;
      Var     : in out Abstract_Bind'Class;
      Name    : in     String;
      Type_Id : in     Ub2;
      Value   : in     DVoid;
      Size    : in     Sb4;
      Ind     : in     A_Sb2)
   is
      Rc : SWord := OCIBindByName
                      (stmtp       => OCIStmt (Handle (Stmt)),
                       bindpp      => Var.Bind'Access,
                       errhp       => Thread.Error,
                       placeholder => C.To_C (Name),
                       placeh_len  => Name'Length,
                       valuep      => Value,
                       value_sz    => Size,
                       dty         => Type_Id,
                       indp        => Ind);
   begin
      Check_Error (Rc);
      Var.Stmt := Stmt;
   end Bind;

   -------------
   -- Destroy --
   -------------

   procedure Destroy (Item : in out Abstract_Bind) is
      pragma Unreferenced (Item);
   begin
      null;
   end Destroy;

end OCI.Thick.Binds;

