/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * Authen.h --- class to manage CVS authentication kind
 */

#ifndef AUTHEN_H
#define AUTHEN_H

#include "MultiString.h"

// authentication class
typedef enum
{
	rhosts, // rhosts file
	pserver, // pserver
	kserver, // kserver
	local, // mounted point
	ssh, // ssh
	ntserver // ntserver
} AuthenKind;

class Authen
{
public :
	Authen() {}
	
	AuthenKind kind(void);
	const char *kindstr(void);
	void setkind(AuthenKind newkind);
	
	static const char *kindToToken(AuthenKind k);
	static AuthenKind tokenToKind(const char *t);

    bool RsaIdentity(void) const;
	void SetRsaIdentity(bool newState);
    const char * RsaIdentityFile(void) const;
	void SetRsaIdentityFile(const char *newrsaidentityfile);

	// access the RSAIDENTITY list
	CMString & get_rsaidentity_list();

	// ":pserver:", ":kserver:"
	const char *token(void);
	static const char * skiptoken(const char *cvsroot);
};

extern Authen gAuthen;

#endif /* AUTHEN_H */
