#include <net/if.h>
class packet {
public:
    unsigned long packet_id; // unique packet id, needed for accepting or dropping a packet (libipq)
    unsigned long arrived; // time the packet arrived (in seconds)
    unsigned char interface_in[IFNAMSIZ]; // name of incoming interface
    unsigned char interface_out[IFNAMSIZ]; // name of outgoing interface
    unsigned short int len; // length of packet data
    unsigned long ip_src; // source ip
    unsigned long ip_dst; // destination ip
    unsigned int protocol:8; // protocol id (see rules.h)

    unsigned short int port_src; // source port
    unsigned short int port_dst; // destination port

    unsigned short int tcp_flags; // tcp flags: ACK, FIN, RST, SYN, ...

    unsigned int icmp_type:8; // type of icmp packet

    unsigned int mac_addrlen:8; // real length of mac address 
    unsigned char mac_addr[8]; // mac is maximum 8 bytes
    unsigned int hook; // chain (INPUT=1, FORWARD=2, OUTPUT=3)
    char *data; // packet data
    char *programname; // program using this packets localport/localip
    ~packet();
};
void sendCmd(int id, int ipsrc, int ipdst, int portsrc, int portdst, int intin, int intout, int macaddr, int protocol, int conntrack, int programname, int timeout, int action);
