/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: support.h
 */ 

#ifndef EVMSGUI_SUPPORT_H_INCLUDED
#define EVMSGUI_SUPPORT_H_INCLUDED 1

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#define SUCCESS 0

GtkWidget* lookup_widget (GtkWidget *widget, const gchar *widget_name);

void on_button_clicked_destroy_window (GtkButton *button, gpointer user_data);

void display_not_implemented_yet_popup (void);

void display_popup_window (gchar *title, gchar *message);

void display_help_window (GtkWindow *parent, gchar *text);

inline GList* get_window_list (GtkWidget *widget);

inline void set_window_list (GtkWidget *widget, GList *window_list);

inline void destroy_window_list (GList *window_list);

void complete_display_results_window_work (GtkWidget *window, gchar *message, GList *window_list, 
                                           gboolean refresh_views);

GtkWidget* display_results_window (gint rc, gchar *title, gchar *message, GList *window_list, 
                                   gboolean refresh_views, GtkWidget *parent_window);

gboolean editable_field_is_blank (GtkEditable *editable);

gboolean check_for_empty_list_when_exposed (GtkCList *clist, GdkEventExpose *event, gpointer user_data);

GtkWidget* create_standard_selection_window (gchar *window_title, 
                                             gchar *next_button_label,
                                             gchar *help_text,
                                             GtkSignalFunc clist_realize_sighandler, 
                                             GtkSignalFunc next_button_sighandler, 
                                             GtkSignalFunc prev_button_sighandler,
                                             GtkSignalFunc cancel_button_sighandler,
                                             GtkSignalFunc clist_row_select_sighandler,
                                             GtkSignalFunc clist_row_unselect_sighandler,                                             
                                             gpointer user_data);

void display_selection_window_results (GtkWidget *widget, gint rc, gchar *error_msg, gchar *success_msg);

inline void set_main_window_id (GtkWidget *widget);

inline GtkWidget* get_main_window_id (void);

inline void set_status_bar_id (GtkWidget *widget);

inline GtkWidget* get_status_bar_id (void);

inline void set_status_bar_message (const gchar *message);

inline void remove_status_bar_message (void);

gpointer get_single_select_current_row_data (GtkCList *clist);

GSList* get_clist_selection_data (GtkCList *clist);

void on_clist_realize_add_single_selection (GtkCList *clist, gpointer user_data);

void on_button_clicked_display_prev_window (GtkButton *button, gpointer user_data);

void on_button_clicked_destroy_window_list (GtkButton *button, gpointer user_data);

void on_version_label_realize (GtkWidget *widget, gpointer user_data);

void on_readonly_clist_select_row (GtkCList *clist, gint row, gint column,
                                   GdkEventButton *event, gpointer user_data);
                                   
inline void destroy_slist (GSList *list);                                   

gboolean update_statusbar_message (GtkWidget *widget, GdkEventCrossing *event,
                                   gpointer user_data);
                                            
gboolean on_menu_item_focus_event (GtkWidget *widget,
                                   GdkEventFocus *event,
                                   gpointer user_data);
                                   
void set_selection_window_clist_column_titles (GtkCList *clist, gchar *size_col_text, 
                                               gchar *desc_col_text, gchar *minmax_col_text);                                   
#endif
