/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: readable.h
 */ 
 
inline gchar* make_data_type_readable_string (data_type_t type);
 
inline gchar* make_unit_readable_string (value_unit_t unit, gboolean use_short_form);

inline gchar* make_sectors_readable_size_string (u_int64_t size_in_sectors, value_unit_t *unit);

inline gchar* make_size_readable_string (gchar *size_string, value_unit_t unit);

inline gchar* make_sectors_readable_string (u_int64_t size_in_sectors);

inline gchar* make_kbytes_readable_string (u_int64_t size_in_bytes);

inline void get_object_and_plugin_names (object_handle_t handle, gchar **object_name, gchar **plugin_name);

inline gchar *get_object_name (object_handle_t handle);

inline gchar* make_object_type_readable_string (object_type_t type);

inline gchar* get_volume_fsim_name (logical_volume_info_t *volume);
