/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_dlist.h
 */ 

#ifndef _LVM_DLIST_H_
#define _LVM_DLIST_H_ 1

// Functions exported from lvm_dlist.c
extern int lvm_append_segment_to_container(storage_object_t	* new_segment,
					storage_container_t	* container );
extern int lvm_append_region_to_container(storage_object_t	* new_region,
					storage_container_t	* container );
extern int lvm_remove_segment_from_container( storage_object_t * segment);
extern int lvm_remove_region_from_container( storage_object_t * region );
extern int lvm_append_region_to_segment(storage_object_t	* region,
					storage_object_t	* segment );
extern int lvm_remove_region_from_segment(storage_object_t	* region,
					storage_object_t	* segment );
extern int lvm_clear_child_list( storage_object_t * region );
extern int lvm_add_object_to_list(	storage_object_t	* object,
					dlist_t			list );
extern int lvm_add_group_to_list( lvm_volume_group_t * group );
extern void * lvm_get_list_item( dlist_t list );

#endif

