/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: drivelink.h
 *
 */

#ifndef DRIVELINK_HEADER
#define DRIVELINK_HEADER

extern plugin_record_t              *DL_PluginRecord_Ptr;          // our feature plugin record ptr
extern struct engine_functions_s    *DLEngFncs;                   // engine function table ptr



// these logging macros expect args ....
#define LOG_WARNING(args...) DLEngFncs->write_log_entry(WARNING,DL_PluginRecord_Ptr, ##args)
#define LOG_INFO(args...)    DLEngFncs->write_log_entry(INFO,DL_PluginRecord_Ptr, ##args)
#define LOG_ERROR(args...)   DLEngFncs->write_log_entry(ERROR,DL_PluginRecord_Ptr, ##args)
#define LOG_DEBUG(args...)   DLEngFncs->write_log_entry(DEBUG,DL_PluginRecord_Ptr, ##args)
#define LOGENTRY()           DLEngFncs->write_log_entry(ENTRY_EXIT,DL_PluginRecord_Ptr,"%s: entry\n",__FUNCTION__ )
#define LOGEXIT()            DLEngFncs->write_log_entry(ENTRY_EXIT,DL_PluginRecord_Ptr,"%s: exit\n",__FUNCTION__ )
#define LOGEXITRC()          DLEngFncs->write_log_entry(ENTRY_EXIT,DL_PluginRecord_Ptr,"%s: exit, RC= %d\n",__FUNCTION__ ,rc)

// macros to read/write sectors
#define READ(object, start, len, buffer)  ((struct plugin_functions_s *)(object->plugin->functions.plugin))->read(object, start, len, buffer)
#define WRITE(object, start, len, buffer) ((struct plugin_functions_s *)(object->plugin->functions.plugin))->write(object, start, len, buffer)

// used by option APIs to set string fields
#define SET_STRING_FIELD(a,b)\
a = DLEngFncs->engine_alloc( strlen(b)+1 );\
if (a ) {\
    strcpy(a, b);\
}\
else {\
    LOG_DEBUG("RC= ENOMEM\n" );\
    LOGEXIT();\
    return ENOMEM;\
}

#define POPUP_MSG(answer,choices,args...) DLEngFncs->user_message(DL_PluginRecord_Ptr,answer,choices, ##args)


#define DRIVELINK_METADATA_SECTOR_COUNT  (sizeof(evms_drivelink_metadata_t)/EVMS_VSECTOR_SIZE)
#define FEATURE_HEADER_SECTOR_COUNT   (sizeof(evms_feature_header_t )/EVMS_VSECTOR_SIZE)


typedef storage_object_t  LOGICALDISK;



#define DL_FLAG_MISSING  0x00000001

typedef struct  {
    u_int64_t         start_lsn;                                 // starting sector number of link
    u_int64_t         end_lsn;                                   // last sector lsn in this object
    u_int64_t         sector_count;                              // total useable sectors in this link
    u_int32_t         padding;                                   // padding at end of useable area
    u_int32_t         serial_number;                             // serial number of this link
    u_int32_t         sequence_number;                           // its index in ordering_table[]
    u_int32_t         flags;                                     // link flags
    storage_object_t  *object;                                   // evms child storage object
} drive_link_t;



#define MISSING_CHILD_SIGNATURE 0x0D0E0A0D

typedef struct  {
    u_int32_t         signature;                                 // for verifying private data
    u_int32_t         parent_serial_number;                      // SN of parent object
    u_int32_t         fh_sequence_number;                        // sequence number from feature header
    u_int32_t         drive_links_found;                         // # of children found so far
    u_int32_t         drive_link_count;                          // total # of children in drive link
    u_int32_t         flags;                                     // drive link flags
    drive_link_t      drive_link[EVMS_DRIVELINK_MAX_ENTRIES];    // drive link table
    evms_dl_ordering_table_entry_t  ordering_table[EVMS_DRIVELINK_MAX_ENTRIES];  // metadata ordering table
} Drive_Link_Private_Data;                                       // position in vector determines childs
                                                                 // sequence in the drive link

#define SAVED_METADATA_SIGNATURE  0x4452564C   // DRVL
typedef struct temp_space_data_s {
    u_int32_t                         signature;                 // used to validate private data area
    storage_object_t                 *object;                    // search key, address of object
    void                             *metadata;                  // ptr to data
 } SAVED_METADATA;


typedef struct psn_s {
    storage_object_t                 *object;                    // search key, address of parent object
    u_int32_t                         serial_number;             // serial number of this drive link parent
    struct psn_s                     *next;
    struct psn_s                     *prev;
} PSN;


// get child list parm block, used by CREATE API
typedef struct get_list_parm_block_s {
    dlist_t           child_object_list;
    u_int32_t         max_count;
} Get_List_Parms;



int                   create_saved_metadata( storage_object_t  *obj );
SAVED_METADATA *      get_saved_metadata( storage_object_t *obj );
int                   delete_saved_metadata( storage_object_t *obj );
int                   get_metadata( storage_object_t *object, evms_drivelink_metadata_t * *metadata );

storage_object_t *    get_first_object_in_list( dlist_t list );

storage_object_t *    get_last_drivelink_child( storage_object_t *object );

storage_object_t *    get_parent( storage_object_t  *object );

int                   get_drivelink_index_by_sn( evms_dl_ordering_table_entry_t *table,
                                                 u_int32_t                       serial_number,
                                                 int                             count);

BOOLEAN               isa_RDONLY_drivelink( storage_object_t *object );
void                  test_and_set_RDONLY_flag( storage_object_t *object );

int                   PluginInit( plugin_record_t *pPlugRec );

void                  PluginCleanup( plugin_record_t *pPlugRec);



#endif
