/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: dloptions.h
 *
 */

#ifndef   DL_OPTIONS_HEADER
#define   DL_OPTIONS_HEADER 1


//
// Create Option Info
//
#define DL_CREATE_OPTION_COUNT           1

#define DL_CREATE_LINKNAME_INDEX         0
#define DL_CREATE_LINKNAME_NAME          "Name"


//
// Expand Option Info
//
#define DL_EXPAND_OPTION_COUNT           0



//
//   Shrink Option Info
//
#define DL_SHRINK_OPTION_COUNT           0

                                         
// 
//  DL Info
//
#define DL_INFO_COUNT                    4

#define DL_INFO_NAME_INDEX               0
#define DL_INFO_SIZE_INDEX               1
#define DL_INFO_LINKS_INDEX              2
#define DL_INFO_PSN_INDEX                3
                    
          
// 
//  Plugin Info
//
#define DL_PLUGIN_INFO_COUNT             5

#define DL_PLUGIN_INFO_SNAME_INDEX       0
#define DL_PLUGIN_INFO_LNAME_INDEX       1
#define DL_PLUGIN_INFO_TYPE_INDEX        2
#define DL_PLUGIN_INFO_VERSION_INDEX     3
#define DL_PLUGIN_INFO_REQVERSION_INDEX  4


int         DL_GetOptionCount(task_context_t * task);

int         DL_InitTask(task_context_t * context);

int         DL_SetOption( task_context_t * context, u_int32_t index, value_t * value, u_int32_t * info );

int         DL_GetInfo( storage_object_t  * object, char *name,  extended_info_array_t * * info);

int         DL_GetPluginInfo( char * descriptor_name, extended_info_array_t * * info );

int         DL_SetObjects( task_context_t * context,
                            dlist_t          declined_objects,
                            task_effect_t  * effect );

#endif

