/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: checks.h
 *
 */

#ifndef CHECKS_HEADER
#define CHECKS_HEADER 1

BOOLEAN     isa_data_partition_record(struct partition *p);
BOOLEAN     isa_linux_raid_partition_record(struct partition *p);
BOOLEAN     isa_zero_length_partition_record(struct partition *p);
BOOLEAN     isa_null_partition_record(struct partition *p);
BOOLEAN     isa_ebr_partition_record(struct partition *p);
BOOLEAN     ptable_has_data_partition_record( Master_Boot_Record *mbr );
BOOLEAN     isa_mbr_partition_record(struct partition *p);
BOOLEAN     ptable_has_partition_records( LOGICALDISK *ld, Master_Boot_Record *mbr );
BOOLEAN     isa_linux_swap_partition_record(LOGICALDISK *ld, struct partition *p, lba_t extd_partition_offset);
BOOLEAN     has_guid_partition_table( Master_Boot_Record *mbr );
BOOLEAN     has_msdos_signature( Master_Boot_Record *mbr );
int         isa_valid_partition_table_chain( LOGICALDISK        *ld,
                                             Master_Boot_Record *mbr,
                                             lba_t               mbr_lba,
                                             lba_t               extd_partition_lba,
                                             BOOLEAN             ebr_chaining,
                                             int                 logical_count,
                                             BOOLEAN             final_call );

BOOLEAN     partition_record_uses_lba_addressing( LOGICALDISK *ld, struct partition *part );
BOOLEAN     disk_uses_lba_addressing( LOGICALDISK *ld );

#endif

