/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: common.h
 *
 */

/*
 * Global functions exported by common.c
 */

/* External APIs provided by common.c */

extern int evms_can_remove(object_handle_t thing);

extern int evms_can_destroy(object_handle_t thing);

extern int evms_can_move(object_handle_t source,
                         object_handle_t target);

extern int evms_can_set_info(engine_handle_t thing_handle);

extern int evms_remove(object_handle_t thing);

extern int evms_destroy(object_handle_t thing);

extern int evms_move(object_handle_t  source,
                     object_handle_t  target);

extern int evms_get_handle_object_type(object_handle_t handle,
                                       object_type_t * type);

extern int evms_get_info(object_handle_t          thing,
                         handle_object_info_t * * info);

extern int evms_get_extended_info(object_handle_t           thing,
                                  char                    * descriptor_name,
                                  extended_info_array_t * * info);

extern int evms_set_info(engine_handle_t  thing_handle,
                         option_array_t * options);

extern int evms_get_object_list(object_type_t         object_type,
                                data_type_t           data_type,
                                plugin_handle_t       plugin,
                                object_search_flags_t flags,
                                handle_array_t    * * objects);

extern int evms_get_feature_list(object_handle_t    object,
                                 handle_array_t * * plugins);

extern int evms_get_object_handle_for_name(object_type_t   type,
                                           char          * name,
                                           object_handle_t * object_handle);

extern int evms_direct_plugin_communication(plugin_handle_t plugin,
                                            object_handle_t thing,
                                            BOOLEAN         target_kernel_plugin,
                                            void          * arg);

/* Internal functions to share with other Engine source modules */

extern BOOLEAN is_top_object(storage_object_t * object);

extern int set_feature_header_dirty(ADDRESS object,
                                    TAG     object_tag,
                                    uint    object_size,
                                    ADDRESS object_handle,
                                    ADDRESS parameters);

extern int sync_compatibility_volume_names(void);

extern int make_dlist(handle_array_t * ha,
                      dlist_t          list);

extern int make_handle_array(dlist_t            list,
                             handle_array_t * * ha);
