#ifndef ARCHIVER_CONTENTS_H
#define ARCHIVER_CONTENTS_H

#include <sys/stat.h>
#include <gtk/gtk.h>
#include "edv_archive_obj.h"
#include "archiver.h"


/* Finding */
extern gint EDVArchiverContentsFindRowByPath(
	edv_archiver_struct *archiver, const gchar *path
);

/* Realize Listing */
extern void EDVArchiverContentsRealizeListing(edv_archiver_struct *archiver);

/* Get Listing */
extern const gchar *EDVArchiverContentsGetError(edv_archiver_struct *archiver);
extern void EDVArchiverContentsGetListing(
	edv_archiver_struct *archiver,
	const gboolean update_status_bar
);
extern void EDVArchiverContentsClear(edv_archiver_struct *archiver);

/* Object Callbacks */
extern void EDVArchiverContentsObjectAddedNotify(
	edv_archiver_struct *archiver, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVArchiverContentsObjectModifiedNotify(
	edv_archiver_struct *archiver, const gchar *path,
	const gchar *new_path, const struct stat *lstat_buf
);
extern void EDVArchiverContentsObjectRemovedNotify(
	edv_archiver_struct *archiver, const gchar *path
);

/* Archive Object Callbacks */
extern void EDVArchiverContentsArchiveObjectAddedNotify(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, edv_archive_object_struct *obj
);
extern void EDVArchiverContentsArchiveObjectModifiedNotify(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path, const gchar *new_path,
	edv_archive_object_struct *obj
);
extern void EDVArchiverContentsArchiveObjectRemovedNotify(
	edv_archiver_struct *archiver, const gchar *arch_path,
	const gchar *path
);


#endif	/* ARCHIVER_CONTENTS_H */
