/*
			       Tool Bar
 */

#ifndef TOOLBAR_H
#define TOOLBAR_H

#include <gtk/gtk.h>


typedef struct _toolbar_struct		toolbar_struct;
typedef struct _toolbar_item_struct	toolbar_item_struct;


/*
 *	Tool Bar Item Types:
 */
typedef enum {
	TOOLBAR_ITEM_SEPARATOR			= 0,
	TOOLBAR_ITEM_BUTTON			= 1,
	TOOLBAR_ITEM_TOGGLE_BUTTON		= 2,
	TOOLBAR_ITEM_MENU_BUTTON		= 3
} toolbar_item_type;

/*
 *	Tool Bar Display:
 */
typedef enum {
	TOOLBAR_DISPLAY_TEXT,
	TOOLBAR_DISPLAY_PICTURES,
	TOOLBAR_DISPLAY_PICTURES_AND_TEXT
} toolbar_display;

/*
 *	Tool Bar Relief:
 */
typedef enum {
	TOOLBAR_RELIEF_NORMAL,
	TOOLBAR_RELIEF_HALF,
	TOOLBAR_RELIEF_NONE
} toolbar_relief;


/*
 *	Tool Bar Item:
 */
struct _toolbar_item_struct {

	toolbar_item_type	type;

	toolbar_struct	*toolbar;

	GtkWidget	*w;		/* Toplevel GtkWidget */

	gchar		*text;		/* Item label text */
	guint8		**icon_data;	/* Item icon data (shared) */
	gchar		*tooltip;	/* Tooltip message */

	/* Arbitary client set operation id code */
	gint		id;

	/* Function callbacks, sole argument is the respective
	 * client_data
	 */

	/* "clicked" or "toggled" callback */
	void	(*func_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* Data */
	);
	gpointer	client_data;

	/* "enter_notify_event" and "leave_notify_event" callbacks */
	void	(*enter_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* Data */
	);
	gpointer	enter_client_data;
	void	(*leave_cb)(
		toolbar_item_struct *,	/* Tool Bar Item */
		gint,			/* ID */
		gpointer		/* Data */
	);
	gpointer	leave_client_data;

};
#define TOOLBAR_ITEM(p)	((toolbar_item_struct *)(p))

/*
 *	Tool Bar:
 */
struct _toolbar_struct {

	GtkWidget	*toplevel;	/* GtkBox */

	toolbar_display	display;
	toolbar_relief	relief;
	gboolean	vertical;

	toolbar_item_struct	**item;
	gint			total_items;

};
#define TOOLBAR(p)	((toolbar_struct *)(p))


/* Tool Bar Item List */
extern toolbar_item_struct *ToolBarItemNew(
	toolbar_item_type type,		/* One of TOOLBAR_ITEM_* */
	const gchar *text,		/* Label text */
	guint8 **icon_data,		/* Icon data (shared) */
	const gchar *tooltip,		/* Tooltip message */
	gint id,			/* ID */
	void (*func_cb)(toolbar_item_struct *, gint, gpointer),
	gpointer client_data,
	void (*enter_cb)(toolbar_item_struct *, gint, gpointer),
	gpointer enter_client_data,
	void (*leave_cb)(toolbar_item_struct *, gint, gpointer),
	gpointer leave_client_data
);
extern void ToolBarItemDelete(toolbar_item_struct *item);

extern void ToolBarItemListAppend(
	toolbar_item_struct ***item, gint *total_items,
	toolbar_item_struct *item_ptr
);
extern void ToolBarItemListDeleteAll(
	toolbar_item_struct ***item, gint *total_items
);

extern toolbar_item_struct *ToolBarItemListMatchByID(
	toolbar_item_struct **item, gint total_items,
	gint id
);


/* Tool Bar */
extern toolbar_struct *ToolBarNew(
	toolbar_item_struct **item, gint total_items,
	GtkWidget *parent,
	toolbar_display display,
	toolbar_relief relief,
	gboolean vertical
);
extern void ToolBarSetDisplay(
	toolbar_struct *tb, toolbar_display display
);
extern void ToolBarSetRelief(
	toolbar_struct *tb, toolbar_relief relief
);
extern void ToolBarItemUpdateByID(
	toolbar_struct *tb, gint id,
	const gchar *text,
	guint8 **icon_data,
	const gchar *tooltip
);
extern void ToolBarMap(toolbar_struct *tb);
extern void ToolBarUnmap(toolbar_struct *tb);
extern void ToolBarDelete(toolbar_struct *tb);


/* Tool Bar Item */
extern GtkWidget *ToolBarItemGetWidgetID(toolbar_struct *tb, gint id);

extern void ToolBarItemSetSensitiveID(
	toolbar_struct *tb, gint id, gboolean sensitive
);

extern void ToolBarItemSetToggleID(
	toolbar_struct *tb, gint id, gboolean toggled
);
extern gboolean ToolBarItemGetToggleID(toolbar_struct *tb, gint id);

extern void ToolBarItemSetMenuID(
	toolbar_struct *tb, gint id, GtkWidget *menu
);
extern GtkWidget *ToolBarItemGetMenuID(toolbar_struct *tb, gint id);

extern gboolean ToolBarItemIsMappedID(toolbar_struct *tb, gint id);
extern void ToolBarItemMapID(toolbar_struct *tb, gint id);
extern void ToolBarItemUnmapID(toolbar_struct *tb, gint id);


#endif	/* TOOLBAR_H */

