-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkToolbar objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_toolbar_writer.e,v 1.14 2000/09/15 09:44:35 dan Exp $"

class GTK_TOOLBAR_WRITER

inherit

	GTK_COMPOSED_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_declaration, append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_TOOLBAR"
	tree_array: ARRAY[TAG_TREE]
	writer_array: CAN_BE_CREATED
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		local
			i: INTEGER
		do
			make_attribute(attr_name, tree, src)
			orientation := widget_tree.get_string_from_field("orientation")
			bar_type := widget_tree.get_string_from_field("type")
			space_size := widget_tree.get_string_from_field("space_size")
			relief := widget_tree.get_string_from_field("relief")
			tooltips := widget_tree.get_boolean_from_field("tooltips", True)
			tree_array := widget_tree.find_children("widget")
			!!widgets.make(0, tree_array.count - 1)
			from
				i := 0
			until
				i >= tree_array.count
			loop
				if (tree_array @ i).get_string_from_field("child_name").is_equal("Toolbar:button") then
					-- leave void
				else
					create_child_class(tree_array @ i, 1)
					widgets.put(last_class, i)
				end
				i := i + 1
			end
			
		end
			
	orientation: STRING
	bar_type: STRING
	space_size: STRING
	relief: STRING
	tooltips: BOOLEAN

	append_parent_declaration(code: ARRAY[STRING]) is
        local
            i: INTEGER
			icon: STRING
        do
            code.add_last(name+": "+type)
            from
                i := 0
            until
                i >= widgets.count
            loop
				if (widgets @ i) /= Void then
					(widgets @ i).append_parent_declaration(code)
				else
					icon := clone((tree_array @ i).get_string_from_field("icon"))
					if icon.is_empty then
						print("Can't have an empty icon in a toolbar button. Sorry.%N")
						die_with_code(exit_failure_code)
					end
					icon.replace_all('.', '_')
					code.add_last(icon + ": GTK_PIXMAP")
				end
                i := i + 1
            end
			append_signal_declarations(code)
        end
	
	parent_inherit: INHERIT_LIST is
		local
			i: INTEGER
		do
			!!Result.make
			from
				i := widgets.lower
			until
				i > widgets.upper
			loop
				if widgets @ i /= Void then
					Result.merge_with((widgets @ i).parent_inherit)
				end
				i := i + 1
			end
		end

	append_parent_creation(code: ARRAY[STRING]) is
        local
            i: INTEGER
            temp_child: CHILD
			icon, icon_feature: STRING
			temp_tree: TAG_TREE
        do
            code.add_last("!!" + name + ".make("+orientation+", "+bar_type+")")
			code.add_last(name + ".set_space_size("+ space_size + ")")
			if not tooltips then
				code.add_last(name + ".disable_tooltips")
			end
			add_widget_code(code)
            from
                i := 0
            until
                i >= widgets.count
            loop
				if widgets @ i /= Void then
					(widgets @ i).append_parent_creation(code)
					temp_child ?= widgets @ i
					if temp_child.flag("new_group", False) then
						code.add_last(name + ".append_space")
					end
					code.add_last(name + ".append_widget(" +
						(widgets @ i).name + ", " + "%"%", %"%")")
				else
					icon := (tree_array @ i).get_string_from_field("icon")
					-- POSSIBLE NAME OVERLAP
					icon_feature := clone(icon)
					icon_feature.replace_all('.', '_') 
					code.add_last("!!" + icon_feature + ".make_from_xpm(Current, %"" + icon + "%")")
					temp_tree := (tree_array @ i).find_child("child") 
					if temp_tree /= Void then
						if temp_tree.get_boolean_from_field("new_group", False) then
							code.add_last(name + ".append_space")
						end
					end
					code.add_last(name + ".append_item(%"" +
						(tree_array @ i).get_string_from_field("label") +
						"%", %"" +
						(tree_array @ i).get_string_from_field("tooltip") +
						"%", %"%", " + icon_feature + ", Void)")
						-- Must have an icon, because eGTK requires icon/=Void
						-- Can't give a GTK_COMMAND yet!
				end
                i := i + 1
            end
        end

end
