-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkMenu top-level objects"
	author: "Oliver Elphick <olly@lfix.co.uk>"
	cvs: "$Id: gtk_popup_menu_writer.e,v 1.1 2000/08/31 14:02:17 elphick Exp $"

class GTK_POPUP_MENU_WRITER

inherit

	GTK_MENU_WRITER
		rename
			make as make_menu
		select
			parent_inherit
		end

	GTK_CLASS_WRITER
		rename
			make as make_class
		undefine
			parent_inherit
		redefine
			append_top_level_definition
		end

creation

	make

feature
	
	child_widget: CAN_BE_CREATED

	inherit_from: STRING is "GTK_MENU%N%T%Tredefine%N%T%T%Tmake%N%T%Tend"

	make(tree: TAG_TREE; info: CLASS_INFO; src: STRING) is
		local
			i: INTEGER
		do
			make_class(tree, info, src)
			name := clone(classname)
			name.to_lower
			name.prepend("instance_")
			events := tree.get_string_from_field("events")
			extension_events := tree.get_string_from_field("extension_events")
			-- TODO: write the events out
			make_signals(tree.find_children("signal"))
			create_child_class_array(widget_tree.find_children("widget"), 1)
			from
				i := 0
			until
				i >= last_class_array.count
			loop
				if (last_class_array @ i) /= Void then
					inherit_list.merge_with((last_class_array @ i).parent_inherit)
				end
				i := i + 1
			end
		end

	append_top_level_definition(code: ARRAY[STRING]) is
		do
			code.add_last(name + ": " + classname + " is")
			code.add_last("%Tonce")
			code.add_last("%T%T!!Result.make")
			code.add_last("%Tend%N")
		end

	write_features is
		local
			code: ARRAY[STRING]
			i: INTEGER
		do
			!!code.make(0,-1)
			from
				i := 0
			until
				i >= last_class_array.count
			loop
				if (last_class_array @ i) /= Void then
					code.clear;
					(last_class_array @ i).append_parent_declaration(code)
					write_lines(code)
				end
				i := i + 1
			end
		end

	write_make_body is
		local
			code: ARRAY[STRING]
			i: INTEGER
		do
			!!code.make(0,-1)
			append_signal_declarations(code)
			write_lines(code)
			write_line("make is")
			indent
			write_line("do")
			indent
			write_line("Precursor")
			code.clear
			append_signal_code(code, "Current")
			write_lines(code)
			code.clear
			from
				i := 0
			until
				i >= last_class_array.count
			loop
				if (last_class_array @ i) /= Void then
					(last_class_array @ i).append_parent_creation(code)
				end
				i := i + 1
			end
			write_lines(code)
			outdent
			write_line("end")
			outdent
		end

end -- GTK_POPUP_MENU_WRITER
