-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkHandleBox objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_handle_box_writer.e,v 1.9 2000/08/31 14:02:17 elphick Exp $"

class GTK_HANDLE_BOX_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_HANDLE_BOX"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		require
			non_void_tree: tree /= Void
			valid_name: attr_name /= Void and then not attr_name.is_empty
		do
			make_attribute(attr_name, tree, src)
			shadow_type := widget_tree.get_string_from_field("shadow_type")
			handle_position := widget_tree.get_string_from_field("handle_position")
			snap_edge := widget_tree.get_string_from_field("snap_edge")
			create_child_class(widget_tree.find_child("widget"), 1)
		end
			
	shadow_type: STRING
	handle_position: STRING
	snap_edge: STRING

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			Result := precursor
			!!temp.make_with_name("GTK_SHADOWTYPE_ENUM")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
			-- clashes with GTK_CONSTANTS
			--!!temp.make_with_name("GTK_POSITIONTYPE_ENUM")
			--Result.add(temp)
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_shadow_type(" + shadow_type + ")")
			code.add_last(name + ".set_handle_position(" + handle_position + ")")
			code.add_last(name + ".set_snap_edge(" + snap_edge + ")")
			add_widget_code(code)
			precursor(code)
		end
end
