-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

   description: "Writes source files for GtkCList objects"
   author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
   cvs: "$Id: gtk_clist_writer.e,v 1.12 2002/02/26 07:31:44 elphick Exp $"

class GTK_CLIST_WRITER

inherit

   GTK_ATTRIBUTE_WRITER
      rename
	 make as make_attribute
      redefine
	 append_parent_creation, parent_inherit
      end

   CHILD

creation

   make

feature

   type:STRING is "GTK_CLIST"
	
   tree_array: ARRAY[TAG_TREE]

   make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
      local
      do
	 make_attribute(attr_name, tree, src)
	 columns := widget_tree.get_integer_string_from_field("columns")
	 column_widths := widget_tree.get_string_from_field("column_widths")
	 selection_mode := widget_tree.get_string_from_field("selection_mode")
	 show_titles := widget_tree.get_boolean_from_field("show_titles", True)
	 shadow_type := widget_tree.get_string_from_field("shadow_type")
	 tree_array := widget_tree.find_children("widget")
	 self_scrolling := True
      end
			
   columns: STRING
   column_widths: STRING
   selection_mode: STRING
   show_titles: BOOLEAN
   shadow_type: STRING

   append_parent_creation(code: ARRAY[STRING]) is
      local
	 titles: STRING
	 i, start, finish: INTEGER
      do
	 !!titles.make(0)
	 from
	    i := 0
	 until
	    i >= tree_array.count
	 loop
	    titles.append("%""+eiffel_string((tree_array @ i).get_string_from_field("label"))+"%"")
	    i := i + 1
	    if i < tree_array.count then
	       titles.append(", ")
	    end
	 end
	 code.add_last("!!" + name + ".make_with_titles(<<"+titles+">>)")
	 code.add_last(name + ".set_selection_mode(" + selection_mode + ")")
	 if show_titles then
	    code.add_last(name + ".show_column_titles")
	 else
	    code.add_last(name + ".hide_column_titles")
	 end
	 code.add_last(name + ".set_shadow_type(" + shadow_type + ")")
	 from
	    i := 0; start := 1
	 invariant
	    i >= tree_array.count - 1 or else start < column_widths.count
	 until
	    i >= tree_array.count
	 loop
	    finish := column_widths.substring_index(",", start)
	    if finish = 0 then
	       finish := column_widths.count + 1
	    end
	    check
	       finish > start
	    end
	    -- if there is no comma then finish = count + 1
	    -- which means that the substring won't go out-
	    -- side the bounds of the string
	    code.add_last(name + ".set_column_pixel_width(" + i.to_string + ", " + column_widths.substring(start, finish - 1) + ")")
	    start := finish + 1
	    i := i + 1
	 end
	 add_widget_code(code)
      end

   parent_inherit: INHERIT_LIST is
      local
	 temp: KLASS
      do
	 !!Result.make
	 !!temp.make_with_name("GTK_SHADOWTYPE_ENUM")
	 temp.add_undefine_clause("is_equal, copy")
	 Result.add(temp)
	 !!temp.make_with_name("GTK_SELECTIONMODE_ENUM")
	 temp.add_undefine_clause("is_equal, copy")
	 Result.add(temp)
      end
end
