-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description:	"This is the base class for eglade."
	author:			"Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: base.e,v 1.9 2001/11/04 02:56:57 richieb Exp $"

class BASE

inherit

	GLOBALS

	ARGUMENTS

creation
	make

feature

	make is
		local
			parser: XML_PARSER
			tree: TAG_TREE
			gen: CODE_GENERATOR
			input: TEXT_FILE_READ
		do
			if argument_count /= 1 then
				print("usage: " + command_name +" <project>%N")
				die_with_code(exit_failure_code)
			end
			if argument(1).is_equal("-") then
				!!parser.make(std_input)
				parser.parse
			else
				if file_tools.is_readable(argument(1)) then
					!!input.connect_to(argument(1))
					!!parser.make(input)
					parser.parse
					input.disconnect
				else
					print("File " + argument(1) + " does not exist.%N")
					die_with_code(exit_failure_code)
				end
			end
			tree := parser.tree
			if not parser.syntax_error then
				if not (tree @ 0).is_equal("xml version=%"1.0%"") then
					print("XML version 1.0 expected.%N")
					print("Aborting.%N")
					die_with_code(exit_failure_code)
				else
					-- So far so good. Now to generate the code!
					print("File uses XML version 1.0.%N")
					set_project_file(argument(1))
					!!gen.make(tree, dirname(argument(1)))
				end
			else
				-- Should already have printed parse error
				die_with_code(exit_failure_code)
			end
		end

	dirname (path: STRING): STRING is
			-- extract the directory name from a path
	 -- (This really ought to be in a standard library)
		require
			non_void: path /= Void
		local
			s: STRING
			i: INTEGER
			found: BOOLEAN
		do
			!!s.make(0)
			if not path.is_empty
			then
				s := clone(path)
				from
					i := s.count
				invariant
					i >= 0 and i <= s.count
				variant
					i + 1
				until
					found or (i = 0)
				loop
					if (s @ i) = '/'
					then
						found := True
					end
					i := i - 1
				end
				if i > 0
				then
					s.shrink(1,i)
				else
					s.make(0)
				end
			end
			Result := s
		ensure
			result_set: Result /= Void
		end
end
