cdef extern from "dbus_h_wrapper.h":
    ctypedef enum DBusBusType:
        DBUS_BUS_SESSION
        DBUS_BUS_SYSTEM
        DBUS_BUS_STARTER

    ctypedef enum DBusHandlerResult:
        DBUS_HANDLER_RESULT_HANDLED
        DBUS_HANDLER_RESULT_NOT_YET_HANDLED
        DBUS_HANDLER_RESULT_NEED_MEMORY

    ctypedef enum DBusWatchFlags:
        DBUS_WATCH_READABLE
        DBUS_WATCH_WRITABLE
        DBUS_WATCH_ERROR
        DBUS_WATCH_HANGUP

    ctypedef enum DBusDispatchStatus:
        DBUS_DISPATCH_DATA_REMAINS
        DBUS_DISPATCH_COMPLETE
        DBUS_DISPATCH_NEED_MEMORY

    ctypedef enum DBusThreadFunctionsMask:
        DBUS_THREAD_FUNCTIONS_MUTEX_NEW_MASK
        DBUS_THREAD_FUNCTIONS_MUTEX_FREE_MASK
        DBUS_THREAD_FUNCTIONS_MUTEX_LOCK_MASK
        DBUS_THREAD_FUNCTIONS_MUTEX_UNLOCK_MASK
        DBUS_THREAD_FUNCTIONS_CONDVAR_NEW_MASK
        DBUS_THREAD_FUNCTIONS_CONDVAR_FREE_MASK
        DBUS_THREAD_FUNCTIONS_CONDVAR_WAIT_MASK
        DBUS_THREAD_FUNCTIONS_CONDVAR_WAIT_TIMEOUT_MASK
        DBUS_THREAD_FUNCTIONS_CONDVAR_WAKE_ONE_MASK
        DBUS_THREAD_FUNCTIONS_CONDVAR_WAKE_ALL_MASK
        DBUS_THREAD_FUNCTIONS_ALL_MASK

    ctypedef long long dbus_int64_t
    ctypedef unsigned long long dbus_uint64_t
    ctypedef int dbus_int32_t
    ctypedef unsigned int dbus_uint32_t
    ctypedef short dbus_int16_t
    ctypedef unsigned short dbus_uint16_t
    ctypedef int ptrdiff_t
    ctypedef unsigned int size_t
    ctypedef long int wchar_t
    ctypedef dbus_uint32_t dbus_unichar_t
    ctypedef dbus_uint32_t dbus_bool_t
    ctypedef struct DBusError
    ctypedef struct DBusAddressEntry
    ctypedef void (* DBusFreeFunction) (void *memory)
    ctypedef struct DBusMessage
    ctypedef struct DBusMessageIter
    ctypedef struct DBusWatch
    ctypedef struct DBusTimeout
    ctypedef struct DBusPreallocatedSend
    ctypedef struct DBusPendingCall
    ctypedef struct DBusConnection
    ctypedef struct DBusObjectPathVTable
    ctypedef dbus_bool_t (* DBusAddWatchFunction) (DBusWatch *watch, void *data)
    ctypedef void (* DBusWatchToggledFunction) (DBusWatch *watch, void *data)
    ctypedef void (* DBusRemoveWatchFunction) (DBusWatch *watch, void *data)
    ctypedef dbus_bool_t (* DBusAddTimeoutFunction) (DBusTimeout *timeout, void *data)
    ctypedef void (* DBusTimeoutToggledFunction) (DBusTimeout *timeout, void *data)
    ctypedef void (* DBusRemoveTimeoutFunction) (DBusTimeout *timeout, void *data)
    ctypedef void (* DBusDispatchStatusFunction) (DBusConnection *connection, DBusDispatchStatus new_status, void *data)
    ctypedef void (* DBusWakeupMainFunction) (void *data)
    ctypedef dbus_bool_t (* DBusAllowUnixUserFunction) (DBusConnection *connection, unsigned long uid, void *data)
    ctypedef void (* DBusPendingCallNotifyFunction) (DBusPendingCall *pending, void *user_data)
    ctypedef DBusHandlerResult (* DBusHandleMessageFunction) (DBusConnection *connection, DBusMessage *message, void *user_data)
    ctypedef void (* DBusObjectPathUnregisterFunction) (DBusConnection *connection, void *user_data)
    ctypedef DBusHandlerResult (* DBusObjectPathMessageFunction) (DBusConnection *connection, DBusMessage *message, void *user_data)
    ctypedef struct DBusServer
    ctypedef void (* DBusNewConnectionFunction) (DBusServer *server, DBusConnection *new_connection, void *data)
    ctypedef struct DBusSignatureIter
    ctypedef struct DBusMutex
    ctypedef struct DBusCondVar
    ctypedef DBusMutex 
    ctypedef void (* DBusMutexFreeFunction) (DBusMutex *mutex)
    ctypedef dbus_bool_t (* DBusMutexLockFunction) (DBusMutex *mutex)
    ctypedef dbus_bool_t (* DBusMutexUnlockFunction) (DBusMutex *mutex)
    ctypedef DBusCondVar 
    ctypedef void (* DBusCondVarFreeFunction) (DBusCondVar *cond)
    ctypedef void (* DBusCondVarWaitFunction) (DBusCondVar *cond, DBusMutex *mutex)
    ctypedef dbus_bool_t (* DBusCondVarWaitTimeoutFunction) (DBusCondVar *cond, DBusMutex *mutex, int timeout_milliseconds)
    ctypedef void (* DBusCondVarWakeOneFunction) (DBusCondVar *cond)
    ctypedef void (* DBusCondVarWakeAllFunction) (DBusCondVar *cond)
    ctypedef struct DBusThreadFunctions
    void                 dbus_error_init (DBusError* error)
    void                 dbus_error_free (DBusError* error)
    void                 dbus_set_error_ (DBusError* error, char* name, char* message)
    void                 dbus_move_error (DBusError* src, DBusError* dest)
    dbus_bool_t          dbus_error_has_name (DBusError* error, char* name)
    dbus_bool_t          dbus_error_is_set (DBusError* error)
    dbus_bool_t          dbus_parse_address (char* address, DBusAddressEntry*** entry, int* array_len, DBusError* error)
    char*                dbus_address_entry_get_value (DBusAddressEntry* entry, char* key)
    char*                dbus_address_entry_get_method (DBusAddressEntry* entry)
    void                 dbus_address_entries_free (DBusAddressEntry** entries)
    char*                dbus_address_escape_value (char* value)
    char*                dbus_address_unescape_value (char* value, DBusError* error)
    void*                dbus_malloc (size_t bytes)
    void*                dbus_malloc0 (size_t bytes)
    void*                dbus_realloc (void* memory, size_t bytes)
    void                 dbus_free (void* memory)
    void                 dbus_free_string_array (char** str_array)
    DBusMessage*         dbus_message_new (int message_type)
    DBusMessage*         dbus_message_new_method_call (char* bus_name, char* path, char* interface, char* method)
    DBusMessage*         dbus_message_new_method_return (DBusMessage* method_call)
    DBusMessage*         dbus_message_new_signal (char* path, char* interface, char* name)
    DBusMessage*         dbus_message_new_error (DBusMessage* reply_to, char* error_name, char* error_message)
    DBusMessage*         dbus_message_copy (DBusMessage* message)
    DBusMessage*         dbus_message_ref (DBusMessage* message)
    void                 dbus_message_unref (DBusMessage* message)
    int                  dbus_message_get_type (DBusMessage* message)
    dbus_bool_t          dbus_message_set_path (DBusMessage* message, char* object_path)
    char*                dbus_message_get_path (DBusMessage* message)
    dbus_bool_t          dbus_message_has_path (DBusMessage* message, char* object_path)
    dbus_bool_t          dbus_message_set_interface (DBusMessage* message, char* interface)
    char*                dbus_message_get_interface (DBusMessage* message)
    dbus_bool_t          dbus_message_has_interface (DBusMessage* message, char* interface)
    dbus_bool_t          dbus_message_set_member (DBusMessage* message, char* member)
    char*                dbus_message_get_member (DBusMessage* message)
    dbus_bool_t          dbus_message_has_member (DBusMessage* message, char* member)
    dbus_bool_t          dbus_message_set_error_name (DBusMessage* message, char* name)
    char*                dbus_message_get_error_name (DBusMessage* message)
    dbus_bool_t          dbus_message_set_destination (DBusMessage* message, char* destination)
    char*                dbus_message_get_destination (DBusMessage* message)
    dbus_bool_t          dbus_message_set_sender (DBusMessage* message, char* sender)
    char*                dbus_message_get_sender (DBusMessage* message)
    char*                dbus_message_get_signature (DBusMessage* message)
    void                 dbus_message_set_no_reply (DBusMessage* message, dbus_bool_t no_reply)
    dbus_bool_t          dbus_message_get_no_reply (DBusMessage* message)
    dbus_bool_t          dbus_message_is_method_call (DBusMessage* message, char* interface, char* method)
    dbus_bool_t          dbus_message_is_signal (DBusMessage* message, char* interface, char* signal_name)
    dbus_bool_t          dbus_message_is_error (DBusMessage* message, char* error_name)
    dbus_bool_t          dbus_message_has_destination (DBusMessage* message, char* bus_name)
    dbus_bool_t          dbus_message_has_sender (DBusMessage* message, char* unique_bus_name)
    dbus_bool_t          dbus_message_has_signature (DBusMessage* message, char* signature)
    dbus_uint32_t        dbus_message_get_serial (DBusMessage* message)
    dbus_bool_t          dbus_message_set_reply_serial (DBusMessage* message, dbus_uint32_t reply_serial)
    dbus_uint32_t        dbus_message_get_reply_serial (DBusMessage* message)
    void                 dbus_message_set_auto_start (DBusMessage* message, dbus_bool_t auto_start)
    dbus_bool_t          dbus_message_get_auto_start (DBusMessage* message)
    dbus_bool_t          dbus_message_get_path_decomposed (DBusMessage* message, char*** path)
    dbus_bool_t          dbus_message_iter_init (DBusMessage* message, DBusMessageIter* iter)
    dbus_bool_t          dbus_message_iter_has_next (DBusMessageIter* iter)
    dbus_bool_t          dbus_message_iter_next (DBusMessageIter* iter)
    char*                dbus_message_iter_get_signature (DBusMessageIter* iter)
    int                  dbus_message_iter_get_arg_type (DBusMessageIter* iter)
    int                  dbus_message_iter_get_element_type (DBusMessageIter* iter)
    void                 dbus_message_iter_recurse (DBusMessageIter* iter, DBusMessageIter* sub)
    void                 dbus_message_iter_get_basic (DBusMessageIter* iter, void* value)
    int                  dbus_message_iter_get_array_len (DBusMessageIter* iter)
    void                 dbus_message_iter_get_fixed_array (DBusMessageIter* iter, void* value, int* n_elements)
    void                 dbus_message_iter_init_append (DBusMessage* message, DBusMessageIter* iter)
    dbus_bool_t          dbus_message_iter_append_basic (DBusMessageIter* iter, int type, void* value)
    dbus_bool_t          dbus_message_iter_append_fixed_array (DBusMessageIter* iter, int element_type, void* value, int n_elements)
    dbus_bool_t          dbus_message_iter_open_container (DBusMessageIter* iter, int type, char* contained_signature, DBusMessageIter* sub)
    dbus_bool_t          dbus_message_iter_close_container (DBusMessageIter* iter, DBusMessageIter* sub)
    dbus_bool_t          dbus_set_error_from_message (DBusError* error, DBusMessage* message)
    dbus_bool_t          dbus_message_allocate_data_slot (dbus_int32_t* slot_p)
    void                 dbus_message_free_data_slot (dbus_int32_t* slot_p)
    dbus_bool_t          dbus_message_set_data (DBusMessage* message, dbus_int32_t slot, void* data, DBusFreeFunction free_data_func)
    void*                dbus_message_get_data (DBusMessage* message, dbus_int32_t slot)
    int                  dbus_message_type_from_string (char* type_str)
    char*                dbus_message_type_to_string (int type)
    DBusConnection*      dbus_connection_open (char* address, DBusError* error)
    DBusConnection*      dbus_connection_open_private (char* address, DBusError* error)
    DBusConnection*      dbus_connection_ref (DBusConnection* connection)
    void                 dbus_connection_unref (DBusConnection* connection)
    void                 dbus_connection_close (DBusConnection* connection)
    dbus_bool_t          dbus_connection_get_is_connected (DBusConnection* connection)
    dbus_bool_t          dbus_connection_get_is_authenticated (DBusConnection* connection)
    void                 dbus_connection_set_exit_on_disconnect (DBusConnection* connection, dbus_bool_t exit_on_disconnect)
    void                 dbus_connection_flush (DBusConnection* connection)
    dbus_bool_t          dbus_connection_read_write_dispatch (DBusConnection* connection, int timeout_milliseconds)
    dbus_bool_t          dbus_connection_read_write (DBusConnection* connection, int timeout_milliseconds)
    DBusMessage*         dbus_connection_borrow_message (DBusConnection* connection)
    void                 dbus_connection_return_message (DBusConnection* connection, DBusMessage* message)
    void                 dbus_connection_steal_borrowed_message (DBusConnection* connection, DBusMessage* message)
    DBusMessage*         dbus_connection_pop_message (DBusConnection* connection)
    DBusDispatchStatus   dbus_connection_get_dispatch_status (DBusConnection* connection)
    DBusDispatchStatus   dbus_connection_dispatch (DBusConnection* connection)
    dbus_bool_t          dbus_connection_has_messages_to_send (DBusConnection* connection)
    dbus_bool_t          dbus_connection_send (DBusConnection* connection, DBusMessage* message, dbus_uint32_t* client_serial)
    dbus_bool_t          dbus_connection_send_with_reply (DBusConnection* connection, DBusMessage* message, DBusPendingCall** pending_return, int timeout_milliseconds)
    DBusMessage*         dbus_connection_send_with_reply_and_block (DBusConnection* connection, DBusMessage* message, int timeout_milliseconds, DBusError* error)
    dbus_bool_t          dbus_connection_set_watch_functions (DBusConnection* connection, DBusAddWatchFunction add_function, DBusRemoveWatchFunction remove_function, DBusWatchToggledFunction toggled_function, void* data, DBusFreeFunction free_data_function)
    dbus_bool_t          dbus_connection_set_timeout_functions (DBusConnection* connection, DBusAddTimeoutFunction add_function, DBusRemoveTimeoutFunction remove_function, DBusTimeoutToggledFunction toggled_function, void* data, DBusFreeFunction free_data_function)
    void                 dbus_connection_set_wakeup_main_function (DBusConnection* connection, DBusWakeupMainFunction wakeup_main_function, void* data, DBusFreeFunction free_data_function)
    void                 dbus_connection_set_dispatch_status_function (DBusConnection* connection, DBusDispatchStatusFunction function, void* data, DBusFreeFunction free_data_function)
    dbus_bool_t          dbus_connection_get_unix_user (DBusConnection* connection, unsigned long* uid)
    dbus_bool_t          dbus_connection_get_unix_process_id (DBusConnection* connection, unsigned long* pid)
    void                 dbus_connection_set_unix_user_function (DBusConnection* connection, DBusAllowUnixUserFunction function, void* data, DBusFreeFunction free_data_function)
    int                  dbus_watch_get_fd (DBusWatch* watch)
    unsigned int         dbus_watch_get_flags (DBusWatch* watch)
    void*                dbus_watch_get_data (DBusWatch* watch)
    void                 dbus_watch_set_data (DBusWatch* watch, void* data, DBusFreeFunction free_data_function)
    dbus_bool_t          dbus_watch_handle (DBusWatch* watch, unsigned int flags)
    dbus_bool_t          dbus_watch_get_enabled (DBusWatch* watch)
    int                  dbus_timeout_get_interval (DBusTimeout* timeout)
    void*                dbus_timeout_get_data (DBusTimeout* timeout)
    void                 dbus_timeout_set_data (DBusTimeout* timeout, void* data, DBusFreeFunction free_data_function)
    dbus_bool_t          dbus_timeout_handle (DBusTimeout* timeout)
    dbus_bool_t          dbus_timeout_get_enabled (DBusTimeout* timeout)
    dbus_bool_t          dbus_connection_add_filter (DBusConnection* connection, DBusHandleMessageFunction function, void* user_data, DBusFreeFunction free_data_function)
    void                 dbus_connection_remove_filter (DBusConnection* connection, DBusHandleMessageFunction function, void* user_data)
    dbus_bool_t          dbus_connection_allocate_data_slot (dbus_int32_t* slot_p)
    void                 dbus_connection_free_data_slot (dbus_int32_t* slot_p)
    dbus_bool_t          dbus_connection_set_data (DBusConnection* connection, dbus_int32_t slot, void* data, DBusFreeFunction free_data_func)
    void*                dbus_connection_get_data (DBusConnection* connection, dbus_int32_t slot)
    void                 dbus_connection_set_change_sigpipe (dbus_bool_t will_modify_sigpipe)
    void                 dbus_connection_set_max_message_size (DBusConnection* connection, long size)
    long                 dbus_connection_get_max_message_size (DBusConnection* connection)
    void                 dbus_connection_set_max_received_size (DBusConnection* connection, long size)
    long                 dbus_connection_get_max_received_size (DBusConnection* connection)
    long                 dbus_connection_get_outgoing_size (DBusConnection* connection)
    DBusPreallocatedSend* dbus_connection_preallocate_send (DBusConnection* connection)
    void                 dbus_connection_free_preallocated_send (DBusConnection* connection, DBusPreallocatedSend* preallocated)
    void                 dbus_connection_send_preallocated (DBusConnection* connection, DBusPreallocatedSend* preallocated, DBusMessage* message, dbus_uint32_t* client_serial)
    dbus_bool_t          dbus_connection_register_object_path (DBusConnection* connection, char* path, DBusObjectPathVTable* vtable, void* user_data)
    dbus_bool_t          dbus_connection_register_fallback (DBusConnection* connection, char* path, DBusObjectPathVTable* vtable, void* user_data)
    dbus_bool_t          dbus_connection_unregister_object_path (DBusConnection* connection, char* path)
    dbus_bool_t          dbus_connection_get_object_path_data (DBusConnection* connection, char* path, void** data_p)
    dbus_bool_t          dbus_connection_list_registered (DBusConnection* connection, char* parent_path, char*** child_entries)
    dbus_bool_t          dbus_connection_get_unix_fd (DBusConnection* connection, int* fd)
    DBusConnection*      dbus_bus_get (DBusBusType type, DBusError* error)
    DBusConnection*      dbus_bus_get_private (DBusBusType type, DBusError* error)
    dbus_bool_t          dbus_bus_register (DBusConnection* connection, DBusError* error)
    dbus_bool_t          dbus_bus_set_unique_name (DBusConnection* connection, char* unique_name)
    char*                dbus_bus_get_unique_name (DBusConnection* connection)
    unsigned long        dbus_bus_get_unix_user (DBusConnection* connection, char* name, DBusError* error)
    int                  dbus_bus_request_name (DBusConnection* connection, char* name, unsigned int flags, DBusError* error)
    int                  dbus_bus_release_name (DBusConnection* connection, char* name, DBusError* error)
    dbus_bool_t          dbus_bus_name_has_owner (DBusConnection* connection, char* name, DBusError* error)
    dbus_bool_t          dbus_bus_start_service_by_name (DBusConnection* connection, char* name, dbus_uint32_t flags, dbus_uint32_t* reply, DBusError* error)
    void                 dbus_bus_add_match (DBusConnection* connection, char* rule, DBusError* error)
    void                 dbus_bus_remove_match (DBusConnection* connection, char* rule, DBusError* error)
    DBusPendingCall*     dbus_pending_call_ref (DBusPendingCall* pending)
    void                 dbus_pending_call_unref (DBusPendingCall* pending)
    dbus_bool_t          dbus_pending_call_set_notify (DBusPendingCall* pending, DBusPendingCallNotifyFunction function, void* user_data, DBusFreeFunction free_user_data)
    void                 dbus_pending_call_cancel (DBusPendingCall* pending)
    dbus_bool_t          dbus_pending_call_get_completed (DBusPendingCall* pending)
    DBusMessage*         dbus_pending_call_steal_reply (DBusPendingCall* pending)
    void                 dbus_pending_call_block (DBusPendingCall* pending)
    dbus_bool_t          dbus_pending_call_allocate_data_slot (dbus_int32_t* slot_p)
    void                 dbus_pending_call_free_data_slot (dbus_int32_t* slot_p)
    dbus_bool_t          dbus_pending_call_set_data (DBusPendingCall* pending, dbus_int32_t slot, void* data, DBusFreeFunction free_data_func)
    void*                dbus_pending_call_get_data (DBusPendingCall* pending, dbus_int32_t slot)
    DBusServer*          dbus_server_listen (char* address, DBusError* error)
    DBusServer*          dbus_server_ref (DBusServer* server)
    void                 dbus_server_unref (DBusServer* server)
    void                 dbus_server_disconnect (DBusServer* server)
    dbus_bool_t          dbus_server_get_is_connected (DBusServer* server)
    char*                dbus_server_get_address (DBusServer* server)
    void                 dbus_server_set_new_connection_function (DBusServer* server, DBusNewConnectionFunction function, void* data, DBusFreeFunction free_data_function)
    dbus_bool_t          dbus_server_set_watch_functions (DBusServer* server, DBusAddWatchFunction add_function, DBusRemoveWatchFunction remove_function, DBusWatchToggledFunction toggled_function, void* data, DBusFreeFunction free_data_function)
    dbus_bool_t          dbus_server_set_timeout_functions (DBusServer* server, DBusAddTimeoutFunction add_function, DBusRemoveTimeoutFunction remove_function, DBusTimeoutToggledFunction toggled_function, void* data, DBusFreeFunction free_data_function)
    dbus_bool_t          dbus_server_set_auth_mechanisms (DBusServer* server, char** mechanisms)
    dbus_bool_t          dbus_server_allocate_data_slot (dbus_int32_t* slot_p)
    void                 dbus_server_free_data_slot (dbus_int32_t* slot_p)
    dbus_bool_t          dbus_server_set_data (DBusServer* server, int slot, void* data, DBusFreeFunction free_data_func)
    void*                dbus_server_get_data (DBusServer* server, int slot)
    void                 dbus_signature_iter_init (DBusSignatureIter* iter, char* signature)
    int                  dbus_signature_iter_get_current_type (DBusSignatureIter* iter)
    char*                dbus_signature_iter_get_signature (DBusSignatureIter* iter)
    int                  dbus_signature_iter_get_element_type (DBusSignatureIter* iter)
    dbus_bool_t          dbus_signature_iter_next (DBusSignatureIter* iter)
    void                 dbus_signature_iter_recurse (DBusSignatureIter* iter, DBusSignatureIter* subiter)
    dbus_bool_t          dbus_signature_validate (char* signature, DBusError* error)
    dbus_bool_t          dbus_signature_validate_single (char* signature, DBusError* error)
    dbus_bool_t          dbus_type_is_basic (int typecode)
    dbus_bool_t          dbus_type_is_container (int typecode)
    dbus_bool_t          dbus_type_is_fixed (int typecode)
    dbus_bool_t          dbus_threads_init (DBusThreadFunctions* functions)
    pass


cdef class Connection:
    cdef DBusConnection *conn

    cdef __cinit__(self, address, DBusConnection *_conn)
    cdef _set_conn(self, DBusConnection *conn)
    cdef DBusConnection *_get_conn(self)
