.\"
.\" "$Id: cupsfilter.man 9030 2010-03-05 03:55:56Z mike $"
.\"
.\"   cupsfilter man page for CUPS.
.\"
.\"   Copyright 2007-2010 by Apple Inc.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Apple Inc. and are protected by Federal copyright
.\"   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\"   which should have been included with this file.  If this file is
.\"   file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cupsfilter 8 "CUPS" "4 March 2010" "Apple Inc."
.SH NAME
cupsfilter \- convert a file to another format using cups filters
.SH SYNOPSIS
.B cupsfilter
[ -c
.I config-file
] [ -d 
.I printer
] [ -e ] -j
.I job-id[,N]
[ -m
.I mime/type
] [ -n
.I copies
] [ -o
.I name=value
] [ -p
.I filename.ppd
] [ -t
.I title
]
.I filename
.SH DESCRIPTION
\fIcupsfilter\fR is a front-end to the CUPS filter subsystem which allows you
to convert a file to a specific format, just as if you had printed the file
through CUPS. By default, \fIcupsfilter\fR generates a PDF file.
.SH OPTIONS
.TP 5
-c config-file
.br
Uses the named cupsd.conf configuration file.
.TP 5
-d printer
Uses information from the named printer.
.TP 5
-e
.br
Use every filter from the PPD file.
.TP 5
-j job-id[,N]
.br
Converts document N from the specified job. If N is omitted, document 1 is
converted.
.TP 5
-m mime/type
.br
Specifies the destination file type. The default file type is application/pdf.
Use printer/foo to convert to the printer format defined by the filters in the
PPD file.
.TP 5
-n copies
.br
Specifies the number of copies to generate.
.TP 5
-o name=value
.br
Specifies options to pass to the CUPS filters.
.TP 5
-p filename.ppd
.br
Specifies the PPD file to use.
.TP 5
-t title
.br
Specifies the document title.
.SH KNOWN ISSUES
\fIcupsfilter\fR currently does not use the filters defined in the PPD file.
This will be addressed in a future CUPS release.
.SH SEE ALSO
\fIcupsd.conf(5)\fR
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 2007-2010 by Apple Inc.
.\"
.\" End of "$Id: cupsfilter.man 9030 2010-03-05 03:55:56Z mike $".
.\"
