/*-------------------------------------------------------------------------
Compiler Generator Coco/R,
Copyright (c) 1990, 2004 Hanspeter Moessenboeck, University of Linz
extended by M. Loeberbauer & A. Woess, Univ. of Linz
ported from C# to Java by Wolfgang Ahorner
with improvements by Pat Terry, Rhodes University

This program is free software; you can redistribute it and/or modify it 
under the terms of the GNU General Public License as published by the 
Free Software Foundation; either version 2, or (at your option) any 
later version.

This program is distributed in the hope that it will be useful, but 
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
for more details.

You should have received a copy of the GNU General Public License along 
with this program; if not, write to the Free Software Foundation, Inc., 
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

As an exception, it is allowed to write an extension of Coco/R that is
used as a plugin in non-free software.

If not otherwise stated, any source code generated by Coco/R (other than 
Coco/R itself) does not fall under the GNU General Public License.
------------------------------------------------------------------------*/
package Coco;

import java.util.BitSet;

public class Parser {
	static final int _EOF = 0;
	static final int _ident = 1;
	static final int _number = 2;
	static final int _string = 3;
	static final int _badString = 4;
	static final int _char = 5;
	static final int maxT = 44;

	static final boolean T = true;
	static final boolean x = false;
	static final int minErrDist = 2;

	public static Token t;                   // last recognized token
	public static Token la;                  // lookahead token
	static int errDist = minErrDist;

	static final int id = 0;
	static final int str = 1;

	static boolean genScanner;
	static String tokenString;         // used in declarations of literal tokens
	static String noString = "-none-"; // used in declarations of literal tokens

/*-------------------------------------------------------------------------*/



	static void SynErr (int n) {
		if (errDist >= minErrDist) Errors.SynErr(la.line, la.col, n);
		errDist = 0;
	}

	public static void SemErr (String msg) {
		if (errDist >= minErrDist) Errors.Error(t.line, t.col, msg);
		errDist = 0;
	}
	
	static void Get () {
		for (;;) {
			t = la;
			la = Scanner.Scan();
			if (la.kind <= maxT) { ++errDist; break; }

			if (la.kind == 45) {
				Tab.SetDDT(la.val); 
			}
			la = t;
		}
	}
	
	static void Expect (int n) {
		if (la.kind==n) Get(); else { SynErr(n); }
	}
	
	static boolean StartOf (int s) {
		return set[s][la.kind];
	}
	
	static void ExpectWeak (int n, int follow) {
		if (la.kind == n) Get();
		else {
			SynErr(n);
			while (!StartOf(follow)) Get();
		}
	}
	
	static boolean WeakSeparator (int n, int syFol, int repFol) {
		boolean[] s = new boolean[maxT+1];
		if (la.kind == n) { Get(); return true; }
		else if (StartOf(repFol)) return false;
		else {
			for (int i=0; i <= maxT; i++) {
				s[i] = set[syFol][i] || set[repFol][i] || set[0][i];
			}
			SynErr(n);
			while (!s[la.kind]) Get();
			return StartOf(syFol);
		}
	}
	
	static void Coco() {
		Symbol sym; Graph g, g1, g2; String gramName; BitSet s; 
		if (la.kind == 42) {
			ParserGen.usingPos = Imports();
		}
		Expect(6);
		genScanner = true; 
		Tab.ignored = new BitSet(CharClass.charSetSize); 
		Expect(1);
		gramName = t.val;
		int beg = la.pos;
		
		while (StartOf(1)) {
			Get();
		}
		Tab.semDeclPos = new Position(beg, la.pos-beg, 0); 
		if (la.kind == 7) {
			Get();
			DFA.ignoreCase = true; 
		}
		if (la.kind == 8) {
			Get();
			while (la.kind == 1) {
				SetDecl();
			}
		}
		if (la.kind == 9) {
			Get();
			while (la.kind == 1 || la.kind == 3 || la.kind == 5) {
				TokenDecl(Node.t);
			}
		}
		if (la.kind == 10) {
			Get();
			while (la.kind == 1 || la.kind == 3 || la.kind == 5) {
				TokenDecl(Node.pr);
			}
		}
		while (la.kind == 11) {
			Get();
			boolean nested = false; 
			Expect(12);
			g1 = TokenExpr();
			Expect(13);
			g2 = TokenExpr();
			if (la.kind == 14) {
				Get();
				nested = true; 
			}
			new Comment(g1.l, g2.l, nested); 
		}
		while (la.kind == 15) {
			Get();
			s = Set();
			Tab.ignored.or(s); 
		}
		while (!(la.kind == 0 || la.kind == 16)) {SynErr(45); Get();}
		Expect(16);
		if (genScanner) DFA.MakeDeterministic();
		Graph.DeleteNodes();
		
		while (la.kind == 1) {
			Get();
			sym = Symbol.Find(t.val);
			boolean undef = sym == null;
			if (undef) sym = new Symbol(Node.nt, t.val, t.line);
			else {
			  if (sym.typ == Node.nt) {
			    if (sym.graph != null) SemErr("name declared twice");
			  } else SemErr("this symbol kind not allowed on left side of production");
			  sym.line = t.line;
			}
			boolean noAttrs = sym.attrPos == null;
			sym.attrPos = null;
			boolean noRet = sym.retVar==null;
			sym.retVar = null;
			
			if (la.kind == 24) {
				AttrDecl(sym);
			}
			if (!undef)
			 if (noAttrs != (sym.attrPos == null)
			   || noRet != (sym.retVar == null))
			   SemErr("attribute mismatch between declaration and use of this symbol");
			
			if (la.kind == 40) {
				sym.semPos = SemText();
			}
			ExpectWeak(17, 2);
			g = Expression();
			sym.graph = g.l;
			Graph.Finish(g);
			
			ExpectWeak(18, 3);
		}
		Expect(19);
		Expect(1);
		if (gramName.compareTo(t.val) != 0)
		 SemErr("name does not match grammar name");
		Tab.gramSy = Symbol.Find(gramName);
		if (Tab.gramSy == null)
		  SemErr("missing production for grammar name");
		else {
		  sym = Tab.gramSy;
		  if (sym.attrPos != null)
		    SemErr("grammar symbol must not have attributes");
		}
		Tab.noSym = new Symbol(Node.t, "???", 0); // noSym gets highest number
		Tab.SetupAnys();
		Tab.RenumberPragmas();
		if (Tab.ddt[2]) Node.PrintNodes();
		if (Errors.count == 0) {
		  System.out.println("checking");
		  Tab.CompSymbolSets();
		  if (Tab.ddt[7]) Tab.XRef();
		  if (Tab.GrammarOk()) {
		    System.out.print("parser");
		    ParserGen.WriteParser();
		    if (genScanner) {
		      System.out.print(" + scanner");
		      DFA.WriteScanner();
		      if (Tab.ddt[0]) DFA.PrintStates();
		    }
		    System.out.println(" generated");
		    if (Tab.ddt[8]) ParserGen.WriteStatistics();
		  }
		}
		if (Tab.ddt[6]) Tab.PrintSymbolTable();
		
		Expect(18);
	}

	static Position Imports() {
		Position pos;
		Expect(42);
		int beg = t.pos; 
		while (StartOf(4)) {
			Get();
		}
		Expect(43);
		int end = t.pos; 
		while (la.kind == 42) {
			Get();
			while (StartOf(4)) {
				Get();
			}
			Expect(43);
			end = t.pos; 
		}
		pos = new Position(beg, end - beg + 1, 0); 
		return pos;
	}

	static void SetDecl() {
		BitSet s; 
		Expect(1);
		String name = t.val;
		CharClass c = CharClass.Find(name);
		if (c != null) SemErr("name declared twice");
		
		Expect(17);
		s = Set();
		if (Sets.Elements(s) == 0) SemErr("character set must not be empty");
		c = new CharClass(name, s);
		
		Expect(18);
	}

	static void TokenDecl(int typ) {
		SymInfo s; Symbol sym; Graph g; 
		s = Sym();
		sym = Symbol.Find(s.name);
		if (sym != null) SemErr("name declared twice");
		else {
		  sym = new Symbol(typ, s.name, t.line);
		  sym.tokenKind = Symbol.fixedToken;
		}
		tokenString = null;
		
		while (!(StartOf(5))) {SynErr(46); Get();}
		if (la.kind == 17) {
			Get();
			g = TokenExpr();
			Expect(18);
			if (s.kind == str) SemErr("a literal must not be declared with a structure");
			Graph.Finish(g);
			if (tokenString == null || tokenString.equals(noString))
			  DFA.ConvertToStates(g.l, sym);
			else { // TokenExpr is a single string
			  if (Tab.literals.get(tokenString) != null)
			    SemErr("token string declared twice");
			  Tab.literals.put(tokenString, sym);
			  DFA.MatchLiteral(tokenString, sym);
			}
			
		} else if (StartOf(6)) {
			if (s.kind == id) genScanner = false;
			else DFA.MatchLiteral(sym.name, sym);
			
		} else SynErr(47);
		if (la.kind == 40) {
			sym.semPos = SemText();
			if (typ != Node.pr) SemErr("semantic action not allowed here"); 
		}
	}

	static Graph TokenExpr() {
		Graph g;
		Graph g2; 
		g = TokenTerm();
		boolean first = true; 
		while (WeakSeparator(31,7,8) ) {
			g2 = TokenTerm();
			if (first) { Graph.MakeFirstAlt(g); first = false; }
			Graph.MakeAlternative(g, g2);
			
		}
		return g;
	}

	static BitSet Set() {
		BitSet s;
		BitSet s2; 
		s = SimSet();
		while (la.kind == 20 || la.kind == 21) {
			if (la.kind == 20) {
				Get();
				s2 = SimSet();
				s.or(s2); 
			} else {
				Get();
				s2 = SimSet();
				Sets.Subtract(s, s2); 
			}
		}
		return s;
	}

	static void AttrDecl(Symbol sym) {
		int beg, col; StringBuffer buf;
		Expect(24);
		if (la.kind == 25 || la.kind == 26) {
			if (la.kind == 25) {
				Get();
			} else {
				Get();
			}
			Expect(1);
			buf = new StringBuffer(t.val); 
			while (la.kind == 27) {
				Get();
				Expect(28);
				buf.append("[]"); 
			}
			Expect(1);
			sym.retVar = t.val;
			sym.retType = buf.toString(); 
			if (la.kind == 29) {
				Get();
			} else if (la.kind == 30) {
				Get();
				beg = la.pos; col = la.col; 
				while (StartOf(9)) {
					if (StartOf(10)) {
						Get();
					} else {
						Get();
						SemErr("bad string in attributes"); 
					}
				}
				Expect(29);
				if (t.pos > beg)
				 sym.attrPos = new Position(beg, t.pos - beg, col); 
			} else SynErr(48);
		} else if (StartOf(11)) {
			beg = la.pos; col = la.col; 
			while (StartOf(12)) {
				if (StartOf(13)) {
					Get();
				} else {
					Get();
					SemErr("bad string in attributes"); 
				}
			}
			Expect(29);
			if (t.pos > beg)
			 sym.attrPos = new Position(beg, t.pos - beg, col); 
		} else SynErr(49);
	}

	static Position SemText() {
		Position pos;
		Expect(40);
		int beg = la.pos; int col = la.col; 
		while (StartOf(14)) {
			if (StartOf(15)) {
				Get();
			} else if (la.kind == 4) {
				Get();
				SemErr("bad string in semantic action"); 
			} else {
				Get();
				SemErr("missing end of previous semantic action"); 
			}
		}
		Expect(41);
		pos = new Position(beg, t.pos - beg, col); 
		return pos;
	}

	static Graph Expression() {
		Graph g;
		Graph g2; 
		g = Term();
		boolean first = true; 
		while (WeakSeparator(31,16,17) ) {
			g2 = Term();
			if (first) { Graph.MakeFirstAlt(g); first = false; }
			Graph.MakeAlternative(g, g2);
			
		}
		return g;
	}

	static BitSet SimSet() {
		BitSet s;
		int n1, n2; 
		s = new BitSet(CharClass.charSetSize); 
		if (la.kind == 1) {
			Get();
			CharClass c = CharClass.Find(t.val);
			if (c == null) SemErr("undefined name"); else s.or(c.set);
			
		} else if (la.kind == 3) {
			Get();
			String name = t.val;
			name = DFA.Unescape(name.substring(1, name.length()-1));
			for (int i = 0; i < name.length(); i++)
			  if (DFA.ignoreCase) s.set(Character.toLowerCase(name.charAt(i)));
			  else s.set(name.charAt(i)); 
		} else if (la.kind == 5) {
			n1 = Char();
			s.set(n1); 
			if (la.kind == 22) {
				Get();
				n2 = Char();
				for (int i = n1; i <= n2; i++) s.set(i); 
			}
		} else if (la.kind == 23) {
			Get();
			s = new BitSet(CharClass.charSetSize); s.set(0, s.size()); 
		} else SynErr(50);
		return s;
	}

	static int Char() {
		int n;
		Expect(5);
		String name = t.val; n = 0;
		name = DFA.Unescape(name.substring(1, name.length()-1));
		int max = CharClass.charSetSize;
		if (name.length() == 1 && name.charAt(0) <= max-1) n = name.charAt(0) % max;
		else SemErr("unacceptable character value");
		if (DFA.ignoreCase && (char)n >= 'A' && (char)n <= 'Z') n += 32;
		
		return n;
	}

	static SymInfo Sym() {
		SymInfo s;
		s = new SymInfo(); s.name = "???"; s.kind = id; 
		if (la.kind == 1) {
			Get();
			s.kind = id; s.name = t.val; 
		} else if (la.kind == 3 || la.kind == 5) {
			if (la.kind == 3) {
				Get();
				s.name = t.val; 
			} else {
				Get();
				s.name = "\"" + t.val.substring(1, t.val.length()-1) + "\""; 
			}
			s.kind = str;
			if (DFA.ignoreCase) s.name = s.name.toLowerCase();
			if (s.name.indexOf(' ') >= 0)
			  SemErr("literal tokens must not contain blanks"); 
		} else SynErr(51);
		return s;
	}

	static Graph Term() {
		Graph g;
		Graph g2; Node rslv = null; g = null; 
		if (StartOf(18)) {
			if (la.kind == 38) {
				rslv = new Node(Node.rslv, null, la.line); 
				rslv.pos = Resolver();
				g = new Graph(rslv);                       
			}
			g2 = Factor();
			if (rslv != null) Graph.MakeSequence(g, g2);
			else g = g2;
			
			while (StartOf(19)) {
				g2 = Factor();
				Graph.MakeSequence(g, g2); 
			}
		} else if (StartOf(20)) {
			g = new Graph(new Node(Node.eps, null, 0)); 
		} else SynErr(52);
		if (g == null) // invalid start of Term
		 g = new Graph(new Node(Node.eps, null, 0));
		
		return g;
	}

	static Position Resolver() {
		Position pos;
		Expect(38);
		Expect(33);
		int beg = la.pos; int col = la.col; 
		Condition();
		pos = new Position(beg, t.pos - beg, col); 
		return pos;
	}

	static Graph Factor() {
		Graph g;
		SymInfo s; Position pos; boolean weak = false;
		g = null; 
		switch (la.kind) {
		case 1: case 3: case 5: case 32: {
			if (la.kind == 32) {
				Get();
				weak = true; 
			}
			s = Sym();
			Symbol sym = Symbol.Find(s.name);
			if (sym == null && s.kind == str)
			  sym = (Symbol)Tab.literals.get(s.name);
			boolean undef = sym == null;
			if (undef) {
			  if (s.kind == id)
			    sym = new Symbol(Node.nt, s.name, 0);  // forward nt
			  else if (genScanner) {
			    sym = new Symbol(Node.t, s.name, t.line);
			    DFA.MatchLiteral(sym.name, sym);
			  } else {  // undefined string in production
			    SemErr("undefined string in production");
			    sym = Tab.eofSy;  // dummy
			  }
			}
			int typ = sym.typ;
			if (typ != Node.t && typ != Node.nt)
			  SemErr("this symbol kind is not allowed in a production");
			if (weak)
			  if (typ == Node.t) typ = Node.wt;
			  else SemErr("only terminals may be weak");
			Node p = new Node(typ, sym, t.line);
			g = new Graph(p);
			
			if (la.kind == 24) {
				Attribs(p);
				if (s.kind != id) SemErr("a literal must not have attributes"); 
			}
			if (undef) {
			 sym.attrPos = p.pos;  // dummy
			 sym.retVar = p.retVar;  // AH - dummy
			} else if ((p.pos == null) != (sym.attrPos == null)
			       || (p.retVar == null) != (sym.retVar == null))
			  SemErr("attribute mismatch between declaration and use of this symbol");
			
			break;
		}
		case 33: {
			Get();
			g = Expression();
			Expect(34);
			break;
		}
		case 27: {
			Get();
			g = Expression();
			Expect(28);
			Graph.MakeOption(g); 
			break;
		}
		case 35: {
			Get();
			g = Expression();
			Expect(36);
			Graph.MakeIteration(g); 
			break;
		}
		case 40: {
			pos = SemText();
			Node p = new Node(Node.sem, null, 0);
			p.pos = pos;
			g = new Graph(p);
			
			break;
		}
		case 23: {
			Get();
			Node p = new Node(Node.any, null, 0);  // p.set is set in Tab.SetupAnys
			g = new Graph(p);
			
			break;
		}
		case 37: {
			Get();
			Node p = new Node(Node.sync, null, 0);
			g = new Graph(p);
			
			break;
		}
		default: SynErr(53); break;
		}
		if (g == null) // invalid start of Factor
		 g = new Graph(new Node(Node.eps, null, 0));
		
		return g;
	}

	static void Attribs(Node n) {
		int beg, col; 
		Expect(24);
		if (la.kind == 25 || la.kind == 26) {
			if (la.kind == 25) {
				Get();
			} else {
				Get();
			}
			beg = la.pos; 
			while (StartOf(21)) {
				if (StartOf(22)) {
					Get();
				} else {
					Get();
					SemErr("bad string in attributes"); 
				}
			}
			n.retVar = Buffer.GetString(beg, la.pos); 
			if (la.kind == 29) {
				Get();
			} else if (la.kind == 30) {
				Get();
				beg = la.pos; col = la.col; 
				while (StartOf(9)) {
					if (StartOf(10)) {
						Get();
					} else {
						Get();
						SemErr("bad string in attributes"); 
					}
				}
				Expect(29);
				if (t.pos > beg) n.pos = new Position(beg, t.pos - beg, col); 
			} else SynErr(54);
		} else if (StartOf(11)) {
			beg = la.pos; col = la.col; 
			while (StartOf(12)) {
				if (StartOf(13)) {
					Get();
				} else {
					Get();
					SemErr("bad string in attributes"); 
				}
			}
			Expect(29);
			if (t.pos > beg) n.pos = new Position(beg, t.pos - beg, col); 
		} else SynErr(55);
	}

	static void Condition() {
		while (StartOf(23)) {
			if (la.kind == 33) {
				Get();
				Condition();
			} else {
				Get();
			}
		}
		Expect(34);
	}

	static Graph TokenTerm() {
		Graph g;
		Graph g2; 
		g = TokenFactor();
		while (StartOf(7)) {
			g2 = TokenFactor();
			Graph.MakeSequence(g, g2); 
		}
		if (la.kind == 39) {
			Get();
			Expect(33);
			g2 = TokenExpr();
			Graph.SetContextTrans(g2.l); Graph.MakeSequence(g, g2); 
			Expect(34);
		}
		return g;
	}

	static Graph TokenFactor() {
		Graph g;
		SymInfo s; 
		g = null; 
		if (la.kind == 1 || la.kind == 3 || la.kind == 5) {
			s = Sym();
			if (s.kind == id) {
			 CharClass c = CharClass.Find(s.name);
			 if (c == null) {
			   SemErr("undefined name");
			   c = new CharClass(s.name, new BitSet(CharClass.charSetSize));
			 }
			 Node p = new Node(Node.clas, null, 0); p.val = c.n;
			 g = new Graph(p);
			 tokenString = noString;
			} else { // str
			  g = Graph.StrToGraph(s.name);
			  if (tokenString == null) tokenString = s.name;
			  else tokenString = noString;
			}
			
		} else if (la.kind == 33) {
			Get();
			g = TokenExpr();
			Expect(34);
		} else if (la.kind == 27) {
			Get();
			g = TokenExpr();
			Expect(28);
			Graph.MakeOption(g); 
		} else if (la.kind == 35) {
			Get();
			g = TokenExpr();
			Expect(36);
			Graph.MakeIteration(g); 
		} else SynErr(56);
		if (g == null) // invalid start of TokenFactor
		 g = new Graph(new Node(Node.eps, null, 0)); 
		return g;
	}



	public static void Parse() {
		la = new Token();
		la.val = "";		
		Get();
		Coco();

		Expect(0);
		Buffer.Close();
	}

	private static boolean[][] set = {
		{T,T,x,T, x,T,x,x, x,x,T,T, x,x,x,T, T,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x},
		{x,T,T,T, T,T,T,x, x,x,x,x, T,T,T,x, x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{T,T,x,T, x,T,x,x, x,x,T,T, x,x,x,T, T,T,T,x, x,x,x,T, x,x,x,T, x,x,x,T, T,T,x,T, x,T,T,x, T,x,x,x, x,x},
		{T,T,x,T, x,T,x,x, x,x,T,T, x,x,x,T, T,T,x,T, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x},
		{x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,x, T,x},
		{T,T,x,T, x,T,x,x, x,x,T,T, x,x,x,T, T,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x},
		{x,T,x,T, x,T,x,x, x,x,T,T, x,x,x,T, T,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x},
		{x,T,x,T, x,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,x, x,T,x,T, x,x,x,x, x,x,x,x, x,x},
		{x,x,x,x, x,x,x,x, x,x,x,T, x,T,T,T, T,x,T,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x,T,x, T,x,x,x, x,x,x,x, x,x},
		{x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{x,T,T,T, x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,x,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,x,T, T,x,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{x,T,T,T, x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,x,T, T,x,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,T,T, T,x},
		{x,T,T,T, x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, x,x,T,T, T,x},
		{x,T,x,T, x,T,x,x, x,x,x,x, x,x,x,x, x,x,T,x, x,x,x,T, x,x,x,T, T,x,x,T, T,T,T,T, T,T,T,x, T,x,x,x, x,x},
		{x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,T,x, x,x,x,x, x,x,x,x, T,x,x,x, x,x,T,x, T,x,x,x, x,x,x,x, x,x},
		{x,T,x,T, x,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,T, x,x,x,x, T,T,x,T, x,T,T,x, T,x,x,x, x,x},
		{x,T,x,T, x,T,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,T, x,x,x,T, x,x,x,x, T,T,x,T, x,T,x,x, T,x,x,x, x,x},
		{x,x,x,x, x,x,x,x, x,x,x,x, x,x,x,x, x,x,T,x, x,x,x,x, x,x,x,x, T,x,x,T, x,x,T,x, T,x,x,x, x,x,x,x, x,x},
		{x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,x,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{x,T,T,T, x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x,x,T, T,T,T,T, T,T,T,T, T,T,T,T, T,x},
		{x,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,T,T, T,T,x,T, T,T,T,T, T,T,T,T, T,x}

	};
} // end Parser


class Errors {
	public static int count = 0;
	public static String errMsgFormat = "-- line {0} col {1}: {2}";

	private static void printMsg(int line, int column, String msg) {
		StringBuffer b = new StringBuffer(errMsgFormat);
		int pos = b.indexOf("{0}");
		if (pos >= 0) { b.delete(pos, pos+3); b.insert(pos, line); }
		pos = b.indexOf("{1}");
		if (pos >= 0) { b.delete(pos, pos+3); b.insert(pos, column); }
		pos = b.indexOf("{2}");
		if (pos >= 0) b.replace(pos, pos+3, msg);
		System.out.println(b.toString());
	}
	
	public static void SynErr (int line, int col, int n) {
			String s;
			switch (n) {
			case 0: s = "EOF expected"; break;
			case 1: s = "ident expected"; break;
			case 2: s = "number expected"; break;
			case 3: s = "string expected"; break;
			case 4: s = "badString expected"; break;
			case 5: s = "char expected"; break;
			case 6: s = "\"COMPILER\" expected"; break;
			case 7: s = "\"IGNORECASE\" expected"; break;
			case 8: s = "\"CHARACTERS\" expected"; break;
			case 9: s = "\"TOKENS\" expected"; break;
			case 10: s = "\"PRAGMAS\" expected"; break;
			case 11: s = "\"COMMENTS\" expected"; break;
			case 12: s = "\"FROM\" expected"; break;
			case 13: s = "\"TO\" expected"; break;
			case 14: s = "\"NESTED\" expected"; break;
			case 15: s = "\"IGNORE\" expected"; break;
			case 16: s = "\"PRODUCTIONS\" expected"; break;
			case 17: s = "\"=\" expected"; break;
			case 18: s = "\".\" expected"; break;
			case 19: s = "\"END\" expected"; break;
			case 20: s = "\"+\" expected"; break;
			case 21: s = "\"-\" expected"; break;
			case 22: s = "\"..\" expected"; break;
			case 23: s = "\"ANY\" expected"; break;
			case 24: s = "\"<\" expected"; break;
			case 25: s = "\"^\" expected"; break;
			case 26: s = "\"out\" expected"; break;
			case 27: s = "\"[\" expected"; break;
			case 28: s = "\"]\" expected"; break;
			case 29: s = "\">\" expected"; break;
			case 30: s = "\",\" expected"; break;
			case 31: s = "\"|\" expected"; break;
			case 32: s = "\"WEAK\" expected"; break;
			case 33: s = "\"(\" expected"; break;
			case 34: s = "\")\" expected"; break;
			case 35: s = "\"{\" expected"; break;
			case 36: s = "\"}\" expected"; break;
			case 37: s = "\"SYNC\" expected"; break;
			case 38: s = "\"IF\" expected"; break;
			case 39: s = "\"CONTEXT\" expected"; break;
			case 40: s = "\"(.\" expected"; break;
			case 41: s = "\".)\" expected"; break;
			case 42: s = "\"import\" expected"; break;
			case 43: s = "\";\" expected"; break;
			case 44: s = "??? expected"; break;
			case 45: s = "this symbol not expected in Coco"; break;
			case 46: s = "this symbol not expected in TokenDecl"; break;
			case 47: s = "invalid TokenDecl"; break;
			case 48: s = "invalid AttrDecl"; break;
			case 49: s = "invalid AttrDecl"; break;
			case 50: s = "invalid SimSet"; break;
			case 51: s = "invalid Sym"; break;
			case 52: s = "invalid Term"; break;
			case 53: s = "invalid Factor"; break;
			case 54: s = "invalid Attribs"; break;
			case 55: s = "invalid Attribs"; break;
			case 56: s = "invalid TokenFactor"; break;
				default: s = "error " + n; break;
			}
			printMsg(line, col, s);
			count++;
	}

	public static void SemErr (int line, int col, int n) {
		printMsg(line, col, "error " + n);
		count++;
	}

	public static void Error (int line, int col, String s) {	
		printMsg(line, col, s);
		count++;
	}

	public static void Exception (String s) {
		System.out.println(s); 
		System.exit(1);
	}
} // Errors

