/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2001 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: Tools.pmod,v 1.9.2.5 2001/09/30 23:42:00 kiwi Exp $
 */

//! file: Tools.pmod
//!  General tools for CAMAS
//! cvs_version: $Id: Tools.pmod,v 1.9.2.5 2001/09/30 23:42:00 kiwi Exp $

// is_7bitsafe() uses it for sscanf template, handle with care 
#define IS_7BITSAFE_TEMPLATE "%*[\040-\0177]%*c"

//! method: string scut(string s, int len)
//!  Cut the string s into 'len' size max and add '...'
//! arg: string s
//!  String to cut
string scut(string s, int len)
{
  if (len > 1) len = len -1;
  if (sizeof(s) > len) {
   if (len > 3) len = len - 3;
    return s[..len] + "...";
  }
  else
    return s;		// just in case
}

//! method: string old_rand_string(int len)
//!  Random a string (used to add it in url to avoid strange caching problems)
//! returns:
//!  A random string
//! arg: int len
//!  The size of the string
string old_rand_string (int len) {
  string chr="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKMNOPQRSTUVWXYZ0123456789";
  string foo= "";
  int bar;
  int s=sizeof(chr);
  for(int i=0;i<len;i++){
    bar = random(s);
    foo+=chr[bar..bar];
  }
  return foo;
}

//! method: string rand_string(int len)
//!  Random a string (used to add it in url to avoid caching problems with
//!  some browser like MSIE)
//! returns:
//!  A random string
//! arg: int len
//!  Size of the string. Note that the size is depending of hex encoding
//!  of the internal Crypto thing.
string rand_string(int len) {
 string out;

 mixed err = catch {
   out = Crypto.randomness.reasonably_random()->read(5+len);
 };

 if (err) {
   out = old_rand_string(5+len);
 }
 else {
   out = Crypto.string_to_hex(out);
 }
 return out;
}

//! method: int is_7bitsafe(string s)
//!  determinate either a string is 7bit safe or not.
//! arg: string s
//!  String to check either 7bit safe
int is_7bitsafe( string s ) {
	return ( sscanf( s, IS_7BITSAFE_TEMPLATE ) == 1 );
}
