/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-03-25 20:09
 */

#ifndef LOG_H_
#define LOG_H_

//#define _DEBUG

#ifdef _DEBUG

#include <log4cxx/logger.h>
#include <log4cxx/basicconfigurator.h>
#include <log4cxx/propertyconfigurator.h>
#include <log4cxx/helpers/exception.h>

//using namespace log4cxx;

extern log4cxx::LoggerPtr __logger;

#define	LOG_DEBUG(message) 	LOG4CXX_DEBUG(__logger, message)
#define 	LOG_INFO(message)	LOG4CXX_INFO(__logger, message)
#define 	LOG_WARN(message)	LOG4CXX_WARN(__logger, message)
#define 	LOG_ERROR(message)	LOG4CXX_ERROR(__logger, message)
#define 	LOG_FATAL(message)	LOG4CXX_FATAL(__logger, message)

// 声明logger
#define DEFINE_LOGGER(name) log4cxx::LoggerPtr __logger(log4cxx::Logger::getLogger(name))

// 加载log配置
inline void log_load_config(const char* conf_file)
{
	log4cxx::PropertyConfigurator::configure(conf_file);
}

#else

#define	LOG_DEBUG(message) 	
#define 	LOG_INFO(message)	
#define 	LOG_WARN(message)	
#define 	LOG_ERROR(message)
#define 	LOG_FATAL(message)	

#define DEFINE_LOGGER(name) 
	
inline void log_load_config(const char* conf_file)
{
	return;
}	
#endif

#endif /*LOG_H_*/
