# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to the Samsung SCH-A950 Phone"""

from prototypes import *
from prototypes_samsung import *
from p_brew import *
from p_samsungscha950 import *

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

# Calendar stuff
CAL_PATH='sch_event'
CAL_INDEX_FILE_NAME=CAL_PATH+'/usr_tsk'
CAL_FILE_NAME_PREFIX=CAL_PATH+'/usr_tsk_'
CAL_MAX_EVENTS=100

CAL_REMINDER_OFF=3
CAL_REMINDER_ONCE=0
CAL_REMINDER_2MIN=1
CAL_REMINDER_15MIN=2

# Call log/history
CL_MAX_ENTRIES=90

PB_FLG_CRINGTONE=0X4000


class WRingtoneIndexEntry(BaseProtogenClass):
    __fields=['path_prefix', 'pathname', 'eor']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(WRingtoneIndexEntry,self).__init__(**dict)
        if self.__class__ is WRingtoneIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(WRingtoneIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(WRingtoneIndexEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_path_prefix
        except:
            self.__field_path_prefix=STRING(**{ 'terminator': None,               'default': '/ff/' })
        self.__field_path_prefix.writetobuffer(buf)
        self.__field_pathname.writetobuffer(buf)
        try: self.__field_eor
        except:
            self.__field_eor=STRING(**{ 'terminator': None,               'default': '|0|2\x0A' })
        self.__field_eor.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_path_prefix=STRING(**{ 'terminator': None,               'default': '/ff/' })
        self.__field_path_prefix.readfrombuffer(buf)
        self.__field_pathname=STRING(**{ 'terminator': None })
        self.__field_pathname.readfrombuffer(buf)
        self.__field_eor=STRING(**{ 'terminator': None,               'default': '|0|2\x0A' })
        self.__field_eor.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_path_prefix(self):
        try: self.__field_path_prefix
        except:
            self.__field_path_prefix=STRING(**{ 'terminator': None,               'default': '/ff/' })
        return self.__field_path_prefix.getvalue()

    def __setfield_path_prefix(self, value):
        if isinstance(value,STRING):
            self.__field_path_prefix=value
        else:
            self.__field_path_prefix=STRING(value,**{ 'terminator': None,               'default': '/ff/' })

    def __delfield_path_prefix(self): del self.__field_path_prefix

    path_prefix=property(__getfield_path_prefix, __setfield_path_prefix, __delfield_path_prefix, None)

    def __getfield_pathname(self):
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,STRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=STRING(value,**{ 'terminator': None })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def __getfield_eor(self):
        try: self.__field_eor
        except:
            self.__field_eor=STRING(**{ 'terminator': None,               'default': '|0|2\x0A' })
        return self.__field_eor.getvalue()

    def __setfield_eor(self, value):
        if isinstance(value,STRING):
            self.__field_eor=value
        else:
            self.__field_eor=STRING(value,**{ 'terminator': None,               'default': '|0|2\x0A' })

    def __delfield_eor(self): del self.__field_eor

    eor=property(__getfield_eor, __setfield_eor, __delfield_eor, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('path_prefix', self.__field_path_prefix, None)
        yield ('pathname', self.__field_pathname, None)
        yield ('eor', self.__field_eor, None)




class WRingtoneIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(WRingtoneIndexFile,self).__init__(**dict)
        if self.__class__ is WRingtoneIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(WRingtoneIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(WRingtoneIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': WRingtoneIndexEntry }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': WRingtoneIndexEntry })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': WRingtoneIndexEntry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': WRingtoneIndexEntry })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': WRingtoneIndexEntry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class RRingtoneIndexEntry(BaseProtogenClass):
    __fields=['pathname', 'misc']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(RRingtoneIndexEntry,self).__init__(**dict)
        if self.__class__ is RRingtoneIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(RRingtoneIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(RRingtoneIndexEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pathname.writetobuffer(buf)
        self.__field_misc.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=STRING(**{ 'terminator': 0x7C })
        self.__field_pathname.readfrombuffer(buf)
        self.__field_misc=STRING(**{ 'terminator': 0x0A })
        self.__field_misc.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,STRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=STRING(value,**{ 'terminator': 0x7C })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def __getfield_misc(self):
        return self.__field_misc.getvalue()

    def __setfield_misc(self, value):
        if isinstance(value,STRING):
            self.__field_misc=value
        else:
            self.__field_misc=STRING(value,**{ 'terminator': 0x0A })

    def __delfield_misc(self): del self.__field_misc

    misc=property(__getfield_misc, __setfield_misc, __delfield_misc, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)
        yield ('misc', self.__field_misc, None)




class RRingtoneIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(RRingtoneIndexFile,self).__init__(**dict)
        if self.__class__ is RRingtoneIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(RRingtoneIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(RRingtoneIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': RRingtoneIndexEntry }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': RRingtoneIndexEntry })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': RRingtoneIndexEntry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': RRingtoneIndexEntry })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': RRingtoneIndexEntry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class CalIndexEntry(BaseProtogenClass):
    __fields=['index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalIndexEntry,self).__init__(**dict)
        if self.__class__ is CalIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_index=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_index
        except:
            self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        try: self.__field_index
        except:
            self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)




class CalIndexFile(BaseProtogenClass):
    __fields=['next_index', 'zero1', 'numofevents', 'zero2', 'numofnotes', 'zero3', 'numofactiveevents', 'zero4', 'events', 'notes', 'activeevents']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalIndexFile,self).__init__(**dict)
        if self.__class__ is CalIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalIndexFile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_next_index.writetobuffer(buf)
        try: self.__field_zero1
        except:
            self.__field_zero1=UNKNOWN(**{'sizeinbytes': 12,  'pad': 0 })
        self.__field_zero1.writetobuffer(buf)
        self.__field_numofevents.writetobuffer(buf)
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 6,  'pad': 0 })
        self.__field_zero2.writetobuffer(buf)
        self.__field_numofnotes.writetobuffer(buf)
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        self.__field_zero3.writetobuffer(buf)
        self.__field_numofactiveevents.writetobuffer(buf)
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 112,  'pad': 0 })
        self.__field_zero4.writetobuffer(buf)
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        self.__field_events.writetobuffer(buf)
        try: self.__field_notes
        except:
            self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })
        self.__field_notes.writetobuffer(buf)
        try: self.__field_activeevents
        except:
            self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })
        self.__field_activeevents.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_next_index=UINT(**{'sizeinbytes': 2})
        self.__field_next_index.readfrombuffer(buf)
        self.__field_zero1=UNKNOWN(**{'sizeinbytes': 12,  'pad': 0 })
        self.__field_zero1.readfrombuffer(buf)
        self.__field_numofevents=UINT(**{'sizeinbytes': 2})
        self.__field_numofevents.readfrombuffer(buf)
        self.__field_zero2=UNKNOWN(**{'sizeinbytes': 6,  'pad': 0 })
        self.__field_zero2.readfrombuffer(buf)
        self.__field_numofnotes=UINT(**{'sizeinbytes': 2})
        self.__field_numofnotes.readfrombuffer(buf)
        self.__field_zero3=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        self.__field_zero3.readfrombuffer(buf)
        self.__field_numofactiveevents=UINT(**{'sizeinbytes': 2})
        self.__field_numofactiveevents.readfrombuffer(buf)
        self.__field_zero4=UNKNOWN(**{'sizeinbytes': 112,  'pad': 0 })
        self.__field_zero4.readfrombuffer(buf)
        self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        self.__field_events.readfrombuffer(buf)
        self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })
        self.__field_notes.readfrombuffer(buf)
        self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })
        self.__field_activeevents.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_next_index(self):
        return self.__field_next_index.getvalue()

    def __setfield_next_index(self, value):
        if isinstance(value,UINT):
            self.__field_next_index=value
        else:
            self.__field_next_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_next_index(self): del self.__field_next_index

    next_index=property(__getfield_next_index, __setfield_next_index, __delfield_next_index, None)

    def __getfield_zero1(self):
        try: self.__field_zero1
        except:
            self.__field_zero1=UNKNOWN(**{'sizeinbytes': 12,  'pad': 0 })
        return self.__field_zero1.getvalue()

    def __setfield_zero1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero1=value
        else:
            self.__field_zero1=UNKNOWN(value,**{'sizeinbytes': 12,  'pad': 0 })

    def __delfield_zero1(self): del self.__field_zero1

    zero1=property(__getfield_zero1, __setfield_zero1, __delfield_zero1, None)

    def __getfield_numofevents(self):
        return self.__field_numofevents.getvalue()

    def __setfield_numofevents(self, value):
        if isinstance(value,UINT):
            self.__field_numofevents=value
        else:
            self.__field_numofevents=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofevents(self): del self.__field_numofevents

    numofevents=property(__getfield_numofevents, __setfield_numofevents, __delfield_numofevents, None)

    def __getfield_zero2(self):
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 6,  'pad': 0 })
        return self.__field_zero2.getvalue()

    def __setfield_zero2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero2=value
        else:
            self.__field_zero2=UNKNOWN(value,**{'sizeinbytes': 6,  'pad': 0 })

    def __delfield_zero2(self): del self.__field_zero2

    zero2=property(__getfield_zero2, __setfield_zero2, __delfield_zero2, None)

    def __getfield_numofnotes(self):
        return self.__field_numofnotes.getvalue()

    def __setfield_numofnotes(self, value):
        if isinstance(value,UINT):
            self.__field_numofnotes=value
        else:
            self.__field_numofnotes=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofnotes(self): del self.__field_numofnotes

    numofnotes=property(__getfield_numofnotes, __setfield_numofnotes, __delfield_numofnotes, None)

    def __getfield_zero3(self):
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        return self.__field_zero3.getvalue()

    def __setfield_zero3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero3=value
        else:
            self.__field_zero3=UNKNOWN(value,**{'sizeinbytes': 2,  'pad': 0 })

    def __delfield_zero3(self): del self.__field_zero3

    zero3=property(__getfield_zero3, __setfield_zero3, __delfield_zero3, None)

    def __getfield_numofactiveevents(self):
        return self.__field_numofactiveevents.getvalue()

    def __setfield_numofactiveevents(self, value):
        if isinstance(value,UINT):
            self.__field_numofactiveevents=value
        else:
            self.__field_numofactiveevents=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofactiveevents(self): del self.__field_numofactiveevents

    numofactiveevents=property(__getfield_numofactiveevents, __setfield_numofactiveevents, __delfield_numofactiveevents, None)

    def __getfield_zero4(self):
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 112,  'pad': 0 })
        return self.__field_zero4.getvalue()

    def __setfield_zero4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero4=value
        else:
            self.__field_zero4=UNKNOWN(value,**{'sizeinbytes': 112,  'pad': 0 })

    def __delfield_zero4(self): del self.__field_zero4

    zero4=property(__getfield_zero4, __setfield_zero4, __delfield_zero4, None)

    def __getfield_events(self):
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        return self.__field_events.getvalue()

    def __setfield_events(self, value):
        if isinstance(value,LIST):
            self.__field_events=value
        else:
            self.__field_events=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })

    def __delfield_events(self): del self.__field_events

    events=property(__getfield_events, __setfield_events, __delfield_events, None)

    def __getfield_notes(self):
        try: self.__field_notes
        except:
            self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })
        return self.__field_notes.getvalue()

    def __setfield_notes(self, value):
        if isinstance(value,LIST):
            self.__field_notes=value
        else:
            self.__field_notes=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })

    def __delfield_notes(self): del self.__field_notes

    notes=property(__getfield_notes, __setfield_notes, __delfield_notes, None)

    def __getfield_activeevents(self):
        try: self.__field_activeevents
        except:
            self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })
        return self.__field_activeevents.getvalue()

    def __setfield_activeevents(self, value):
        if isinstance(value,LIST):
            self.__field_activeevents=value
        else:
            self.__field_activeevents=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })

    def __delfield_activeevents(self): del self.__field_activeevents

    activeevents=property(__getfield_activeevents, __setfield_activeevents, __delfield_activeevents, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('next_index', self.__field_next_index, None)
        yield ('zero1', self.__field_zero1, None)
        yield ('numofevents', self.__field_numofevents, None)
        yield ('zero2', self.__field_zero2, None)
        yield ('numofnotes', self.__field_numofnotes, None)
        yield ('zero3', self.__field_zero3, None)
        yield ('numofactiveevents', self.__field_numofactiveevents, None)
        yield ('zero4', self.__field_zero4, None)
        yield ('events', self.__field_events, None)
        yield ('notes', self.__field_notes, None)
        yield ('activeevents', self.__field_activeevents, None)




class CalEntry(BaseProtogenClass):
    __fields=['titlelen', 'title', 'start', 'zero1', 'start2', 'zero2', 'exptime', 'zero3', 'one', 'repeat', 'three', 'alarm', 'alert', 'reminder', 'zero4', 'duration', 'timezone', 'creationtime', 'zero5', 'modifiedtime', 'zero6', 'ringtonelen', 'ringtone', 'zero7']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalEntry,self).__init__(**dict)
        if self.__class__ is CalEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_titlelen.writetobuffer(buf)
        self.__field_title.writetobuffer(buf)
        self.__field_start.writetobuffer(buf)
        try: self.__field_zero1
        except:
            self.__field_zero1=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero1.writetobuffer(buf)
        try: self.__field_start2
        except:
            self.__field_start2=DateTime(**{'sizeinbytes': 4,  'default': self.start })
        self.__field_start2.writetobuffer(buf)
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero2.writetobuffer(buf)
        self.__field_exptime.writetobuffer(buf)
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero3.writetobuffer(buf)
        try: self.__field_one
        except:
            self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        self.__field_one.writetobuffer(buf)
        self.__field_repeat.writetobuffer(buf)
        try: self.__field_three
        except:
            self.__field_three=UINT(**{'sizeinbytes': 1,  'default': 3 })
        self.__field_three.writetobuffer(buf)
        self.__field_alarm.writetobuffer(buf)
        self.__field_alert.writetobuffer(buf)
        try: self.__field_reminder
        except:
            self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })
        self.__field_reminder.writetobuffer(buf)
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 5,  'pad': 0 })
        self.__field_zero4.writetobuffer(buf)
        self.__field_duration.writetobuffer(buf)
        self.__field_timezone.writetobuffer(buf)
        self.__field_creationtime.writetobuffer(buf)
        try: self.__field_zero5
        except:
            self.__field_zero5=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero5.writetobuffer(buf)
        self.__field_modifiedtime.writetobuffer(buf)
        try: self.__field_zero6
        except:
            self.__field_zero6=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero6.writetobuffer(buf)
        self.__field_ringtonelen.writetobuffer(buf)
        self.__field_ringtone.writetobuffer(buf)
        try: self.__field_zero7
        except:
            self.__field_zero7=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        self.__field_zero7.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_titlelen=UINT(**{'sizeinbytes': 2})
        self.__field_titlelen.readfrombuffer(buf)
        self.__field_title=USTRING(**{ 'sizeinbytes': self.titlelen,                'encoding': ENCODING,                'terminator': None })
        self.__field_title.readfrombuffer(buf)
        self.__field_start=DateTime(**{'sizeinbytes': 4})
        self.__field_start.readfrombuffer(buf)
        self.__field_zero1=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero1.readfrombuffer(buf)
        self.__field_start2=DateTime(**{'sizeinbytes': 4,  'default': self.start })
        self.__field_start2.readfrombuffer(buf)
        self.__field_zero2=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero2.readfrombuffer(buf)
        self.__field_exptime=ExpiringTime(**{'sizeinbytes': 4})
        self.__field_exptime.readfrombuffer(buf)
        self.__field_zero3=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero3.readfrombuffer(buf)
        self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        self.__field_one.readfrombuffer(buf)
        self.__field_repeat=UINT(**{'sizeinbytes': 1})
        self.__field_repeat.readfrombuffer(buf)
        self.__field_three=UINT(**{'sizeinbytes': 1,  'default': 3 })
        self.__field_three.readfrombuffer(buf)
        self.__field_alarm=UINT(**{'sizeinbytes': 1})
        self.__field_alarm.readfrombuffer(buf)
        self.__field_alert=UINT(**{'sizeinbytes': 1})
        self.__field_alert.readfrombuffer(buf)
        self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })
        self.__field_reminder.readfrombuffer(buf)
        self.__field_zero4=UNKNOWN(**{'sizeinbytes': 5,  'pad': 0 })
        self.__field_zero4.readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self.__field_timezone=UINT(**{'sizeinbytes': 1})
        self.__field_timezone.readfrombuffer(buf)
        self.__field_creationtime=DateTime(**{'sizeinbytes': 4})
        self.__field_creationtime.readfrombuffer(buf)
        self.__field_zero5=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero5.readfrombuffer(buf)
        self.__field_modifiedtime=DateTime(**{'sizeinbytes': 4})
        self.__field_modifiedtime.readfrombuffer(buf)
        self.__field_zero6=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        self.__field_zero6.readfrombuffer(buf)
        self.__field_ringtonelen=UINT(**{'sizeinbytes': 2})
        self.__field_ringtonelen.readfrombuffer(buf)
        self.__field_ringtone=STRING(**{ 'sizeinbytes': self.ringtonelen,               'terminator': None })
        self.__field_ringtone.readfrombuffer(buf)
        self.__field_zero7=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        self.__field_zero7.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_titlelen(self):
        return self.__field_titlelen.getvalue()

    def __setfield_titlelen(self, value):
        if isinstance(value,UINT):
            self.__field_titlelen=value
        else:
            self.__field_titlelen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_titlelen(self): del self.__field_titlelen

    titlelen=property(__getfield_titlelen, __setfield_titlelen, __delfield_titlelen, None)

    def __getfield_title(self):
        return self.__field_title.getvalue()

    def __setfield_title(self, value):
        if isinstance(value,USTRING):
            self.__field_title=value
        else:
            self.__field_title=USTRING(value,**{ 'sizeinbytes': self.titlelen,                'encoding': ENCODING,                'terminator': None })

    def __delfield_title(self): del self.__field_title

    title=property(__getfield_title, __setfield_title, __delfield_title, None)

    def __getfield_start(self):
        return self.__field_start.getvalue()

    def __setfield_start(self, value):
        if isinstance(value,DateTime):
            self.__field_start=value
        else:
            self.__field_start=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_start(self): del self.__field_start

    start=property(__getfield_start, __setfield_start, __delfield_start, None)

    def __getfield_zero1(self):
        try: self.__field_zero1
        except:
            self.__field_zero1=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        return self.__field_zero1.getvalue()

    def __setfield_zero1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero1=value
        else:
            self.__field_zero1=UNKNOWN(value,**{'sizeinbytes': 4,  'pad': 0 })

    def __delfield_zero1(self): del self.__field_zero1

    zero1=property(__getfield_zero1, __setfield_zero1, __delfield_zero1, None)

    def __getfield_start2(self):
        try: self.__field_start2
        except:
            self.__field_start2=DateTime(**{'sizeinbytes': 4,  'default': self.start })
        return self.__field_start2.getvalue()

    def __setfield_start2(self, value):
        if isinstance(value,DateTime):
            self.__field_start2=value
        else:
            self.__field_start2=DateTime(value,**{'sizeinbytes': 4,  'default': self.start })

    def __delfield_start2(self): del self.__field_start2

    start2=property(__getfield_start2, __setfield_start2, __delfield_start2, None)

    def __getfield_zero2(self):
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        return self.__field_zero2.getvalue()

    def __setfield_zero2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero2=value
        else:
            self.__field_zero2=UNKNOWN(value,**{'sizeinbytes': 4,  'pad': 0 })

    def __delfield_zero2(self): del self.__field_zero2

    zero2=property(__getfield_zero2, __setfield_zero2, __delfield_zero2, None)

    def __getfield_exptime(self):
        return self.__field_exptime.getvalue()

    def __setfield_exptime(self, value):
        if isinstance(value,ExpiringTime):
            self.__field_exptime=value
        else:
            self.__field_exptime=ExpiringTime(value,**{'sizeinbytes': 4})

    def __delfield_exptime(self): del self.__field_exptime

    exptime=property(__getfield_exptime, __setfield_exptime, __delfield_exptime, None)

    def __getfield_zero3(self):
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        return self.__field_zero3.getvalue()

    def __setfield_zero3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero3=value
        else:
            self.__field_zero3=UNKNOWN(value,**{'sizeinbytes': 4,  'pad': 0 })

    def __delfield_zero3(self): del self.__field_zero3

    zero3=property(__getfield_zero3, __setfield_zero3, __delfield_zero3, None)

    def __getfield_one(self):
        try: self.__field_one
        except:
            self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        return self.__field_one.getvalue()

    def __setfield_one(self, value):
        if isinstance(value,UINT):
            self.__field_one=value
        else:
            self.__field_one=UINT(value,**{'sizeinbytes': 1,  'default': 1 })

    def __delfield_one(self): del self.__field_one

    one=property(__getfield_one, __setfield_one, __delfield_one, None)

    def __getfield_repeat(self):
        return self.__field_repeat.getvalue()

    def __setfield_repeat(self, value):
        if isinstance(value,UINT):
            self.__field_repeat=value
        else:
            self.__field_repeat=UINT(value,**{'sizeinbytes': 1})

    def __delfield_repeat(self): del self.__field_repeat

    repeat=property(__getfield_repeat, __setfield_repeat, __delfield_repeat, None)

    def __getfield_three(self):
        try: self.__field_three
        except:
            self.__field_three=UINT(**{'sizeinbytes': 1,  'default': 3 })
        return self.__field_three.getvalue()

    def __setfield_three(self, value):
        if isinstance(value,UINT):
            self.__field_three=value
        else:
            self.__field_three=UINT(value,**{'sizeinbytes': 1,  'default': 3 })

    def __delfield_three(self): del self.__field_three

    three=property(__getfield_three, __setfield_three, __delfield_three, None)

    def __getfield_alarm(self):
        return self.__field_alarm.getvalue()

    def __setfield_alarm(self, value):
        if isinstance(value,UINT):
            self.__field_alarm=value
        else:
            self.__field_alarm=UINT(value,**{'sizeinbytes': 1})

    def __delfield_alarm(self): del self.__field_alarm

    alarm=property(__getfield_alarm, __setfield_alarm, __delfield_alarm, None)

    def __getfield_alert(self):
        return self.__field_alert.getvalue()

    def __setfield_alert(self, value):
        if isinstance(value,UINT):
            self.__field_alert=value
        else:
            self.__field_alert=UINT(value,**{'sizeinbytes': 1})

    def __delfield_alert(self): del self.__field_alert

    alert=property(__getfield_alert, __setfield_alert, __delfield_alert, None)

    def __getfield_reminder(self):
        try: self.__field_reminder
        except:
            self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })
        return self.__field_reminder.getvalue()

    def __setfield_reminder(self, value):
        if isinstance(value,UINT):
            self.__field_reminder=value
        else:
            self.__field_reminder=UINT(value,**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })

    def __delfield_reminder(self): del self.__field_reminder

    reminder=property(__getfield_reminder, __setfield_reminder, __delfield_reminder, None)

    def __getfield_zero4(self):
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 5,  'pad': 0 })
        return self.__field_zero4.getvalue()

    def __setfield_zero4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero4=value
        else:
            self.__field_zero4=UNKNOWN(value,**{'sizeinbytes': 5,  'pad': 0 })

    def __delfield_zero4(self): del self.__field_zero4

    zero4=property(__getfield_zero4, __setfield_zero4, __delfield_zero4, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def __getfield_timezone(self):
        return self.__field_timezone.getvalue()

    def __setfield_timezone(self, value):
        if isinstance(value,UINT):
            self.__field_timezone=value
        else:
            self.__field_timezone=UINT(value,**{'sizeinbytes': 1})

    def __delfield_timezone(self): del self.__field_timezone

    timezone=property(__getfield_timezone, __setfield_timezone, __delfield_timezone, None)

    def __getfield_creationtime(self):
        return self.__field_creationtime.getvalue()

    def __setfield_creationtime(self, value):
        if isinstance(value,DateTime):
            self.__field_creationtime=value
        else:
            self.__field_creationtime=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_creationtime(self): del self.__field_creationtime

    creationtime=property(__getfield_creationtime, __setfield_creationtime, __delfield_creationtime, None)

    def __getfield_zero5(self):
        try: self.__field_zero5
        except:
            self.__field_zero5=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        return self.__field_zero5.getvalue()

    def __setfield_zero5(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero5=value
        else:
            self.__field_zero5=UNKNOWN(value,**{'sizeinbytes': 4,  'pad': 0 })

    def __delfield_zero5(self): del self.__field_zero5

    zero5=property(__getfield_zero5, __setfield_zero5, __delfield_zero5, None)

    def __getfield_modifiedtime(self):
        return self.__field_modifiedtime.getvalue()

    def __setfield_modifiedtime(self, value):
        if isinstance(value,DateTime):
            self.__field_modifiedtime=value
        else:
            self.__field_modifiedtime=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_modifiedtime(self): del self.__field_modifiedtime

    modifiedtime=property(__getfield_modifiedtime, __setfield_modifiedtime, __delfield_modifiedtime, None)

    def __getfield_zero6(self):
        try: self.__field_zero6
        except:
            self.__field_zero6=UNKNOWN(**{'sizeinbytes': 4,  'pad': 0 })
        return self.__field_zero6.getvalue()

    def __setfield_zero6(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero6=value
        else:
            self.__field_zero6=UNKNOWN(value,**{'sizeinbytes': 4,  'pad': 0 })

    def __delfield_zero6(self): del self.__field_zero6

    zero6=property(__getfield_zero6, __setfield_zero6, __delfield_zero6, None)

    def __getfield_ringtonelen(self):
        return self.__field_ringtonelen.getvalue()

    def __setfield_ringtonelen(self, value):
        if isinstance(value,UINT):
            self.__field_ringtonelen=value
        else:
            self.__field_ringtonelen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_ringtonelen(self): del self.__field_ringtonelen

    ringtonelen=property(__getfield_ringtonelen, __setfield_ringtonelen, __delfield_ringtonelen, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'sizeinbytes': self.ringtonelen,               'terminator': None })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_zero7(self):
        try: self.__field_zero7
        except:
            self.__field_zero7=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        return self.__field_zero7.getvalue()

    def __setfield_zero7(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero7=value
        else:
            self.__field_zero7=UNKNOWN(value,**{'sizeinbytes': 2,  'pad': 0 })

    def __delfield_zero7(self): del self.__field_zero7

    zero7=property(__getfield_zero7, __setfield_zero7, __delfield_zero7, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('titlelen', self.__field_titlelen, None)
        yield ('title', self.__field_title, None)
        yield ('start', self.__field_start, None)
        yield ('zero1', self.__field_zero1, None)
        yield ('start2', self.__field_start2, None)
        yield ('zero2', self.__field_zero2, None)
        yield ('exptime', self.__field_exptime, None)
        yield ('zero3', self.__field_zero3, None)
        yield ('one', self.__field_one, None)
        yield ('repeat', self.__field_repeat, None)
        yield ('three', self.__field_three, None)
        yield ('alarm', self.__field_alarm, None)
        yield ('alert', self.__field_alert, None)
        yield ('reminder', self.__field_reminder, None)
        yield ('zero4', self.__field_zero4, None)
        yield ('duration', self.__field_duration, None)
        yield ('timezone', self.__field_timezone, None)
        yield ('creationtime', self.__field_creationtime, None)
        yield ('zero5', self.__field_zero5, None)
        yield ('modifiedtime', self.__field_modifiedtime, None)
        yield ('zero6', self.__field_zero6, None)
        yield ('ringtonelen', self.__field_ringtonelen, None)
        yield ('ringtone', self.__field_ringtone, None)
        yield ('zero7', self.__field_zero7, None)




class cl_list(BaseProtogenClass):
    __fields=['index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_list,self).__init__(**dict)
        if self.__class__ is cl_list:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_list,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_list,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_index=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)




class cl_index_file(BaseProtogenClass):
    __fields=['incoming', 'outgoing', 'missed', 'dunno1', 'incoming_count', 'outgoing_count', 'missed_count']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_index_file,self).__init__(**dict)
        if self.__class__ is cl_index_file:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_index_file,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_index_file,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_incoming.writetobuffer(buf)
        self.__field_outgoing.writetobuffer(buf)
        self.__field_missed.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_incoming_count.writetobuffer(buf)
        self.__field_outgoing_count.writetobuffer(buf)
        self.__field_missed_count.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_incoming=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_incoming.readfrombuffer(buf)
        self.__field_outgoing=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_outgoing.readfrombuffer(buf)
        self.__field_missed=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_missed.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 992})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_incoming_count=UINT(**{'sizeinbytes': 4})
        self.__field_incoming_count.readfrombuffer(buf)
        self.__field_outgoing_count=UINT(**{'sizeinbytes': 4})
        self.__field_outgoing_count.readfrombuffer(buf)
        self.__field_missed_count=UINT(**{'sizeinbytes': 4})
        self.__field_missed_count.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_incoming(self):
        return self.__field_incoming.getvalue()

    def __setfield_incoming(self, value):
        if isinstance(value,LIST):
            self.__field_incoming=value
        else:
            self.__field_incoming=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_incoming(self): del self.__field_incoming

    incoming=property(__getfield_incoming, __setfield_incoming, __delfield_incoming, None)

    def __getfield_outgoing(self):
        return self.__field_outgoing.getvalue()

    def __setfield_outgoing(self, value):
        if isinstance(value,LIST):
            self.__field_outgoing=value
        else:
            self.__field_outgoing=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_outgoing(self): del self.__field_outgoing

    outgoing=property(__getfield_outgoing, __setfield_outgoing, __delfield_outgoing, None)

    def __getfield_missed(self):
        return self.__field_missed.getvalue()

    def __setfield_missed(self, value):
        if isinstance(value,LIST):
            self.__field_missed=value
        else:
            self.__field_missed=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_missed(self): del self.__field_missed

    missed=property(__getfield_missed, __setfield_missed, __delfield_missed, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 992})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_incoming_count(self):
        return self.__field_incoming_count.getvalue()

    def __setfield_incoming_count(self, value):
        if isinstance(value,UINT):
            self.__field_incoming_count=value
        else:
            self.__field_incoming_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_incoming_count(self): del self.__field_incoming_count

    incoming_count=property(__getfield_incoming_count, __setfield_incoming_count, __delfield_incoming_count, None)

    def __getfield_outgoing_count(self):
        return self.__field_outgoing_count.getvalue()

    def __setfield_outgoing_count(self, value):
        if isinstance(value,UINT):
            self.__field_outgoing_count=value
        else:
            self.__field_outgoing_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_outgoing_count(self): del self.__field_outgoing_count

    outgoing_count=property(__getfield_outgoing_count, __setfield_outgoing_count, __delfield_outgoing_count, None)

    def __getfield_missed_count(self):
        return self.__field_missed_count.getvalue()

    def __setfield_missed_count(self, value):
        if isinstance(value,UINT):
            self.__field_missed_count=value
        else:
            self.__field_missed_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_missed_count(self): del self.__field_missed_count

    missed_count=property(__getfield_missed_count, __setfield_missed_count, __delfield_missed_count, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('incoming', self.__field_incoming, None)
        yield ('outgoing', self.__field_outgoing, None)
        yield ('missed', self.__field_missed, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('incoming_count', self.__field_incoming_count, None)
        yield ('outgoing_count', self.__field_outgoing_count, None)
        yield ('missed_count', self.__field_missed_count, None)




class cl_file(BaseProtogenClass):
    __fields=['cl_type', 'number', 'datetime', 'dunno1', 'duration']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_file,self).__init__(**dict)
        if self.__class__ is cl_file:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_file,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_file,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cl_type.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_datetime.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_duration.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cl_type=UINT(**{'sizeinbytes': 1})
        self.__field_cl_type.readfrombuffer(buf)
        self.__field_number=STRING(**{'sizeinbytes': 51,  'terminator': 0 })
        self.__field_number.readfrombuffer(buf)
        self.__field_datetime=DateTime1(**{'sizeinbytes': 4})
        self.__field_datetime.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cl_type(self):
        return self.__field_cl_type.getvalue()

    def __setfield_cl_type(self, value):
        if isinstance(value,UINT):
            self.__field_cl_type=value
        else:
            self.__field_cl_type=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cl_type(self): del self.__field_cl_type

    cl_type=property(__getfield_cl_type, __setfield_cl_type, __delfield_cl_type, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{'sizeinbytes': 51,  'terminator': 0 })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime1):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime1(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cl_type', self.__field_cl_type, None)
        yield ('number', self.__field_number, None)
        yield ('datetime', self.__field_datetime, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('duration', self.__field_duration, None)




class PBEntry(BaseProtogenClass):
    __fields=['info', 'zero1', 'name', 'email', 'email2', 'home', 'work', 'cell', 'fax', 'cell2', 'datetime', 'group', 'ringtone', 'wallpaper', 'wallpaper_range']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PBEntry,self).__init__(**dict)
        if self.__class__ is PBEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PBEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PBEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_info.writetobuffer(buf)
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_zero1.writetobuffer(buf)
        if self.info & PB_FLG_NAME:
            self.__field_name.writetobuffer(buf)
        if self.info & PB_FLG_EMAIL:
            self.__field_email.writetobuffer(buf)
        if self.info & PB_FLG_EMAIL2:
            self.__field_email2.writetobuffer(buf)
        if self.info & PB_FLG_HOME:
            self.__field_home.writetobuffer(buf)
        if self.info & PB_FLG_WORK:
            self.__field_work.writetobuffer(buf)
        if self.info & PB_FLG_CELL:
            self.__field_cell.writetobuffer(buf)
        if self.info & PB_FLG_FAX:
            self.__field_fax.writetobuffer(buf)
        if self.info & PB_FLG_CELL2:
            self.__field_cell2.writetobuffer(buf)
        if self.info & PB_FLG_DATE:
            self.__field_datetime.writetobuffer(buf)
        if self.info & PB_FLG_GROUP:
            self.__field_group.writetobuffer(buf)
        if self.info & PB_FLG_CRINGTONE:
            self.__field_ringtone.writetobuffer(buf)
        if self.info & PB_FLG_WP:
            self.__field_wallpaper.writetobuffer(buf)
            self.__field_wallpaper_range.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_info=UINT(**{'sizeinbytes': 2})
        self.__field_info.readfrombuffer(buf)
        self.__field_zero1=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_zero1.readfrombuffer(buf)
        if self.info & PB_FLG_NAME:
            self.__field_name=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })
            self.__field_name.readfrombuffer(buf)
        if self.info & PB_FLG_EMAIL:
            self.__field_email=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })
            self.__field_email.readfrombuffer(buf)
        if self.info & PB_FLG_EMAIL2:
            self.__field_email2=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                   'pascal': True })
            self.__field_email2.readfrombuffer(buf)
        if self.info & PB_FLG_HOME:
            self.__field_home=NumberEntry()
            self.__field_home.readfrombuffer(buf)
        if self.info & PB_FLG_WORK:
            self.__field_work=NumberEntry()
            self.__field_work.readfrombuffer(buf)
        if self.info & PB_FLG_CELL:
            self.__field_cell=NumberEntry()
            self.__field_cell.readfrombuffer(buf)
        if self.info & PB_FLG_FAX:
            self.__field_fax=NumberEntry()
            self.__field_fax.readfrombuffer(buf)
        if self.info & PB_FLG_CELL2:
            self.__field_cell2=NumberEntry()
            self.__field_cell2.readfrombuffer(buf)
        if self.info & PB_FLG_DATE:
            self.__field_datetime=DateTime(**{'sizeinbytes': 4})
            self.__field_datetime.readfrombuffer(buf)
        if self.info & PB_FLG_GROUP:
            self.__field_group=UINT(**{'sizeinbytes': 1})
            self.__field_group.readfrombuffer(buf)
        if self.info & PB_FLG_CRINGTONE:
            self.__field_ringtone=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_ringtone.readfrombuffer(buf)
        if self.info & PB_FLG_WP:
            self.__field_wallpaper=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_wallpaper.readfrombuffer(buf)
            self.__field_wallpaper_range=UINT(**{'sizeinbytes': 4})
            self.__field_wallpaper_range.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_info(self):
        return self.__field_info.getvalue()

    def __setfield_info(self, value):
        if isinstance(value,UINT):
            self.__field_info=value
        else:
            self.__field_info=UINT(value,**{'sizeinbytes': 2})

    def __delfield_info(self): del self.__field_info

    info=property(__getfield_info, __setfield_info, __delfield_info, None)

    def __getfield_zero1(self):
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_zero1.getvalue()

    def __setfield_zero1(self, value):
        if isinstance(value,UINT):
            self.__field_zero1=value
        else:
            self.__field_zero1=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_zero1(self): del self.__field_zero1

    zero1=property(__getfield_zero1, __setfield_zero1, __delfield_zero1, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_email(self):
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def __getfield_email2(self):
        return self.__field_email2.getvalue()

    def __setfield_email2(self, value):
        if isinstance(value,USTRING):
            self.__field_email2=value
        else:
            self.__field_email2=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                   'pascal': True })

    def __delfield_email2(self): del self.__field_email2

    email2=property(__getfield_email2, __setfield_email2, __delfield_email2, None)

    def __getfield_home(self):
        return self.__field_home.getvalue()

    def __setfield_home(self, value):
        if isinstance(value,NumberEntry):
            self.__field_home=value
        else:
            self.__field_home=NumberEntry(value,)

    def __delfield_home(self): del self.__field_home

    home=property(__getfield_home, __setfield_home, __delfield_home, None)

    def __getfield_work(self):
        return self.__field_work.getvalue()

    def __setfield_work(self, value):
        if isinstance(value,NumberEntry):
            self.__field_work=value
        else:
            self.__field_work=NumberEntry(value,)

    def __delfield_work(self): del self.__field_work

    work=property(__getfield_work, __setfield_work, __delfield_work, None)

    def __getfield_cell(self):
        return self.__field_cell.getvalue()

    def __setfield_cell(self, value):
        if isinstance(value,NumberEntry):
            self.__field_cell=value
        else:
            self.__field_cell=NumberEntry(value,)

    def __delfield_cell(self): del self.__field_cell

    cell=property(__getfield_cell, __setfield_cell, __delfield_cell, None)

    def __getfield_fax(self):
        return self.__field_fax.getvalue()

    def __setfield_fax(self, value):
        if isinstance(value,NumberEntry):
            self.__field_fax=value
        else:
            self.__field_fax=NumberEntry(value,)

    def __delfield_fax(self): del self.__field_fax

    fax=property(__getfield_fax, __setfield_fax, __delfield_fax, None)

    def __getfield_cell2(self):
        return self.__field_cell2.getvalue()

    def __setfield_cell2(self, value):
        if isinstance(value,NumberEntry):
            self.__field_cell2=value
        else:
            self.__field_cell2=NumberEntry(value,)

    def __delfield_cell2(self): del self.__field_cell2

    cell2=property(__getfield_cell2, __setfield_cell2, __delfield_cell2, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_group(self):
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 1})

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_wallpaper(self):
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,STRING):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_wallpaper_range(self):
        return self.__field_wallpaper_range.getvalue()

    def __setfield_wallpaper_range(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper_range=value
        else:
            self.__field_wallpaper_range=UINT(value,**{'sizeinbytes': 4})

    def __delfield_wallpaper_range(self): del self.__field_wallpaper_range

    wallpaper_range=property(__getfield_wallpaper_range, __setfield_wallpaper_range, __delfield_wallpaper_range, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('info', self.__field_info, None)
        yield ('zero1', self.__field_zero1, None)
        if self.info & PB_FLG_NAME:
            yield ('name', self.__field_name, None)
        if self.info & PB_FLG_EMAIL:
            yield ('email', self.__field_email, None)
        if self.info & PB_FLG_EMAIL2:
            yield ('email2', self.__field_email2, None)
        if self.info & PB_FLG_HOME:
            yield ('home', self.__field_home, None)
        if self.info & PB_FLG_WORK:
            yield ('work', self.__field_work, None)
        if self.info & PB_FLG_CELL:
            yield ('cell', self.__field_cell, None)
        if self.info & PB_FLG_FAX:
            yield ('fax', self.__field_fax, None)
        if self.info & PB_FLG_CELL2:
            yield ('cell2', self.__field_cell2, None)
        if self.info & PB_FLG_DATE:
            yield ('datetime', self.__field_datetime, None)
        if self.info & PB_FLG_GROUP:
            yield ('group', self.__field_group, None)
        if self.info & PB_FLG_CRINGTONE:
            yield ('ringtone', self.__field_ringtone, None)
        if self.info & PB_FLG_WP:
            yield ('wallpaper', self.__field_wallpaper, None)
            yield ('wallpaper_range', self.__field_wallpaper_range, None)




