;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Llib/md5.scm                 */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May  6 14:35:24 2005                          */
;*    Last change :  Mon May  9 21:11:57 2005 (serrano)                */
;*    Copyright   :  2002-05 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    MD5 encryption                                                   */
;*    -------------------------------------------------------------    */
;*    Based on an implementation by Jens Axel Sgaard.                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __md5
   
   (use    __type
	   __bigloo
	   __tvector
	   __bexit
	   __bit
	   __r4_numbers_6_5_fixnum
	   __r4_numbers_6_5_flonum
	   __r4_booleans_6_1
	   __r4_symbols_6_4
	   __r4_vectors_6_8
	   __r4_control_features_6_9
	   __r4_pairs_and_lists_6_3
	   __r4_characters_6_6
	   __r4_equivalence_6_2 
	   __r4_strings_6_7
	   __r4_ports_6_10_1
	   __foreign
	   __error
	   __evenv
	   __os)

   (import __param)

   (export (md5sum::bstring ::bstring)))

;*---------------------------------------------------------------------*/
;*    md5sum ...                                                       */
;*---------------------------------------------------------------------*/
(define (md5sum str)
   (step3-4-5 (step1-2 str)))

;*---------------------------------------------------------------------*/
;*    step1-2 ...                                                      */
;*---------------------------------------------------------------------*/
(define (step1-2::bstring str)
   (define (byte-set! str offset int)
      (string-set! str offset (integer->char int)))
   (let* ((ilen (string-length str))
	  (blen (modulo (-fx 448 (*fx 8 ilen)) 512))
	  (plen (+fx 1 (quotient (-fx blen 1) 8)))
	  (olen (+fx ilen (+fx 8 plen)))
	  (padding (make-string olen #a000)))
      ;; fill with the initial sequence of bits
      (blit-string! str 0 padding 0 ilen)
      ;; add the padding
      (string-set! padding ilen #a128)
      ;; add the length padding (Bigloo string are smaller than 2^32 bytes)
      (byte-set! padding (-fx olen 5) (bit-and (bit-rsh ilen 21) 255))
      (byte-set! padding (-fx olen 6) (bit-and (bit-rsh ilen 13) 255))
      (byte-set! padding (-fx olen 7) (bit-and (bit-rsh ilen 5) 255))
      (byte-set! padding (-fx olen 8) (bit-and (bit-lsh ilen 3) 255))
      padding))

;*---------------------------------------------------------------------*/
;*    make-word ...                                                    */
;*---------------------------------------------------------------------*/
(define-macro (make-word hi lo)
   (if (and (integer? hi) (integer? lo))
       `'(,hi . ,lo)
       `(cons ,hi ,lo)))

;*---------------------------------------------------------------------*/
;*    bytes->word ...                                                  */
;*---------------------------------------------------------------------*/
(define (bytes->word a b c d)
   (cons (+fx (bit-lsh a 8) b)
	 (+fx (bit-lsh c 8) d)))

;*---------------------------------------------------------------------*/
;*    +w ...                                                           */
;*---------------------------------------------------------------------*/
(define (+w a b)
   (let ((t1 (+fx (car a) (car b)))
	 (t2 (+fx (cdr a) (cdr b))))
      (cons (bit-and (+fx t1 (bit-rsh t2 16)) 65535)
	    (bit-and t2 65535))))

;*---------------------------------------------------------------------*/
;*    +w4 ...                                                          */
;*---------------------------------------------------------------------*/
(define (+w4 a b c d)
   (+w (+w (+w a b) c) d))

;*---------------------------------------------------------------------*/
;*    word-or ...                                                      */
;*---------------------------------------------------------------------*/
(define (word-or a b)
   (make-word (bit-or (car a) (car b))
	      (bit-or (cdr a) (cdr b))))

;*---------------------------------------------------------------------*/
;*    word-not ...                                                     */
;*---------------------------------------------------------------------*/
(define (word-not a)
   (make-word (bit-and (bit-not (car a)) 65535)
	      (bit-and (bit-not (cdr a)) 65535)))

;*---------------------------------------------------------------------*/
;*    word-xor ...                                                     */
;*---------------------------------------------------------------------*/
(define (word-xor a b)
   (make-word (bit-xor (car a) (car b)) (bit-xor (cdr a) (cdr b))))

;*---------------------------------------------------------------------*/
;*    word-and ...                                                     */
;*---------------------------------------------------------------------*/
(define (word-and a b)
   (make-word (bit-and (car a) (car b)) (bit-and (cdr a) (cdr b))))

;*---------------------------------------------------------------------*/
;*    masks ...                                                        */
;*---------------------------------------------------------------------*/
(define masks
   '#(#x0 #x1 #x3 #x7 #xF #x1F #x3F #x7F #xFF
	  #x1FF #x3FF #x7FF #xFFF #x1FFF #x3FFF #x7FFF #xFFFF))

;*---------------------------------------------------------------------*/
;*    rot ...                                                          */
;*---------------------------------------------------------------------*/
(define (rot hi lo s)
   (make-word
    (bit-or (bit-lsh (bit-and hi (vector-ref masks (-fx 16 s))) s)
	    (bit-and (bit-rsh lo (-fx 16 s)) (vector-ref masks s)))
    (bit-or (bit-lsh (bit-and lo (vector-ref masks (-fx 16 s))) s)
	    (bit-and (bit-rsh hi (-fx 16 s)) (vector-ref masks s)))))

;*---------------------------------------------------------------------*/
;*    bit-lshw ...                                                     */
;*---------------------------------------------------------------------*/
(define-macro (bit-lshw a s)
   `(let ((w ,a))
       ,(cond
	   ((< 0 s 16)
	    `(rot (car w) (cdr w) ,s))
	   ((< s 32)
	    `(rot (cdr w) (car w) ,(- s 16)))
	   (else
	    (error 'bit-lshw "shift out of range: " s)))))

;*---------------------------------------------------------------------*/
;*    step3-4-5 ...                                                    */
;*---------------------------------------------------------------------*/
(define (step3-4-5 message)
   (define (F x y z)
      (word-or (word-and x y) (word-and (word-not x) z)))
   (define (G x y z)
      (word-or (word-and x z) (word-and y (word-not z))))
   (define (H x y z)
      (word-xor x (word-xor y z)))
   (define (II x y z)
      (word-xor y (word-or x (word-not z))))
   (define (string-word-at i)
      (bytes->word
       (char->integer (string-ref message (+fx i 3)))
       (char->integer (string-ref message (+fx i 2)))
       (char->integer (string-ref message (+fx i 1)))
       (char->integer (string-ref message i))))
   (let ((X (make-vector 16))
	 (l (string-length message)))
      (let loop ((A (bytes->word #x67 #x45 #x23 #x01))
		 (B (bytes->word #xef #xcd #xab #x89))
		 (C (bytes->word #x98 #xba #xdc #xfe))
		 (D (bytes->word #x10 #x32 #x54 #x76))
		 (i 0))
	 (if (>=fx i l)
	     (step5 A B C D)
	     (begin
		(let liip ((j 0))
		   (when (<fx j 16)
		      (vector-set! X j (string-word-at (+fx i (*fx 4 j))))
		      (liip (+fx j 1))))
		(let* ((AA A)
		       (BB B)
		       (CC C)
		       (DD D)
		       
		       (A (+w B (bit-lshw (+w4 A (F B C D) (vector-ref X 0) (make-word 55146 42104)) 7)))
		       (D (+w A (bit-lshw (+w4 D (F A B C) (vector-ref X 1) (make-word 59591 46934)) 12)))
		       (C (+w D (bit-lshw (+w4 C (F D A B) (vector-ref X 2) (make-word 9248 28891)) 17)))
		       (B (+w C (bit-lshw (+w4 B (F C D A) (vector-ref X 3) (make-word 49597 52974)) 22)))
		       (A (+w B (bit-lshw (+w4 A (F B C D) (vector-ref X 4) (make-word 62844 4015)) 7)))
		       (D (+w A (bit-lshw (+w4 D (F A B C) (vector-ref X 5) (make-word 18311 50730)) 12)))
		       (C (+w D (bit-lshw (+w4 C (F D A B) (vector-ref X 6) (make-word 43056 17939)) 17)))
		       (B (+w C (bit-lshw (+w4 B (F C D A) (vector-ref X 7) (make-word 64838 38145)) 22)))
		       (A (+w B (bit-lshw (+w4 A (F B C D) (vector-ref X 8) (make-word 27008 39128)) 7)))
		       (D (+w A (bit-lshw (+w4 D (F A B C) (vector-ref X 9) (make-word 35652 63407)) 12)))
		       (C (+w D (bit-lshw (+w4 C (F D A B) (vector-ref X 10) (make-word 65535 23473)) 17)))
		       (B (+w C (bit-lshw (+w4 B (F C D A) (vector-ref X 11) (make-word 35164 55230)) 22)))
		       (A (+w B (bit-lshw (+w4 A (F B C D) (vector-ref X 12) (make-word 27536 4386)) 7)))
		       (D (+w A (bit-lshw (+w4 D (F A B C) (vector-ref X 13) (make-word 64920 29075)) 12)))
		       (C (+w D (bit-lshw (+w4 C (F D A B) (vector-ref X 14) (make-word 42617 17294)) 17)))
		       (B (+w C (bit-lshw (+w4 B (F C D A) (vector-ref X 15) (make-word 18868 2081)) 22)))
		       
		       (A (+w B (bit-lshw (+w4 A (G B C D) (vector-ref X 1) (make-word 63006 9570)) 5)))
		       (D (+w A (bit-lshw (+w4 D (G A B C) (vector-ref X 6) (make-word 49216 45888)) 9)))
		       (C (+w D (bit-lshw (+w4 C (G D A B) (vector-ref X 11) (make-word 9822 23121)) 14)))
		       (B (+w C (bit-lshw (+w4 B (G C D A) (vector-ref X 0) (make-word 59830 51114)) 20)))
		       (A (+w B (bit-lshw (+w4 A (G B C D) (vector-ref X 5) (make-word 54831 4189)) 5)))
		       (D (+w A (bit-lshw (+w4 D (G A B C) (vector-ref X 10) (make-word 580 5203)) 9)))
		       (C (+w D (bit-lshw (+w4 C (G D A B) (vector-ref X 15) (make-word 55457 59009)) 14)))
		       (B (+w C (bit-lshw (+w4 B (G C D A) (vector-ref X 4) (make-word 59347 64456)) 20)))
		       (A (+w B (bit-lshw (+w4 A (G B C D) (vector-ref X 9) (make-word 8673 52710)) 5)))
		       (D (+w A (bit-lshw (+w4 D (G A B C) (vector-ref X 14) (make-word 49975 2006)) 9)))
		       (C (+w D (bit-lshw (+w4 C (G D A B) (vector-ref X 3) (make-word 62677 3463)) 14)))
		       (B (+w C (bit-lshw (+w4 B (G C D A) (vector-ref X 8) (make-word 17754 5357)) 20)))
		       (A (+w B (bit-lshw (+w4 A (G B C D) (vector-ref X 13) (make-word 43491 59653)) 5)))
		       (D (+w A (bit-lshw (+w4 D (G A B C) (vector-ref X 2) (make-word 64751 41976)) 9)))
		       (C (+w D (bit-lshw (+w4 C (G D A B) (vector-ref X 7) (make-word 26479 729)) 14)))
		       (B (+w C (bit-lshw (+w4 B (G C D A) (vector-ref X 12) (make-word 36138 19594)) 20)))

		       
		       (A (+w B (bit-lshw (+w4 A (H B C D) (vector-ref X 5) (make-word 65530 14658)) 4)))
		       (D (+w A (bit-lshw (+w4 D (H A B C) (vector-ref X 8) (make-word 34673 63105)) 11)))
		       (C (+w D (bit-lshw (+w4 C (H D A B) (vector-ref X 11) (make-word 28061 24866)) 16)))
		       (B (+w C (bit-lshw (+w4 B (H C D A) (vector-ref X 14) (make-word 64997 14348)) 23)))
		       (A (+w B (bit-lshw (+w4 A (H B C D) (vector-ref X 1) (make-word 42174 59972)) 4)))
		       (D (+w A (bit-lshw (+w4 D (H A B C) (vector-ref X 4) (make-word 19422 53161)) 11)))
		       (C (+w D (bit-lshw (+w4 C (H D A B) (vector-ref X 7) (make-word 63163 19296)) 16)))
		       (B (+w C (bit-lshw (+w4 B (H C D A) (vector-ref X 10) (make-word 48831 48240)) 23)))
		       (A (+w B (bit-lshw (+w4 A (H B C D) (vector-ref X 13) (make-word 10395 32454)) 4)))
		       (D (+w A (bit-lshw (+w4 D (H A B C) (vector-ref X 0) (make-word 60065 10234)) 11)))
		       (C (+w D (bit-lshw (+w4 C (H D A B) (vector-ref X 3) (make-word 54511 12421)) 16)))
		       (B (+w C (bit-lshw (+w4 B (H C D A) (vector-ref X 6) (make-word 1160 7429)) 23)))
		       (A (+w B (bit-lshw (+w4 A (H B C D) (vector-ref X 9) (make-word 55764 53305)) 4)))
		       (D (+w A (bit-lshw (+w4 D (H A B C) (vector-ref X 12) (make-word 59099 39397)) 11)))
		       (C (+w D (bit-lshw (+w4 C (H D A B) (vector-ref X 15) (make-word 8098 31992)) 16)))
		       (B (+w C (bit-lshw (+w4 B (H C D A) (vector-ref X 2) (make-word 50348 22117)) 23)))

		       
		       (A (+w B (bit-lshw (+w4 A (II B C D) (vector-ref X 0) (make-word 62505 8772)) 6)))
		       (D (+w A (bit-lshw (+w4 D (II A B C) (vector-ref X 7) (make-word 17194 65431)) 10)))
		       (C (+w D (bit-lshw (+w4 C (II D A B) (vector-ref X 14) (make-word 43924 9127)) 15)))
		       (B (+w C (bit-lshw (+w4 B (II C D A) (vector-ref X 5) (make-word 64659 41017)) 21)))
		       (A (+w B (bit-lshw (+w4 A (II B C D) (vector-ref X 12) (make-word 25947 22979)) 6)))
		       (D (+w A (bit-lshw (+w4 D (II A B C) (vector-ref X 3) (make-word 36620 52370)) 10)))
		       (C (+w D (bit-lshw (+w4 C (II D A B) (vector-ref X 10) (make-word 65519 62589)) 15)))
		       (B (+w C (bit-lshw (+w4 B (II C D A) (vector-ref X 1) (make-word 34180 24017)) 21)))
		       (A (+w B (bit-lshw (+w4 A (II B C D) (vector-ref X 8) (make-word 28584 32335)) 6)))
		       (D (+w A (bit-lshw (+w4 D (II A B C) (vector-ref X 15) (make-word 65068 59104)) 10)))
		       (C (+w D (bit-lshw (+w4 C (II D A B) (vector-ref X 6) (make-word 41729 17172)) 15)))
		       (B (+w C (bit-lshw (+w4 B (II C D A) (vector-ref X 13) (make-word 19976 4513)) 21)))
		       (A (+w B (bit-lshw (+w4 A (II B C D) (vector-ref X 4) (make-word 63315 32386)) 6)))
		       (D (+w A (bit-lshw (+w4 D (II A B C) (vector-ref X 11) (make-word 48442 62005)) 10)))
		       (C (+w D (bit-lshw (+w4 C (II D A B) (vector-ref X 2) (make-word 10967 53947)) 15)))
		       (B (+w C (bit-lshw (+w4 B (II C D A) (vector-ref X 9) (make-word 60294 54161)) 21)))
		       
		       (A (+w A AA)) 
		       (B (+w B BB))
		       (C (+w C CC)) 
		       (D (+w D DD)))
		   
		   (loop A B C D (+fx i 64))))))))

;*---------------------------------------------------------------------*/
;*    step5 ...                                                        */
;*---------------------------------------------------------------------*/
(define (step5 a b c d)
   (define (string-hex-at! r i h)
      (let ((s "0123456789abcdef"))
	 (if (>=fx h 16)
	     (begin
		(string-set! r (+fx i 1) (string-ref s (bit-and h #xf)))
		(string-set! r i (string-ref s (bit-and (bit-rsh h 4) #xf))))
	     (string-set! r (+fx i 1) (string-ref s h)))))
   (define (string-word-at! r i w)
      (string-hex-at! r i (bit-and (cdr w) #xff))
      (string-hex-at! r (+fx i 2) (bit-and (bit-rsh (cdr w) 8) #xff))
      (string-hex-at! r (+fx i 4) (bit-and (car w) #xff))
      (string-hex-at! r (+fx i 6) (bit-and (bit-rsh (car w) 8) #xff)))
   (let ((s (make-string 32 #\0)))
      (string-word-at! s 0 a)
      (string-word-at! s 8 b)
      (string-word-at! s 16 c)
      (string-word-at! s 24 d)
      s))
